/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.activiti.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.activiti.entity.ActivitiBusinessEntity;
import com.biz.crm.activiti.entity.TaActFileEntity;
import com.biz.crm.activiti.entity.TaActTargetEntity;
import com.biz.crm.activiti.mapper.ActReModelMapper;
import com.biz.crm.activiti.mapper.ActivitiBusinessMapper;
import com.biz.crm.activiti.mapper.TaActFileMapper;
import com.biz.crm.activiti.mapper.TaActTargetMapper;
import com.biz.crm.base.BaseServiceHelper;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.nebular.activiti.act.resp.TaActFileRespVo;
import com.biz.crm.nebular.activiti.act.resp.TaActTargetRespVo;
import com.biz.crm.nebular.activiti.vo.ActGeByteArrayVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionUserOrgReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.Result;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActivitiBusinessHelper
extends BaseServiceHelper {
    private static final Logger log = LoggerFactory.getLogger(ActivitiBusinessHelper.class);
    @Resource
    private TaActFileMapper actFileMapper;
    @Resource
    private ActivitiBusinessMapper activitiBusinessMapper;
    @Resource
    private TaActTargetMapper actTargetMapper;
    @Autowired
    private MdmPositionFeign positionFeign;
    @Resource
    private ActReModelMapper modelMapper;

    public String computeProcessTotalHandleTime(String createDateAll, String endDateString) {
        if (StringUtils.isNotEmpty((CharSequence)createDateAll) && StringUtils.isNotEmpty((CharSequence)endDateString)) {
            Date date = DateUtil.str2Date((String)createDateAll, (SimpleDateFormat)DateUtil.datetimeFormat);
            Date nowDate = DateUtil.str2Date((String)endDateString, (SimpleDateFormat)DateUtil.datetimeFormat);
            long time = date.getTime();
            long nowDateTime = nowDate.getTime();
            long l = nowDateTime - time;
            StringBuffer stringBuffer = new StringBuffer();
            long l1 = l / 86400000L;
            stringBuffer.append(l1).append("\u5929");
            long l2 = l - l1 * 86400000L;
            long l3 = l2 / 3600000L;
            stringBuffer.append(l3).append("\u5c0f\u65f6");
            long l4 = l2 - l3 * 3600000L;
            long l5 = l4 / 60000L;
            stringBuffer.append(l5).append("\u5206");
            return stringBuffer.toString();
        }
        return null;
    }

    public List<TaActFileRespVo> findActFileByProcessInstanceId(String processInstanceId) {
        if (StringUtils.isEmpty((CharSequence)processInstanceId)) {
            return Lists.newArrayList();
        }
        List taActFileEntities = this.actFileMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TaActFileEntity.class).eq(TaActFileEntity::getProcessInstId, (Object)processInstanceId)).orderByDesc(CrmBaseEntity::getCreateDateAll));
        return CrmBeanUtil.copyList((List)taActFileEntities, TaActFileRespVo.class);
    }

    public List<TaActTargetRespVo> findActTargetConfigByProcessKey(String processKey) {
        if (StringUtils.isEmpty((CharSequence)processKey)) {
            return Lists.newArrayList();
        }
        List entities = this.actTargetMapper.selectList((Wrapper)Wrappers.lambdaQuery(TaActTargetEntity.class).eq(TaActTargetEntity::getProcessKey, (Object)processKey));
        return CrmBeanUtil.copyList((List)entities, TaActTargetRespVo.class);
    }

    public ActivitiBusinessEntity findActivitiBusinessEntityByInstanceId(String processInstanceId) {
        ActivitiBusinessEntity businessEntity = (ActivitiBusinessEntity)this.activitiBusinessMapper.selectOne((Wrapper)Wrappers.lambdaQuery(ActivitiBusinessEntity.class).eq(ActivitiBusinessEntity::getProcessInstanceId, (Object)processInstanceId));
        return businessEntity;
    }

    public Map<String, MdmPositionUserOrgRespVo> findPositionMapByCodes(List<String> positionCodes) {
        Map<Object, Object> positionMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(positionCodes)) {
            MdmPositionUserOrgReqVo reqVo = new MdmPositionUserOrgReqVo();
            reqVo.setPositionCodeList(positionCodes);
            reqVo.setIncludeEmptyUserPosition(Boolean.valueOf(true));
            List positionByCodeList = Lists.newArrayList();
            try {
                Result positionUserOrgList = this.positionFeign.findPositionUserOrgList(reqVo);
                positionByCodeList = (List)positionUserOrgList.getResult();
            }
            catch (Exception e) {
                log.error("\u8c03\u7528Mdm\u83b7\u53d6\u804c\u4f4d\u6570\u636e\u5f02\u5e38,e={}", (Throwable)e);
            }
            if (CollectionUtils.isNotEmpty((Collection)positionByCodeList)) {
                positionMap = positionByCodeList.stream().collect(Collectors.toMap(MdmPositionUserOrgRespVo::getPositionCode, Function.identity()));
            }
        }
        return positionMap;
    }

    public ActGeByteArrayVo findProcessXmlByDeploymentId(String deploymentId) {
        ActGeByteArrayVo vo = this.modelMapper.findProcessXmlByDeploymentId(deploymentId);
        return vo;
    }
}

