/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.activiti.service.impl;

import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.biz.crm.activiti.entity.ActivitiBusinessEntity;
import com.biz.crm.activiti.entity.ActivitiCurrentTaskEntity;
import com.biz.crm.activiti.service.ActivitiCurrentTaskService;
import com.biz.crm.activiti.service.ActivitiTaskService;
import com.biz.crm.activiti.service.impl.ActivitiBusinessHelper;
import com.biz.crm.mdm.function.MdmFunctionFeign;
import com.biz.crm.nebular.activiti.task.req.FormParamQueryReqVO;
import com.biz.crm.nebular.activiti.task.resp.FormParamQueryRspVO;
import com.biz.crm.nebular.activiti.vo.ActivitiCurrentTaskVo;
import com.biz.crm.nebular.mdm.function.MdmFunctionReqVo;
import com.biz.crm.nebular.mdm.function.MdmFunctionRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.Result;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"ActivitiTaskExpandServiceImpl"})
public class ActivitiTaskServiceImpl
implements ActivitiTaskService {
    private static final Logger log = LoggerFactory.getLogger(ActivitiTaskServiceImpl.class);
    @Autowired
    private ActivitiCurrentTaskService activitiCurrentTaskService;
    @Autowired
    private ActivitiBusinessHelper helper;
    @Autowired
    private MdmFunctionFeign mdmFunctionFeign;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveTask(ActivitiCurrentTaskVo activitiCurrentTaskVo) {
        log.info("\u4fdd\u5b58\u5f53\u524d\u4efb\u52a1");
        ActivitiCurrentTaskEntity activitiCurrentTaskEntity = new ActivitiCurrentTaskEntity();
        BeanUtils.copyProperties((Object)activitiCurrentTaskVo, (Object)activitiCurrentTaskEntity);
        activitiCurrentTaskEntity.setTaskNo(CodeUtil.getCodeDefault());
        this.activitiCurrentTaskService.saveCurrentTask(activitiCurrentTaskEntity);
    }

    @Override
    public FormParamQueryRspVO getProcessFormParam(FormParamQueryReqVO reqVO) {
        AssertUtils.isNotEmpty((String)reqVO.getProcessInstanceId(), (String)"\u6d41\u7a0b\u5b9e\u4f8bID\u4e0d\u80fd\u4e3a\u7a7a");
        FormParamQueryRspVO rspVO = new FormParamQueryRspVO();
        ActivitiBusinessEntity businessEntity = this.helper.findActivitiBusinessEntityByInstanceId(reqVO.getProcessInstanceId());
        AssertUtils.isNotNull((Object)businessEntity, (String)("\u6d41\u7a0b\u5b9e\u4f8bid\uff1a" + reqVO.getProcessInstanceId() + "\u5bf9\u5e94\u7684\u6d41\u7a0b\u6570\u636e\u4e0d\u5b58\u5728"));
        if (StringUtils.isNotEmpty((CharSequence)businessEntity.getMenuCode())) {
            MdmFunctionReqVo reqVo = new MdmFunctionReqVo();
            reqVo.setFunctionCode(businessEntity.getMenuCode());
            Result result = this.mdmFunctionFeign.query(reqVo);
            AssertUtils.isTrue((boolean)result.isSuccess(), (String)(businessEntity.getMenuCode() + "\u8c03\u7528feign\u83b7\u53d6\u83dc\u5355\u7f16\u7801\u5bf9\u5e94\u7684\u5355\u636e\u7f16\u7801\u5931\u8d25\uff01"));
            MdmFunctionRespVo mdmFunctionRespVo = (MdmFunctionRespVo)result.getResult();
            if (ObjectUtils.isNotNull((Object[])new Object[]{mdmFunctionRespVo}) && StringUtils.isNotEmpty((CharSequence)mdmFunctionRespVo.getRelationBillCode())) {
                rspVO.setUrlParam(mdmFunctionRespVo.getRelationBillCode());
            }
        }
        rspVO.setId(businessEntity.getBusinessId());
        rspVO.setStatus(false);
        if (StringUtils.isNotEmpty((CharSequence)reqVO.getCopyTaskId())) {
            rspVO.setStatus(false);
        }
        return rspVO;
    }
}

