/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.activiti.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.activiti.entity.ActReModelEntity;
import com.biz.crm.activiti.entity.ActivitiBusinessEntity;
import com.biz.crm.activiti.entity.TaActFileEntity;
import com.biz.crm.activiti.mapper.ActReModelMapper;
import com.biz.crm.activiti.mapper.ActivitiBusinessMapper;
import com.biz.crm.activiti.mapper.ActivitiCurrentTaskMapper;
import com.biz.crm.activiti.service.ActivitiBusinessService;
import com.biz.crm.activiti.service.ActivitiTaskService;
import com.biz.crm.activiti.service.ActivityTaskUtil;
import com.biz.crm.activiti.service.BizRuntimeService;
import com.biz.crm.activiti.service.ITaActFileService;
import com.biz.crm.activiti.service.impl.ActivitiBusinessHelper;
import com.biz.crm.annotation.Klock;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.bpmlog.entity.ActivitiBpmlogEntity;
import com.biz.crm.bpmlog.mapper.ActivitiBpmlogMapper;
import com.biz.crm.bpmlog.service.ActivitiBpmlogService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.activiti.ActivitiOperateTypeEnum;
import com.biz.crm.eunm.activiti.Indicator;
import com.biz.crm.mdm.bpmrole.MdmBpmRoleFeign;
import com.biz.crm.nebular.activiti.act.resp.TaActFileRespVo;
import com.biz.crm.nebular.activiti.act.resp.TaActTargetRespVo;
import com.biz.crm.nebular.activiti.start.req.OptRecordReqVO;
import com.biz.crm.nebular.activiti.task.resp.OptLogsRspVO;
import com.biz.crm.nebular.activiti.task.resp.OptRecordRspVO;
import com.biz.crm.nebular.activiti.task.resp.ProcessSummaryRspVO;
import com.biz.crm.nebular.activiti.vo.ActivitiBusinessVo;
import com.biz.crm.nebular.activiti.vo.ActivitiCurrentTaskVo;
import com.biz.crm.nebular.activiti.vo.BpmQueryVo;
import com.biz.crm.nebular.activiti.vo.CompleteTaskVo;
import com.biz.crm.nebular.activiti.vo.CurrentTaskVo;
import com.biz.crm.nebular.activiti.vo.CurrentVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.PositionUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngineConfiguration;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.TransitionImpl;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.activiti.image.ProcessDiagramGenerator;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizRuntimeServiceImpl
implements BizRuntimeService {
    private static final Logger log = LoggerFactory.getLogger(BizRuntimeServiceImpl.class);
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private IdentityService identityService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ProcessEngineConfiguration processEngineConfiguration;
    @Autowired
    private ActivitiBusinessService activitiBusinessService;
    @Autowired
    private ActivitiBpmlogService activitiBpmlogService;
    @Resource
    private ActivitiBpmlogMapper logMapper;
    @Autowired
    private ActivitiTaskService activitiTaskService;
    @Autowired
    private ActivityTaskUtil activityTaskUtil;
    @Resource
    private ActivitiCurrentTaskMapper activitiCurrentTaskMapper;
    @Resource
    private MdmBpmRoleFeign mdmBpmRoleFeign;
    @Autowired
    private ITaActFileService fileService;
    @Resource
    private ActReModelMapper actReModelMapper;
    @Resource
    private ActivitiBusinessMapper activitiBusinessMapper;
    @Autowired
    private ActivitiBusinessHelper helper;

    private ProcessInstance startProcessInstanceByKey(String processKey, String businessObjIdOrNum, Map<String, Object> variables) {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(processKey, businessObjIdOrNum, variables);
        return processInstance;
    }

    @Override
    @Klock(keys={"#activitiBusinessVo.businessId"}, waitTime=60L, leaseTime=300L)
    @Transactional(rollbackFor={Exception.class})
    public String startProcess(ActivitiBusinessVo activitiBusinessVo) {
        UserRedis userRedis = UserUtils.getUser();
        log.info("\u63d0\u4ea4\u5de5\u4f5c\u6d41", (Object)activitiBusinessVo);
        this.checkStartProcess(activitiBusinessVo, userRedis);
        this.identityService.setAuthenticatedUserId(activitiBusinessVo.getPositionCode());
        Map variables = activitiBusinessVo.getVariables();
        if (activitiBusinessVo.getVariables() != null && !activitiBusinessVo.getVariables().isEmpty()) {
            variables.putAll(activitiBusinessVo.getVariables());
        }
        variables.put("COMMIT_ORG_", userRedis.getOrgcode());
        variables.put("COMMIT_POS_", userRedis.getPoscode());
        ProcessInstance processInstance = this.startProcessInstanceByKey(activitiBusinessVo.getProcessKey(), activitiBusinessVo.getBusinessId(), variables);
        if (processInstance == null) {
            throw new BusinessException("\u53d1\u8d77\u6d41\u7a0b\u5931\u8d25");
        }
        if (StringUtils.isEmpty((CharSequence)processInstance.getId())) {
            throw new BusinessException("\u53d1\u8d77\u6d41\u7a0b\u5931\u8d25");
        }
        ActivitiBusinessEntity entity = this.activitiBusinessService.save(processInstance, activitiBusinessVo);
        StringBuffer buffer = new StringBuffer();
        buffer.append(userRedis.getRealname()).append("[").append(activitiBusinessVo.getPositionCode()).append("]").append("\u53d1\u8d77\u6d41\u7a0b");
        ActivitiCurrentTaskVo currentTaskVo = new ActivitiCurrentTaskVo(entity.getCrmProcessInstanceId(), entity.getProcessInstanceId(), "5", activitiBusinessVo.getProcessTitle(), userRedis.getRealname(), activitiBusinessVo.getPositionCode());
        this.activitiTaskService.saveTask(currentTaskVo);
        ProcessInstance processInstanceNow = this.activityTaskUtil.getProcessInstance(entity.getProcessInstanceId(), null);
        if (processInstanceNow != null) {
            CurrentVo currentVo = this.activityTaskUtil.getCurrentVo(entity.getProcessInstanceId(), null);
            this.saveCurrentTask(currentVo, currentTaskVo);
        }
        this.activitiBpmlogService.commomSaveLog(entity.getCrmProcessInstanceId(), entity.getProcessInstanceId(), activitiBusinessVo.getBusinessId(), buffer.toString(), ActivitiOperateTypeEnum.START.getCode());
        if (CollectionUtil.collectionNotEmpty((Collection)activitiBusinessVo.getAttachmentVos())) {
            List fileEntities = activitiBusinessVo.getAttachmentVos().stream().map(file -> {
                TaActFileEntity fileEntity = new TaActFileEntity();
                fileEntity.setFileAddress(file.getFileAddress());
                fileEntity.setObjectName(file.getObjectName());
                fileEntity.setFileType(Integer.valueOf(Indicator.ACTIVITI_FILE_START.getCode()));
                fileEntity.setProcessInstId(entity.getProcessInstanceId());
                return fileEntity;
            }).collect(Collectors.toList());
            this.fileService.saveBatch(fileEntities);
        }
        return entity.getCrmProcessInstanceId();
    }

    private void saveCurrentTask(CurrentVo currentVo, ActivitiCurrentTaskVo vo) {
        Set bpmRoleCode;
        if (currentVo == null) {
            return;
        }
        Set positionCode = currentVo.getPositionCode();
        if (positionCode != null && !positionCode.isEmpty()) {
            positionCode.forEach(item -> {
                ActivitiCurrentTaskVo currentTaskVo = new ActivitiCurrentTaskVo();
                BeanUtils.copyProperties((Object)vo, (Object)currentTaskVo);
                currentTaskVo.setDateType("1");
                currentTaskVo.setPositionCode(item);
                currentTaskVo.setBpmRoeCode(null);
                this.activitiTaskService.saveTask(currentTaskVo);
            });
        }
        if ((bpmRoleCode = currentVo.getBpmRoleCode()) != null && !bpmRoleCode.isEmpty()) {
            bpmRoleCode.forEach(item -> {
                ActivitiCurrentTaskVo currentTaskVo = new ActivitiCurrentTaskVo();
                BeanUtils.copyProperties((Object)vo, (Object)currentTaskVo);
                currentTaskVo.setDateType("1");
                currentTaskVo.setPositionCode(null);
                currentTaskVo.setBpmRoeCode(item);
                this.activitiTaskService.saveTask(currentTaskVo);
            });
        }
    }

    private void checkStartProcess(ActivitiBusinessVo activitiBusinessVo, UserRedis userRedis) {
        if (StringUtils.isEmpty((CharSequence)activitiBusinessVo.getProcessKey())) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u9700\u8981\u63d0\u4ea4\u7684\u6d41\u7a0b\u3010processKey\u3011");
        }
        if (StringUtils.isEmpty((CharSequence)activitiBusinessVo.getBusinessId())) {
            throw new BusinessException("\u4e1a\u52a1\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\u3010businessId\u3011");
        }
        if (StringUtils.isEmpty((CharSequence)activitiBusinessVo.getPositionCode())) {
            throw new BusinessException("\u5f53\u524d\u63d0\u4ea4\u4eba\u4e0d\u80fd\u4e3a\u7a7a\u3010positionCode\u3011");
        }
        ActReModelEntity actReModelEntity = (ActReModelEntity)this.actReModelMapper.selectOne((Wrapper)Wrappers.lambdaQuery(ActReModelEntity.class).eq(ActReModelEntity::getKey, (Object)activitiBusinessVo.getProcessKey()));
        AssertUtils.isNotNull((Object)actReModelEntity, (String)("\u60a8\u9009\u62e9\u7684\u6d41\u7a0b[" + activitiBusinessVo.getProcessKey() + "]\u5df2\u7ecf\u4e0d\u5b58\u5728,\u8bf7\u91cd\u65b0\u9009\u62e9"));
        activitiBusinessVo.setProcessName(actReModelEntity.getName());
        if (StringUtils.equals((CharSequence)activitiBusinessVo.getPositionCode(), (CharSequence)userRedis.getPoscode())) {
            activitiBusinessVo.setCommitCode(userRedis.getUsername());
            activitiBusinessVo.setCommitByOrg(userRedis.getOrgcode());
            activitiBusinessVo.setCommitByOrgName(userRedis.getOrgname());
            activitiBusinessVo.setCommitPos(userRedis.getPoscode());
            activitiBusinessVo.setCommitPosName(userRedis.getPosname());
            activitiBusinessVo.setCommitName(userRedis.getUsername());
        }
        this.activityTaskUtil.checkRepeatCommit(activitiBusinessVo.getBusinessId());
    }

    @Override
    public PageResult<CurrentTaskVo> listByPositionCode(BpmQueryVo bpmQueryVo) {
        String positionCode = bpmQueryVo.getPositionCode();
        if (StringUtils.isEmpty((CharSequence)positionCode)) {
            UserRedis userRedis = UserUtils.getUser();
            positionCode = userRedis.getPoscode();
        }
        AssertUtils.isNotEmpty((String)positionCode, (String)"\u5f53\u524d\u767b\u5f55\u4eba\u672a\u83b7\u53d6\u5230\u804c\u4f4d\u4fe1\u606f");
        ArrayList<String> positionCodes = new ArrayList<String>();
        positionCodes.add(positionCode);
        Set bpmRoleCodeSet = (Set)ApiResultUtil.objResult((Result)this.mdmBpmRoleFeign.findBpmRoleCodeSetByPositionCodeList(positionCodes), (boolean)true);
        bpmRoleCodeSet = bpmRoleCodeSet == null ? new HashSet() : bpmRoleCodeSet;
        Page page = PageUtil.buildPage((Integer)bpmQueryVo.getPageNum(), (Integer)bpmQueryVo.getPageSize());
        List<CurrentTaskVo> list = this.activitiCurrentTaskMapper.listByPositionCode(page, positionCode, new ArrayList<String>(bpmRoleCodeSet));
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<CurrentTaskVo> listMyBpm(BpmQueryVo bpmQueryVo) {
        UserRedis userRedis = UserUtils.getUser();
        List positionRespVos = PositionUtil.getAllPositionByUsername((String)userRedis.getUsername());
        HashSet<String> set = new HashSet<String>();
        for (MdmPositionRespVo item : positionRespVos) {
            set.add(item.getPositionCode());
        }
        Page page = PageUtil.buildPage((Integer)bpmQueryVo.getPageNum(), (Integer)bpmQueryVo.getPageSize());
        List<CurrentTaskVo> list = this.activitiCurrentTaskMapper.listMyBpm(page, new ArrayList<String>(set));
        if (CollectionUtils.isNotEmpty(list)) {
            ArrayList positionCodes = Lists.newArrayList();
            list.stream().forEach(o -> {
                if (StringUtils.isNotEmpty((CharSequence)o.getCurrentTaskPositionCode())) {
                    positionCodes.add(o.getCurrentTaskPositionCode());
                }
            });
            Map<String, MdmPositionUserOrgRespVo> positionRespVoMap = this.helper.findPositionMapByCodes(positionCodes);
            list.forEach(o -> {
                MdmPositionUserOrgRespVo mdmPositionRespVo = (MdmPositionUserOrgRespVo)positionRespVoMap.get(o.getCurrentTaskPositionCode());
                if (Objects.nonNull(mdmPositionRespVo)) {
                    o.setCurrentTaskPositionName(mdmPositionRespVo.getPositionName());
                    o.setCurrentTaskUserCode(mdmPositionRespVo.getUserName());
                    o.setCurrentTaskUserName(mdmPositionRespVo.getFullName());
                }
                o.setBpmStatusName(ActivitiOperateTypeEnum.getStatusNameByCode((String)o.getBpmStatus()));
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<CurrentTaskVo> listMyRejectBpm(BpmQueryVo bpmQueryVo) {
        UserRedis userRedis = UserUtils.getUser();
        List positionRespVos = PositionUtil.getAllPositionByUsername((String)userRedis.getUsername());
        HashSet<String> set = new HashSet<String>();
        for (MdmPositionRespVo item : positionRespVos) {
            set.add(item.getPositionCode());
        }
        Page page = PageUtil.buildPage((Integer)bpmQueryVo.getPageNum(), (Integer)bpmQueryVo.getPageSize());
        List<CurrentTaskVo> list = this.activitiCurrentTaskMapper.listMyBpm(page, new ArrayList<String>(set));
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public InputStream getProcessInstancePicInfo(String processInstanceId) {
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processInstance.getProcessDefinitionId());
        Context.setProcessEngineConfiguration((ProcessEngineConfigurationImpl)((ProcessEngineConfigurationImpl)this.processEngineConfiguration));
        ProcessDiagramGenerator diagramGenerator = this.processEngineConfiguration.getProcessDiagramGenerator();
        ProcessDefinitionEntity definitionEntity = (ProcessDefinitionEntity)this.repositoryService.getProcessDefinition(processInstance.getProcessDefinitionId());
        List highLightedActivitList = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).list();
        ArrayList<String> highLightedActivitis = new ArrayList<String>();
        List<String> highLightedFlows = this.activityTaskUtil.getHighLightedFlows(definitionEntity, highLightedActivitList);
        for (HistoricActivityInstance tempActivity : highLightedActivitList) {
            String activityId = tempActivity.getActivityId();
            highLightedActivitis.add(activityId);
        }
        InputStream imageStream = diagramGenerator.generateDiagram(bpmnModel, "png", highLightedActivitis, highLightedFlows, "\u5b8b\u4f53", "\u5b8b\u4f53", "\u5b8b\u4f53", null, 1.0);
        return imageStream;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void completeTasks(CompleteTaskVo completeTaskVo) {
        if (StringUtils.isEmpty((CharSequence)completeTaskVo.getTaskId())) {
            throw new BusinessException("\u8282\u70b9\u4efb\u52a1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)completeTaskVo.getCrmProcessInstanceId())) {
            throw new BusinessException("\u6d41\u7a0b\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (completeTaskVo.getPass() == null) {
            throw new BusinessException("\u8bf7\u660e\u786e\u5f53\u524d\u64cd\u4f5c\u7c7b\u578bpass\u5fc5\u987b\u8f93\u5165");
        }
        log.info("\u5b8c\u6210\u4efb\u52a1\u53c2\u6570\uff1ataskId={} ,params={}", (Object)completeTaskVo);
        if (StringUtils.isEmpty((CharSequence)completeTaskVo.getPositionCode())) {
            completeTaskVo.setPositionCode(UserUtils.getUser().getPoscode());
        }
        if (completeTaskVo.getPass().booleanValue()) {
            this.passBpm(completeTaskVo);
        } else {
            this.rejectBpm(completeTaskVo, "ABORT");
        }
        log.info("\u5b8c\u6210\u4efb\u52a1\uff1a\u4efb\u52a1ID\uff1a" + completeTaskVo.getTaskId());
    }

    @Transactional(rollbackFor={Exception.class})
    public void rejectBpm(CompleteTaskVo completeTaskVo, String approveOpt) {
        String processInstanceId = this.activitiBusinessService.getByProcessInstanceId(completeTaskVo.getCrmProcessInstanceId());
        this.taskService.addComment(completeTaskVo.getTaskId(), processInstanceId, completeTaskVo.getRemarks());
        this.taskService.setOwner(completeTaskVo.getTaskId(), completeTaskVo.getPositionCode());
        HashMap<String, Object> variable = new HashMap<String, Object>();
        this.activityTaskUtil.setbpmOperation(variable, approveOpt);
        this.goProcessTaskNode(completeTaskVo.getTaskId(), "end", variable, processInstanceId);
    }

    public synchronized void goProcessTaskNode(String taskId, String taskDefinitionKey, Map<String, Object> variables, String processInstanceId) {
        Task taskCurrent = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        List taskList = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).taskDefinitionKey(taskCurrent.getTaskDefinitionKey())).list();
        for (Task task : taskList) {
            this.turnTransition(task.getId(), taskDefinitionKey, variables);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void turnTransition(String taskId, String taskDefinitionKey, Map<String, Object> variables) {
        ActivityImpl currActivity = this.findActivitiImpl(taskId, null);
        List<PvmTransition> oriPvmTransitionList = this.activityTaskUtil.clearTransition(currActivity);
        TransitionImpl newTransition = currActivity.createOutgoingTransition();
        ActivityImpl pointActivity = this.findActivitiImpl(taskId, taskDefinitionKey);
        newTransition.setDestination(pointActivity);
        try {
            this.taskService.complete(taskId, variables);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            pointActivity.getIncomingTransitions().remove(newTransition);
            this.activityTaskUtil.restoreTransition(currActivity, oriPvmTransitionList);
        }
    }

    private ActivityImpl findActivitiImpl(String taskId, String activityId) {
        ProcessDefinitionEntity processDefinition = this.activityTaskUtil.findProcessDefinitionEntityByTaskId(taskId);
        if (StringUtils.isEmpty((CharSequence)activityId)) {
            TaskEntity task = (TaskEntity)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            activityId = task.getTaskDefinitionKey();
        }
        if (activityId.toUpperCase().equals("END")) {
            for (ActivityImpl activityImpl : processDefinition.getActivities()) {
                List pvmTransitionList = activityImpl.getOutgoingTransitions();
                if (!pvmTransitionList.isEmpty()) continue;
                return activityImpl;
            }
        }
        ActivityImpl activityImpl = processDefinition.findActivity(activityId);
        return activityImpl;
    }

    @Transactional(rollbackFor={Exception.class})
    public void passBpm(CompleteTaskVo completeTaskVo) {
        if (StringUtils.isEmpty((CharSequence)completeTaskVo.getRemarks())) {
            completeTaskVo.setRemarks("\u901a\u8fc7");
        }
        String processInstanceId = this.activitiBusinessService.getByProcessInstanceId(completeTaskVo.getCrmProcessInstanceId());
        Map variables = completeTaskVo.getVariables();
        variables = variables == null ? new HashMap() : variables;
        this.activityTaskUtil.setbpmOperation(variables, "PASS");
        this.taskService.setVariablesLocal(completeTaskVo.getTaskId(), variables);
        this.taskService.addComment(completeTaskVo.getTaskId(), processInstanceId, completeTaskVo.getRemarks());
        this.taskService.setOwner(completeTaskVo.getTaskId(), completeTaskVo.getPositionCode());
        this.taskService.complete(completeTaskVo.getTaskId(), variables);
    }

    @Override
    public ProcessSummaryRspVO getProcessSummary(String crmProcessInstanceId) {
        ProcessSummaryRspVO processSummaryRspVO = new ProcessSummaryRspVO();
        ActivitiBusinessEntity activitiBusinessEntity = (ActivitiBusinessEntity)this.activitiBusinessMapper.selectOne((Wrapper)Wrappers.lambdaQuery(ActivitiBusinessEntity.class).eq(ActivitiBusinessEntity::getCrmProcessInstanceId, (Object)crmProcessInstanceId));
        if (Objects.isNull(activitiBusinessEntity)) {
            log.error("\u6d41\u7a0b\u5b9e\u4f8b\u6570\u636e\u4e22\u5931,crmProcessInstanceId={}", (Object)crmProcessInstanceId);
            return processSummaryRspVO;
        }
        processSummaryRspVO.setTitle(activitiBusinessEntity.getProcessTitle());
        processSummaryRspVO.setProcessKey(activitiBusinessEntity.getProcessKey());
        processSummaryRspVO.setProcessNo(activitiBusinessEntity.getCrmProcessInstanceId());
        processSummaryRspVO.setRemarks(activitiBusinessEntity.getRemarks());
        processSummaryRspVO.setApplierName(activitiBusinessEntity.getCommitName());
        processSummaryRspVO.setCreateTime(activitiBusinessEntity.getCreateDateAll());
        processSummaryRspVO.setApplierPositionName(activitiBusinessEntity.getCommitPosName());
        List<TaActFileRespVo> files = this.helper.findActFileByProcessInstanceId(activitiBusinessEntity.getProcessInstanceId());
        processSummaryRspVO.setProcessFiles(files);
        List<TaActTargetRespVo> actTargetConfigByProcessKey = this.helper.findActTargetConfigByProcessKey(activitiBusinessEntity.getProcessKey());
        processSummaryRspVO.setTaActTargetRespVos(actTargetConfigByProcessKey);
        if (StringUtils.isNotEmpty((CharSequence)activitiBusinessEntity.getKeyTargetListJson())) {
            try {
                List objects1 = JSONArray.parseArray((String)activitiBusinessEntity.getKeyTargetListJson(), Object.class);
                processSummaryRspVO.setKeyTargetList(objects1);
            }
            catch (Exception e) {
                log.error("{}", (Throwable)e);
                log.error("\u6d41\u7a0b\u5b9e\u4f8b,crmProcessInstanceId=" + crmProcessInstanceId + ",\u5173\u952e\u6307\u6807\u6570\u636e\u5f02\u5e38,\u65e0\u6cd5\u8f6c\u6362\u4e3a\u6570\u7ec4");
            }
        }
        return processSummaryRspVO;
    }

    @Override
    public List<OptLogsRspVO> getOptLogs(OptRecordReqVO reqVO) {
        if (StringUtils.isEmpty((CharSequence)reqVO.getProcessNo()) && StringUtils.isEmpty((CharSequence)reqVO.getProcessInstanceId())) {
            throw new BusinessException("\u67e5\u8be2\u6d41\u7a0b\u65e5\u5fd7\u65f6,\u6d41\u7a0b\u7f16\u7801[processNo]\u548c\u6d41\u7a0b\u5b9e\u4f8bid[processInstanceId]\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        ArrayList respVos = Lists.newArrayList();
        ActivitiBusinessEntity activitiBusinessEntity = (ActivitiBusinessEntity)this.activitiBusinessMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ActivitiBusinessEntity.class).eq(StringUtils.isNotEmpty((CharSequence)reqVO.getProcessNo()), ActivitiBusinessEntity::getCrmProcessInstanceId, (Object)reqVO.getProcessNo())).eq(StringUtils.isNotEmpty((CharSequence)reqVO.getProcessInstanceId()), ActivitiBusinessEntity::getProcessInstanceId, (Object)reqVO.getProcessInstanceId()));
        List logEntities = this.logMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ActivitiBpmlogEntity.class).eq(StringUtils.isNotEmpty((CharSequence)reqVO.getProcessInstanceId()), ActivitiBpmlogEntity::getProcessInstanceId, (Object)reqVO.getProcessInstanceId())).eq(StringUtils.isNotEmpty((CharSequence)reqVO.getProcessNo()), ActivitiBpmlogEntity::getCrmProcessInstanceId, (Object)reqVO.getProcessNo())).orderByDesc(CrmBaseEntity::getCreateDateAll));
        List taskList = ((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(activitiBusinessEntity.getProcessInstanceId())).orderByTaskCreateTime()).desc()).list();
        if (CollectionUtils.isNotEmpty((Collection)taskList)) {
            OptLogsRspVO optLogsRspVO = new OptLogsRspVO();
            List collect = taskList.stream().map(o -> {
                OptRecordRspVO rspVO = new OptRecordRspVO();
                rspVO.setProcessName(activitiBusinessEntity.getProcessName());
                rspVO.setCreateTime(o.getCreateTime());
                rspVO.setTaskDefKey(o.getTaskDefinitionKey());
                rspVO.setTaskName(o.getName());
                rspVO.setTaskId(o.getId());
                rspVO.setProcessVersionKey(o.getProcessDefinitionId());
                rspVO.setProcessKey(activitiBusinessEntity.getProcessKey());
                rspVO.setProcessName(activitiBusinessEntity.getProcessName());
                rspVO.setContent("\u5f53\u524d\u5f85\u529e\u8282\u70b9");
                rspVO.setTitle(activitiBusinessEntity.getProcessTitle());
                rspVO.setApplierName(activitiBusinessEntity.getCommitName());
                rspVO.setFormNo(activitiBusinessEntity.getBusinessId());
                rspVO.setId(o.getId());
                rspVO.setOperation("BTN_999");
                rspVO.setOperationStr("\u5f85\u5904\u7406");
                return rspVO;
            }).collect(Collectors.toList());
            String date = DateUtil.formatDate((Date)new Date(), (String)"yyyy-MM-dd");
            optLogsRspVO.setLogDate(date);
            optLogsRspVO.setOptRecordRspVOList(collect);
            respVos.add(optLogsRspVO);
        }
        List<TaActFileRespVo> actFileRespVos = this.helper.findActFileByProcessInstanceId(activitiBusinessEntity.getProcessInstanceId());
        Map<String, List<TaActFileRespVo>> fileMap = actFileRespVos.stream().filter(o -> Objects.equals(2, o.getFileType())).collect(Collectors.groupingBy(TaActFileRespVo::getNodeId));
        Map<String, List<ActivitiBpmlogEntity>> map = logEntities.stream().collect(Collectors.groupingBy(CrmBaseEntity::getCreateDate));
        if (MapUtils.isNotEmpty(map)) {
            map.forEach((key, value) -> {
                OptLogsRspVO optLogsRspVO = new OptLogsRspVO();
                optLogsRspVO.setLogDate(key);
                List recordRspVOS = value.stream().map(r -> {
                    OptRecordRspVO rspVO = new OptRecordRspVO();
                    rspVO.setProcessName(activitiBusinessEntity.getProcessName());
                    rspVO.setCreateTime(DateUtil.str2Date((String)r.getCreateDateAll(), (SimpleDateFormat)DateUtil.datetimeFormat));
                    rspVO.setProcessKey(activitiBusinessEntity.getProcessKey());
                    rspVO.setProcessName(activitiBusinessEntity.getProcessName());
                    rspVO.setTaskName(r.getNodeName());
                    rspVO.setContent(r.getRemarks());
                    rspVO.setTitle(activitiBusinessEntity.getProcessTitle());
                    rspVO.setApplierName(activitiBusinessEntity.getCommitName());
                    rspVO.setFormNo(activitiBusinessEntity.getBusinessId());
                    rspVO.setOperation(r.getOperateType());
                    rspVO.setOperationStr(ActivitiOperateTypeEnum.getStatusNameByCode((String)r.getOperateType()));
                    if (MapUtils.isNotEmpty((Map)fileMap)) {
                        List taActFileRespVos = (List)fileMap.get(r.getNodeId());
                        rspVO.setFileList(taActFileRespVos);
                    }
                    return rspVO;
                }).collect(Collectors.toList());
                optLogsRspVO.setOptRecordRspVOList(recordRspVOS);
                respVos.add(optLogsRspVO);
            });
        }
        return respVos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void recallTasks(String crmProcessInstanceId) {
        UserRedis userRedis = UserUtils.getUser();
        log.info("\u64a4\u56de\u6d41\u7a0b\uff1a" + crmProcessInstanceId);
        String processInstanceId = this.activitiBusinessService.getByProcessInstanceId(crmProcessInstanceId);
        ProcessInstance processInstance = this.activityTaskUtil.getProcessInstance(processInstanceId, null);
        if (processInstance == null) {
            throw new BusinessException("\u5f53\u524d\u6d41\u7a0b\u5df2\u7ecf\u7ed3\u675f[" + crmProcessInstanceId + "]");
        }
        this.taskService.addComment(null, processInstanceId, "\u6d41\u7a0b\u64a4\u56de[" + userRedis.getRealname() + "(" + userRedis.getPoscode() + ")]");
        List executionList = this.runtimeService.createExecutionQuery().processInstanceId(processInstanceId).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)executionList)) {
            for (Execution execution : executionList) {
                this.runtimeService.setVariable(execution.getId(), "approveOpt", (Object)"RECOVER");
            }
        }
        this.runtimeService.deleteProcessInstance(processInstanceId, "RECOVER");
    }
}

