/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.activiti.controller;

import com.biz.crm.activiti.service.BizRuntimeService;
import com.biz.crm.activiti.service.ITaNodeConfigService;
import com.biz.crm.activiti.service.ITaTaskCommunicateService;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.bpmlog.service.ActivitiBpmlogService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.activiti.IndicatorStr;
import com.biz.crm.nebular.activiti.act.req.ConfirmCommunicateReqVO;
import com.biz.crm.nebular.activiti.act.req.TaActDelegateReqVo;
import com.biz.crm.nebular.activiti.act.req.TaskCommunicateReqVO;
import com.biz.crm.nebular.activiti.design.resp.OptBtnVO;
import com.biz.crm.nebular.activiti.start.req.OptRecordReqVO;
import com.biz.crm.nebular.activiti.start.req.ProcessInfoReqVO;
import com.biz.crm.nebular.activiti.task.resp.OptLogsRspVO;
import com.biz.crm.nebular.activiti.task.resp.ProcessSummaryRspVO;
import com.biz.crm.nebular.activiti.vo.ActivitiBusinessVo;
import com.biz.crm.nebular.activiti.vo.BpmQueryVo;
import com.biz.crm.nebular.activiti.vo.CompleteTaskVo;
import com.biz.crm.nebular.activiti.vo.CurrentTaskVo;
import com.biz.crm.nebular.activiti.vo.ProcessCirculateReqVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Api(value="\u6d41\u7a0b\u4e1a\u52a1\u5904\u7406", tags={"\u6d41\u7a0b\u4e1a\u52a1\u5904\u7406"})
@RestController
@RequestMapping(value={"/runtimeController"})
public class RuntimeController {
    private static final Logger log = LoggerFactory.getLogger(RuntimeController.class);
    @Autowired
    private BizRuntimeService bizRuntimeService;
    @Autowired
    private ActivitiBpmlogService bpmlogService;
    @Autowired
    private ITaNodeConfigService nodeConfigService;
    @Autowired
    private ITaTaskCommunicateService communicateService;

    @CrmLog
    @ApiOperation(value="\u53d1\u8d77\u6d41\u7a0b")
    @PostMapping(value={"startProcess"})
    public Result<String> startProcess(@RequestBody ActivitiBusinessVo activitiBusinessVo) {
        String menuCode;
        Result result = new Result();
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null && StringUtils.isNotEmpty((String)(menuCode = requestAttributes.getRequest().getHeader(IndicatorStr.MENU_CODE.getCode())))) {
            activitiBusinessVo.setMenuCode(menuCode);
        }
        if (StringUtils.isEmpty((String)activitiBusinessVo.getPositionCode())) {
            UserRedis userRedis = UserUtils.getUser();
            activitiBusinessVo.setPositionCode(userRedis.getPoscode());
        }
        if (StringUtils.isEmpty((String)activitiBusinessVo.getBusinessId())) {
            result.error500("\u4e1a\u52a1\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\u3010businessId\u3011");
            return result;
        }
        String processInstId = this.bizRuntimeService.startProcess(activitiBusinessVo);
        result.setResult((Object)processInstId);
        return result;
    }

    @ApiOperation(value="\u67e5\u8be2\u5f85\u529e\u4efb\u52a1", notes="\u67e5\u8be2\u5f85\u529e\u4efb\u52a1")
    @PostMapping(value={"listByPositionCode"})
    public Result<PageResult<CurrentTaskVo>> listByPositionCode(@RequestBody BpmQueryVo bpmQueryVo) {
        return Result.ok(this.bizRuntimeService.listByPositionCode(bpmQueryVo));
    }

    @ApiOperation(value="\u6211\u63d0\u4ea4\u7684\u6d41\u7a0b(\u67e5\u8be2\u5df2\u53d1)")
    @PostMapping(value={"listMyBpm"})
    public Result<PageResult<CurrentTaskVo>> listMyBpm(@RequestBody BpmQueryVo bpmQueryVo) {
        return Result.ok(this.bizRuntimeService.listMyBpm(bpmQueryVo));
    }

    @ApiOperation(value="\u6211\u88ab\u9a73\u56de\u7684\u6d41\u7a0b")
    @PostMapping(value={"listMyRejectBpm"})
    public Result<PageResult<CurrentTaskVo>> listMyRejectBpm(@RequestBody BpmQueryVo bpmQueryVo) {
        return Result.ok(this.bizRuntimeService.listMyRejectBpm(bpmQueryVo));
    }

    @ApiOperation(value="\u5ba1\u6279\u901a\u8fc7/\u9a73\u56de\u53d1\u8d77\u4eba")
    @PostMapping(value={"completeTasks"})
    @CrmLog
    public Result completeTasks(@RequestBody CompleteTaskVo completeTaskVo) {
        this.bizRuntimeService.completeTasks(completeTaskVo);
        return Result.ok();
    }

    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u6458\u8981\u4fe1\u606f(\u4f20\u5165\u6d41\u7a0b\u5b9e\u4f8bid)")
    @GetMapping(value={"/getProcessSummary"})
    @CrmLog
    public Result<ProcessSummaryRspVO> getProcessSummary(@RequestParam(value="crmProcessInstanceId") String crmProcessInstanceId) {
        AssertUtils.isNotEmpty((String)crmProcessInstanceId, (String)"\u6d41\u7a0b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        return Result.ok((Object)this.bizRuntimeService.getProcessSummary(crmProcessInstanceId));
    }

    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u65e5\u5fd7(\u53ef\u63a5\u6536\u53c2\u65701.\u6d41\u7a0b\u5b9e\u4f8bid--processInstanceId,2.\u6d41\u7a0b\u7f16\u53f7processNo,\u4e1a\u52a1\u8868\u5355\u4e3b\u952e:formNo)")
    @PostMapping(value={"/getOptLogs"})
    @CrmLog
    public Result<List<OptLogsRspVO>> getOptLogs(@RequestBody OptRecordReqVO optRecordReqVO) {
        List<OptLogsRspVO> list = this.bpmlogService.getOptLogs(optRecordReqVO);
        return Result.ok(list);
    }

    @ApiOperation(value="\u64a4\u56de/\u5173\u95ed/\u6d41\u7a0b\u8ffd\u56de")
    @GetMapping(value={"recallTasks"})
    @CrmLog
    public Result recallTasks(@RequestParam(value="crmProcessInstanceId") String crmProcessInstanceId) {
        this.bizRuntimeService.recallTasks(crmProcessInstanceId);
        return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @ApiOperation(value="\u4f20\u9605")
    @PostMapping(value={"circulate"})
    @CrmLog
    public Result circulate(@RequestBody ProcessCirculateReqVo reqVo) {
        this.bizRuntimeService.circulate(reqVo);
        return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @ApiOperation(value="\u6284\u9001\u5df2\u9605\u64cd\u4f5c\u63a5\u53e3")
    @GetMapping(value={"updateCopyTaskStatus"})
    @CrmLog
    public Result updateCopyTaskStatus(@RequestParam(value="id") String id) {
        this.bizRuntimeService.updateCopyTaskStatus(id);
        return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u5bf9\u5e94\u7684\u6309\u94ae\u6743\u9650\u6570\u636e(\u4f20\u5165\u6d41\u7a0b\u5b9e\u4f8bid)")
    @PostMapping(value={"/getButtons"})
    @CrmLog
    public Result<List<OptBtnVO>> getButtonsByCrmProcessInstanceId(@RequestBody ProcessInfoReqVO reqVo) {
        return Result.ok(this.nodeConfigService.getButtonsByCrmProcessInstanceId(reqVo));
    }

    @ApiOperation(value="\u53d1\u8d77\u6c9f\u901a")
    @PostMapping(value={"/communicateTo"})
    @CrmLog
    public Result communicateTo(@RequestBody TaskCommunicateReqVO taskCommunicateReqVO) {
        this.communicateService.communicateTo(taskCommunicateReqVO);
        return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @ApiOperation(value="\u786e\u8ba4\u6c9f\u901a")
    @PostMapping(value={"/confirmCommunicate"})
    @CrmLog
    public Result confirmCommunicate(@RequestBody ConfirmCommunicateReqVO confirmCommunicateReqVO) {
        this.communicateService.confirmCommunicate(confirmCommunicateReqVO);
        return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @ApiOperation(value="\u59d4\u6d3e/\u8f6c\u529e")
    @PostMapping(value={"/delegate"})
    @CrmLog
    public Result delegate(@RequestBody TaActDelegateReqVo taActDelegateReqVo) {
        this.bizRuntimeService.delegateProcess(taActDelegateReqVo);
        return Result.ok((String)"\u59d4\u6d3e\u6210\u529f");
    }
}

