/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.activiti.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.FormService;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricActivityInstanceQuery;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.TransitionImpl;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang3.StringUtils;

public class ProcessUtilService {
    private static ProcessEngine processEngine = ProcessEngines.getDefaultProcessEngine();
    private static RepositoryService repositoryService = processEngine.getRepositoryService();
    private static RuntimeService runtimeService = processEngine.getRuntimeService();
    private static TaskService taskService = processEngine.getTaskService();
    private static FormService formService = processEngine.getFormService();
    private static HistoryService historyService = processEngine.getHistoryService();

    public static void backProcess(String taskId, String activityId, Map<String, Object> variables) throws Exception {
        if (StringUtils.isEmpty((CharSequence)activityId)) {
            throw new Exception("\u9a73\u56de\u76ee\u6807\u8282\u70b9ID\u4e3a\u7a7a\uff01");
        }
        List<Task> taskList = ProcessUtilService.findTaskListByKey(ProcessUtilService.findProcessInstanceByTaskId(taskId).getId(), ProcessUtilService.findTaskById(taskId).getTaskDefinitionKey());
        for (Task task : taskList) {
            ProcessUtilService.commitProcess(task.getId(), variables, activityId);
        }
    }

    public static void callBackProcess(String taskId, String activityId) throws Exception {
        if (StringUtils.isEmpty((CharSequence)activityId)) {
            throw new Exception("\u76ee\u6807\u8282\u70b9ID\u4e3a\u7a7a\uff01");
        }
        List<Task> taskList = ProcessUtilService.findTaskListByKey(ProcessUtilService.findProcessInstanceByTaskId(taskId).getId(), ProcessUtilService.findTaskById(taskId).getTaskDefinitionKey());
        for (Task task : taskList) {
            ProcessUtilService.commitProcess(task.getId(), null, activityId);
        }
    }

    private static List<PvmTransition> clearTransition(ActivityImpl activityImpl) {
        ArrayList<PvmTransition> oriPvmTransitionList = new ArrayList<PvmTransition>();
        List pvmTransitionList = activityImpl.getOutgoingTransitions();
        for (PvmTransition pvmTransition : pvmTransitionList) {
            oriPvmTransitionList.add(pvmTransition);
        }
        pvmTransitionList.clear();
        return oriPvmTransitionList;
    }

    private static void commitProcess(String taskId, Map<String, Object> variables, String activityId) throws Exception {
        if (variables == null) {
            variables = new HashMap<String, Object>();
        }
        if (StringUtils.isEmpty((CharSequence)activityId)) {
            taskService.complete(taskId, variables);
        } else {
            ProcessUtilService.turnTransition(taskId, activityId, variables);
        }
    }

    public static void endProcess(String taskId) throws Exception {
        ActivityImpl endActivity = ProcessUtilService.findActivitiImpl(taskId, "end");
        ProcessUtilService.commitProcess(taskId, null, endActivity.getId());
    }

    private static ActivityImpl filterNewestActivity(ProcessInstance processInstance, List<ActivityImpl> tempList) {
        while (tempList.size() > 0) {
            ActivityImpl activity_1 = tempList.get(0);
            HistoricActivityInstance activityInstance_1 = ProcessUtilService.findHistoricUserTask(processInstance, activity_1.getId());
            if (activityInstance_1 == null) {
                tempList.remove(activity_1);
                continue;
            }
            if (tempList.size() <= 1) break;
            ActivityImpl activity_2 = tempList.get(1);
            HistoricActivityInstance activityInstance_2 = ProcessUtilService.findHistoricUserTask(processInstance, activity_2.getId());
            if (activityInstance_2 == null) {
                tempList.remove(activity_2);
                continue;
            }
            if (activityInstance_1.getEndTime().before(activityInstance_2.getEndTime())) {
                tempList.remove(activity_1);
                continue;
            }
            tempList.remove(activity_2);
        }
        if (tempList.size() > 0) {
            return tempList.get(0);
        }
        return null;
    }

    private static ActivityImpl findActivitiImpl(String taskId, String activityId) throws Exception {
        ProcessDefinitionEntity processDefinition = ProcessUtilService.findProcessDefinitionEntityByTaskId(taskId);
        if (StringUtils.isEmpty((CharSequence)activityId)) {
            activityId = ProcessUtilService.findTaskById(taskId).getTaskDefinitionKey();
        }
        if (activityId.toUpperCase().equals("END")) {
            for (ActivityImpl activityImpl : processDefinition.getActivities()) {
                List pvmTransitionList = activityImpl.getOutgoingTransitions();
                if (!pvmTransitionList.isEmpty()) continue;
                return activityImpl;
            }
        }
        ActivityImpl activityImpl = processDefinition.findActivity(activityId);
        return activityImpl;
    }

    public static List<ActivityImpl> findBackAvtivity(String taskId) throws Exception {
        List<ActivityImpl> rtnList = ProcessUtilService.iteratorBackActivity(taskId, ProcessUtilService.findActivitiImpl(taskId, null), new ArrayList<ActivityImpl>(), new ArrayList<ActivityImpl>());
        return ProcessUtilService.reverList(rtnList);
    }

    private static HistoricActivityInstance findHistoricUserTask(ProcessInstance processInstance, String activityId) {
        HistoricActivityInstance rtnVal = null;
        List historicActivityInstances = ((HistoricActivityInstanceQuery)historyService.createHistoricActivityInstanceQuery().activityType("userTask").processInstanceId(processInstance.getId()).activityId(activityId).finished().orderByHistoricActivityInstanceEndTime().desc()).list();
        if (historicActivityInstances.size() > 0) {
            rtnVal = (HistoricActivityInstance)historicActivityInstances.get(0);
        }
        return rtnVal;
    }

    private static String findParallelGatewayId(ActivityImpl activityImpl) {
        List incomingTransitions = activityImpl.getOutgoingTransitions();
        for (PvmTransition pvmTransition : incomingTransitions) {
            String gatewayId;
            String gatewayType;
            TransitionImpl transitionImpl = (TransitionImpl)pvmTransition;
            activityImpl = transitionImpl.getDestination();
            String type = (String)activityImpl.getProperty("type");
            if (!"parallelGateway".equals(type) || !"END".equals((gatewayType = (gatewayId = activityImpl.getId()).substring(gatewayId.lastIndexOf("_") + 1)).toUpperCase())) continue;
            return gatewayId.substring(0, gatewayId.lastIndexOf("_")) + "_start";
        }
        return null;
    }

    public static ProcessDefinitionEntity findProcessDefinitionEntityByTaskId(String taskId) throws Exception {
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)repositoryService).getDeployedProcessDefinition(ProcessUtilService.findTaskById(taskId).getProcessDefinitionId());
        if (processDefinition == null) {
            throw new Exception("\u6d41\u7a0b\u5b9a\u4e49\u672a\u627e\u5230!");
        }
        return processDefinition;
    }

    public static ProcessInstance findProcessInstanceByTaskId(String taskId) throws Exception {
        ProcessInstance processInstance = (ProcessInstance)runtimeService.createProcessInstanceQuery().processInstanceId(ProcessUtilService.findTaskById(taskId).getProcessInstanceId()).singleResult();
        if (processInstance == null) {
            throw new Exception("\u6d41\u7a0b\u5b9e\u4f8b\u672a\u627e\u5230!");
        }
        return processInstance;
    }

    private static TaskEntity findTaskById(String taskId) throws Exception {
        TaskEntity task = (TaskEntity)((TaskQuery)taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            throw new Exception("\u4efb\u52a1\u5b9e\u4f8b\u672a\u627e\u5230!");
        }
        return task;
    }

    private static List<Task> findTaskListByKey(String processInstanceId, String key) {
        return ((TaskQuery)((TaskQuery)taskService.createTaskQuery().processInstanceId(processInstanceId)).taskDefinitionKey(key)).list();
    }

    private static List<ActivityImpl> iteratorBackActivity(String taskId, ActivityImpl currActivity, List<ActivityImpl> rtnList, List<ActivityImpl> tempList) throws Exception {
        ProcessInstance processInstance = ProcessUtilService.findProcessInstanceByTaskId(taskId);
        List incomingTransitions = currActivity.getIncomingTransitions();
        ArrayList<ActivityImpl> exclusiveGateways = new ArrayList<ActivityImpl>();
        ArrayList<ActivityImpl> parallelGateways = new ArrayList<ActivityImpl>();
        for (PvmTransition pvmTransition : incomingTransitions) {
            TransitionImpl transitionImpl = (TransitionImpl)pvmTransition;
            ActivityImpl activityImpl = transitionImpl.getSource();
            String type = (String)activityImpl.getProperty("type");
            if ("parallelGateway".equals(type)) {
                String gatewayId = activityImpl.getId();
                String gatewayType = gatewayId.substring(gatewayId.lastIndexOf("_") + 1);
                if ("START".equals(gatewayType.toUpperCase())) {
                    return rtnList;
                }
                parallelGateways.add(activityImpl);
                continue;
            }
            if ("startEvent".equals(type)) {
                return rtnList;
            }
            if ("userTask".equals(type)) {
                tempList.add(activityImpl);
                continue;
            }
            if (!"exclusiveGateway".equals(type)) continue;
            currActivity = transitionImpl.getSource();
            exclusiveGateways.add(currActivity);
        }
        for (ActivityImpl activityImpl : exclusiveGateways) {
            ProcessUtilService.iteratorBackActivity(taskId, activityImpl, rtnList, tempList);
        }
        for (ActivityImpl activityImpl : parallelGateways) {
            ProcessUtilService.iteratorBackActivity(taskId, activityImpl, rtnList, tempList);
        }
        currActivity = ProcessUtilService.filterNewestActivity(processInstance, tempList);
        if (currActivity != null) {
            String id = ProcessUtilService.findParallelGatewayId(currActivity);
            if (StringUtils.isEmpty((CharSequence)id)) {
                rtnList.add(currActivity);
            } else {
                currActivity = ProcessUtilService.findActivitiImpl(taskId, id);
            }
            tempList.clear();
            ProcessUtilService.iteratorBackActivity(taskId, currActivity, rtnList, tempList);
        }
        return rtnList;
    }

    private static void restoreTransition(ActivityImpl activityImpl, List<PvmTransition> oriPvmTransitionList) {
        List pvmTransitionList = activityImpl.getOutgoingTransitions();
        pvmTransitionList.clear();
        for (PvmTransition pvmTransition : oriPvmTransitionList) {
            pvmTransitionList.add(pvmTransition);
        }
    }

    private static List<ActivityImpl> reverList(List<ActivityImpl> list) {
        ArrayList<ActivityImpl> rtnList = new ArrayList<ActivityImpl>();
        for (int i = list.size(); i > 0; --i) {
            if (rtnList.contains(list.get(i - 1))) continue;
            rtnList.add(list.get(i - 1));
        }
        return rtnList;
    }

    public static void transferAssignee(String taskId, String userCode) {
        taskService.setAssignee(taskId, userCode);
    }

    private static void turnTransition(String taskId, String activityId, Map<String, Object> variables) throws Exception {
        ActivityImpl currActivity = ProcessUtilService.findActivitiImpl(taskId, null);
        List<PvmTransition> oriPvmTransitionList = ProcessUtilService.clearTransition(currActivity);
        TransitionImpl newTransition = currActivity.createOutgoingTransition();
        ActivityImpl pointActivity = ProcessUtilService.findActivitiImpl(taskId, activityId);
        newTransition.setDestination(pointActivity);
        taskService.complete(taskId, variables);
        pointActivity.getIncomingTransitions().remove(newTransition);
        ProcessUtilService.restoreTransition(currActivity, oriPvmTransitionList);
    }

    public static FormService getFormService() {
        return formService;
    }

    public static HistoryService getHistoryService() {
        return historyService;
    }

    public static ProcessEngine getProcessEngine() {
        return processEngine;
    }

    public static RepositoryService getRepositoryService() {
        return repositoryService;
    }

    public static RuntimeService getRuntimeService() {
        return runtimeService;
    }

    public static TaskService getTaskService() {
        return taskService;
    }
}

