/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.activiti.service.impl;

import com.biz.crm.activiti.service.ReceiveMdmService;
import com.biz.crm.activiti.user.GroupActivitiVo;
import com.biz.crm.activiti.user.MembershipActivitiVo;
import com.biz.crm.activiti.user.UserActivitiVo;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.identity.Group;
import org.activiti.engine.identity.User;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ReceiveMdmServiceImpl
implements ReceiveMdmService {
    @Override
    public void saveUser(UserActivitiVo userActivitiVo) {
        ProcessEngine engine = ProcessEngines.getDefaultProcessEngine();
        IdentityService identityService = engine.getIdentityService();
        if (StringUtils.isBlank((CharSequence)userActivitiVo.getPosCode())) {
            return;
        }
        User user = (User)identityService.createUserQuery().userId(userActivitiVo.getPosCode()).singleResult();
        if (user != null) {
            user.setFirstName(userActivitiVo.getPosName());
            identityService.saveUser(user);
        } else {
            user = identityService.newUser(userActivitiVo.getPosCode());
            user.setFirstName(userActivitiVo.getPosName());
            identityService.saveUser(user);
        }
    }

    @Override
    public void saveGroup(GroupActivitiVo groupActivitiVo) {
        ProcessEngine engine = ProcessEngines.getDefaultProcessEngine();
        IdentityService identityService = engine.getIdentityService();
        if (StringUtils.isBlank((CharSequence)groupActivitiVo.getBpmRoleCode())) {
            return;
        }
        Group group = (Group)identityService.createGroupQuery().groupId(groupActivitiVo.getBpmRoleCode()).singleResult();
        if (group != null) {
            group.setName(groupActivitiVo.getBpmRoleName());
            identityService.saveGroup(group);
        } else {
            group = identityService.newGroup(groupActivitiVo.getBpmRoleCode());
            group.setName(groupActivitiVo.getBpmRoleName());
            group.setType(groupActivitiVo.getBpmRoleCode());
            identityService.saveGroup(group);
        }
    }

    @Override
    public void saveMembership(MembershipActivitiVo membershipActivitiVo) {
        ProcessEngine engine = ProcessEngines.getDefaultProcessEngine();
        IdentityService identityService = engine.getIdentityService();
        identityService.deleteMembership(membershipActivitiVo.getPosCode(), membershipActivitiVo.getBpmRoleCode());
        identityService.createMembership(membershipActivitiVo.getPosCode(), membershipActivitiVo.getBpmRoleCode());
    }
}

