/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.activiti.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.activiti.entity.ActReModelEntity;
import com.biz.crm.activiti.entity.TaActTargetEntity;
import com.biz.crm.activiti.entity.TaNodeConfigEntity;
import com.biz.crm.activiti.entity.TaProcessBizRelationEntity;
import com.biz.crm.activiti.mapper.ActReModelMapper;
import com.biz.crm.activiti.mapper.TaActTargetMapper;
import com.biz.crm.activiti.mapper.TaNodeConfigMapper;
import com.biz.crm.activiti.mapper.TaProcessBizRelationMapper;
import com.biz.crm.activiti.service.ITaNodeConfigService;
import com.biz.crm.activiti.service.OperateActivitiService;
import com.biz.crm.activiti.service.impl.ActivitiBusinessHelper;
import com.biz.crm.activiti.util.XmlActivitiUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.activiti.Indicator;
import com.biz.crm.nebular.activiti.vo.ActGeByteArrayVo;
import com.biz.crm.nebular.activiti.vo.ActReModel;
import com.biz.crm.nebular.activiti.vo.ListByKeyVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.PageUtil;
import com.biz.crm.vo.ReProcdef;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.editor.language.json.converter.BpmnJsonConverter;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.Model;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.repository.ProcessDefinitionQuery;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OperateActivitiServiceImpl
implements OperateActivitiService {
    private static final Logger log = LoggerFactory.getLogger(OperateActivitiServiceImpl.class);
    @Resource
    private ActReModelMapper actReModelMapper;
    @Autowired
    private RepositoryService repositoryService;
    @Resource
    private TaProcessBizRelationMapper relationMapper;
    @Resource
    private TaActTargetMapper targetMapper;
    @Autowired
    private ITaNodeConfigService nodeConfigService;
    @Resource
    private TaNodeConfigMapper nodeConfigMapper;
    @Autowired
    private ActivitiBusinessHelper helper;

    @Override
    public PageResult<ActReModel> list(ActReModel actReModel) {
        Page page = PageUtil.buildPage((Integer)actReModel.getPageNum(), (Integer)actReModel.getPageSize());
        List<ActReModel> list = this.actReModelMapper.listPage(page, actReModel);
        list.forEach(o -> o.setProcessStatusName(Indicator.getProcessStatusNameByCode((Integer)o.getProcessStatus())));
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deployment(String id) {
        Model modelData = this.repositoryService.getModel(id);
        byte[] bytes = this.repositoryService.getModelEditorSource(modelData.getId());
        ProcessDefinition oldProcessDefinition = null;
        if (StringUtils.isNotEmpty((CharSequence)modelData.getDeploymentId())) {
            List list = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().deploymentId(modelData.getDeploymentId()).orderByProcessDefinitionVersion().desc()).list();
            oldProcessDefinition = (ProcessDefinition)list.get(0);
        }
        AssertUtils.isNotNull((Object)bytes, (String)"\u6a21\u578b\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u5148\u8bbe\u8ba1\u6d41\u7a0b\u5e76\u6210\u529f\u4fdd\u5b58\uff0c\u518d\u8fdb\u884c\u53d1\u5e03\u3002");
        JsonNode modelNode = null;
        try {
            modelNode = new ObjectMapper().readTree(bytes);
        }
        catch (IOException e) {
            log.error("{}", (Throwable)e);
            throw new BusinessException("\u6d41\u7a0b\u6570\u636e\u89e3\u6790\u5931\u8d25");
        }
        BpmnModel model = new BpmnJsonConverter().convertToBpmnModel(modelNode);
        AssertUtils.isNotNull((Object)model.getProcesses(), (String)"\u6570\u636e\u6a21\u578b\u4e0d\u7b26\u8981\u6c42\uff0c\u8bf7\u81f3\u5c11\u8bbe\u8ba1\u4e00\u6761\u4e3b\u7ebf\u6d41\u7a0b\u3002");
        byte[] bpmBytes = new BpmnXMLConverter().convertToXML(model);
        String processName = modelData.getName() + ".bpmn20.xml";
        Deployment deployment = null;
        try {
            deployment = this.repositoryService.createDeployment().name(modelData.getName()).addString(processName, new String(bpmBytes, "UTF-8")).deploy();
        }
        catch (UnsupportedEncodingException e) {
            log.error("{}", (Throwable)e);
            throw new BusinessException("\u6d41\u7a0b\u90e8\u7f72\u65f6\u6570\u636e\u8f6c\u6362\u5931\u8d25");
        }
        modelData.setDeploymentId(deployment.getId());
        this.repositoryService.saveModel(modelData);
        ActReModelEntity entity = (ActReModelEntity)this.actReModelMapper.selectById((Serializable)((Object)modelData.getId()));
        entity.setProcessStatus(Integer.valueOf(Indicator.PROCESS_STATE_DEPLOY.getCode()));
        this.actReModelMapper.updateById(entity);
        this.deployCreateNodes(bytes, entity, oldProcessDefinition);
    }

    private void deployCreateNodes(byte[] bytes, ActReModelEntity model, ProcessDefinition oldProcessDefinition) {
        ActGeByteArrayVo processXmlByDeploymentId = this.helper.findProcessXmlByDeploymentId(model.getDeploymentId());
        List list = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().deploymentId(model.getDeploymentId()).orderByProcessDefinitionVersion().desc()).list();
        ProcessDefinition processDefinition = (ProcessDefinition)list.get(0);
        ArrayList saveEntities = Lists.newArrayList();
        List<TaNodeConfigEntity> configEntities = null;
        try {
            configEntities = XmlActivitiUtil.getNodes(processXmlByDeploymentId.getProcessXml());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u89e3\u6790xml\u83b7\u53d6task\u5931\u8d25!");
        }
        if (CollectionUtils.isNotEmpty(configEntities)) {
            HashMap map = Maps.newHashMap();
            if (Objects.nonNull(oldProcessDefinition)) {
                List taNodeConfigEntities = this.nodeConfigMapper.selectList((Wrapper)Wrappers.lambdaQuery(TaNodeConfigEntity.class).eq(TaNodeConfigEntity::getProcessVersionKey, (Object)oldProcessDefinition.getId()));
                taNodeConfigEntities.forEach(o -> map.put(o.getProcessNodeCode(), o));
            }
            for (TaNodeConfigEntity configEntity : configEntities) {
                TaNodeConfigEntity taNodeConfigEntity = (TaNodeConfigEntity)map.get(configEntity.getProcessNodeCode());
                if (Objects.nonNull(taNodeConfigEntity)) {
                    taNodeConfigEntity.setProcessVersionKey(processDefinition.getId());
                    taNodeConfigEntity.setProcessNodeName(configEntity.getProcessNodeName());
                    taNodeConfigEntity.setNodeIndex(configEntity.getNodeIndex());
                    this.helper.setPublicParamsNull((CrmBaseEntity)taNodeConfigEntity);
                    saveEntities.add(taNodeConfigEntity);
                } else {
                    configEntity.setProcessVersionKey(processDefinition.getId());
                    saveEntities.add(configEntity);
                }
                taNodeConfigEntity.setProcessNodeId(model.getKey() + ":" + processDefinition.getVersion() + ":" + configEntity.getProcessNodeCode());
            }
            this.nodeConfigService.saveBatch(saveEntities);
        }
    }

    @Override
    public PageResult<ReProcdef> listByKey(ListByKeyVo listByKeyVo) {
        AssertUtils.isNotEmpty((String)listByKeyVo.getKey(), (String)"\u8bf7\u4f20\u5165\u6d41\u7a0b\u5b9a\u4e49key");
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(listByKeyVo.getKey()).listPage(listByKeyVo.getPageSize() * (listByKeyVo.getPageNum() - 1), listByKeyVo.getPageSize().intValue());
        long count = this.repositoryService.createProcessDefinitionQuery().count();
        ArrayList<ReProcdef> list = new ArrayList<ReProcdef>();
        for (ProcessDefinition processDefinition : processDefinitions) {
            ReProcdef reProcdef = new ReProcdef(processDefinition);
            list.add(reProcdef);
        }
        return PageResult.builder().data(list).count(Long.valueOf(count)).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatchModel(List<String> ids) {
        AssertUtils.isNotNull(ids, (String)"\u6d41\u7a0b\u6a21\u578bid\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List modelEntities = this.actReModelMapper.selectList((Wrapper)Wrappers.lambdaQuery(ActReModelEntity.class).in(ActReModelEntity::getId, ids));
        ArrayList existsIds = Lists.newArrayList();
        ArrayList existsKeys = Lists.newArrayList();
        modelEntities.forEach(o -> {
            existsIds.add(o.getId());
            existsKeys.add(o.getKey());
        });
        ids.forEach(o -> this.repositoryService.deleteModel(o));
        if (CollectionUtils.isNotEmpty((Collection)existsKeys)) {
            this.relationMapper.delete((Wrapper)Wrappers.lambdaQuery(TaProcessBizRelationEntity.class).in(TaProcessBizRelationEntity::getProcessKey, (Collection)existsKeys));
            this.targetMapper.delete((Wrapper)Wrappers.lambdaQuery(TaActTargetEntity.class).in(TaActTargetEntity::getProcessKey, (Collection)existsKeys));
        }
    }
}

