/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.activiti.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activiti.entity.TaNodeConfigEntity;
import com.biz.crm.activiti.mapper.ActReModelMapper;
import com.biz.crm.activiti.mapper.TaNodeConfigMapper;
import com.biz.crm.activiti.service.ITaNodeConfigService;
import com.biz.crm.common.PageResult;
import com.biz.crm.listener.mapper.TaListenerProcMapper;
import com.biz.crm.nebular.activiti.design.req.TaNodeConfigReqVo;
import com.biz.crm.nebular.activiti.design.resp.TaNodeConfigRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TaNodeConfigExpandServiceImpl"})
public class TaNodeConfigServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TaNodeConfigMapper, TaNodeConfigEntity>
implements ITaNodeConfigService {
    private static final Logger log = LoggerFactory.getLogger(TaNodeConfigServiceImpl.class);
    @Resource
    private TaNodeConfigMapper taNodeConfigMapper;
    @Resource
    private TaListenerProcMapper taListenerProcMapper;
    @Resource
    private ActReModelMapper modelMapper;

    @Override
    public PageResult<TaNodeConfigRespVo> findList(TaNodeConfigReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<TaNodeConfigRespVo> list = this.taNodeConfigMapper.findList((Page<TaNodeConfigRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public TaNodeConfigRespVo query(String id) {
        TaNodeConfigEntity entity = (TaNodeConfigEntity)this.taNodeConfigMapper.selectById((Serializable)((Object)id));
        if (ObjectUtils.isNotEmpty((Object)entity)) {
            return (TaNodeConfigRespVo)CrmBeanUtil.copy((Object)entity, TaNodeConfigRespVo.class);
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(TaNodeConfigReqVo reqVo) {
        TaNodeConfigEntity entity = (TaNodeConfigEntity)CrmBeanUtil.copy((Object)reqVo, TaNodeConfigEntity.class);
        this.save(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(TaNodeConfigReqVo reqVo) {
        TaNodeConfigEntity entity = (TaNodeConfigEntity)this.getById((Serializable)((Object)reqVo.getId()));
        if (ObjectUtils.isNotEmpty((Object)entity)) {
            this.updateById(CrmBeanUtil.copy((Object)reqVo, TaNodeConfigEntity.class));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        List taNodeConfigEntities = this.taNodeConfigMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)taNodeConfigEntities)) {
            this.taNodeConfigMapper.deleteBatchIds(ids);
        }
        this.updateBatchById(taNodeConfigEntities);
    }

    @Override
    public List<TaNodeConfigEntity> findNodeByProcessVersionKey(String processVersionKey) {
        return this.taNodeConfigMapper.findNodeByProcessVersionKey(processVersionKey);
    }

    @Override
    public PageResult<TaNodeConfigRespVo> queryByProcessKey(TaNodeConfigReqVo taNodeConfigReqVo) {
        if (StringUtils.isNotEmpty((String)taNodeConfigReqVo.getProcessVersionKey())) {
            return this.findList(taNodeConfigReqVo);
        }
        String processVersionKey = this.taNodeConfigMapper.getMaxProcessVersionByKey(taNodeConfigReqVo.getProcessKey());
        if (StringUtils.isEmpty((String)processVersionKey)) {
            return PageResult.builder().data((List)Lists.newArrayList()).count(Long.valueOf(0L)).build();
        }
        taNodeConfigReqVo.setProcessVersionKey(processVersionKey);
        return this.findList(taNodeConfigReqVo);
    }

    @Override
    public TaNodeConfigEntity findNodeByTaskVersionKey(String processVersionKey, String taskDefKey) {
        return this.taNodeConfigMapper.findNodeByTaskVersionKey(processVersionKey, taskDefKey);
    }

    @Override
    public Map<String, TaNodeConfigEntity> configListToMap(List<TaNodeConfigEntity> configList) {
        if (CollectionUtils.isNotEmpty(configList)) {
            HashMap<String, TaNodeConfigEntity> configMap = new HashMap<String, TaNodeConfigEntity>();
            configList.forEach(config -> configMap.put(config.getProcessNodeCode(), (TaNodeConfigEntity)config));
            return configMap;
        }
        return null;
    }

    @Override
    public List<TaNodeConfigRespVo> getAllProcessVersionKey(String processKey) {
        AssertUtils.isNotEmpty((String)processKey, (String)"\u6d41\u7a0bkey[processKey]\u4e0d\u80fd\u4e3a\u7a7a");
        return this.taNodeConfigMapper.getAllProcessVersionByKey(processKey);
    }
}

