/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.activiti.util;

import com.biz.crm.activiti.entity.TaNodeConfigEntity;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class XmlActivitiUtil {
    public static final String ID_DEF_START = "402885605bfb8622015bfb8bb4400000";
    public static final String ID_DEF_END = "402885605bfb8622015bfb8c7aeb0001";
    public static final String ID_DEF_CREATE = "402885605bfb8622015bfb8da5c60002";
    public static final String ID_DEF_COMPLETE = "402885605bfb8622015bfb8fa2c00004";
    public static final String ID_DEF_START_TASK_LISTENER = "86378d438ca2758220a51c29bab68d2d";
    public static final String ID_DEF_END_PROCESS_LISTENER = "f6cdcf77b960f0fc1f18809ab72c0527";
    public static final String CLASS_DEF_START = "com.biz.crm.listener.base.DefaultExeStartListener";
    public static final String CLASS_DEF_END = "com.biz.crm.listener.base.DefaultExeEndListener";
    public static final String CLASS_DEF_CREATE = "com.biz.crm.listener.base.DefaultTaskCreateListener";
    public static final String CLASS_DEF_COMPLETE = "com.biz.crm.listener.base.DefaultTaskCompleteListener";
    public static final String ASSIGNEE_PROP_IS_SEQ = "isSequential";
    public static final String ASSIGNEE_PROP_LOOP = "loopCardinality";
    public static final String ASSIGNEE_PROP_CLC = "collection";
    public static final String ASSIGNEE_PROP_VAR = "elementVariable";
    public static final String ASSIGNEE_PROP_CC = "completionCondition";

    public static Map<String, String> getActNodeUserRoles(String xml) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        SAXReader reader = new SAXReader();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xml.getBytes("UTF-8"));
        Document document = reader.read((InputStream)inputStream);
        Element root = document.getRootElement();
        Element processElement = root.element("process");
        List userTaskElements = processElement.elements("userTask");
        for (Element userTaskElement : userTaskElements) {
            String nodeId = userTaskElement.attributeValue("id");
            String roleAttribute = userTaskElement.attributeValue("candidateGroups");
            String usersAttribute = userTaskElement.attributeValue("candidateUsers");
            String assigneeAttribute = userTaskElement.attributeValue("assignee");
            if (StringUtils.isNotEmpty((CharSequence)roleAttribute)) {
                map.put(nodeId, "R" + roleAttribute);
                continue;
            }
            if (StringUtils.isNotEmpty((CharSequence)usersAttribute)) {
                map.put(nodeId, "O" + usersAttribute);
                continue;
            }
            if (!StringUtils.isNotEmpty((CharSequence)assigneeAttribute)) continue;
            map.put(nodeId, "P" + assigneeAttribute);
        }
        return map;
    }

    public static String addDefListenerXml(String xml) throws Exception {
        SAXReader reader = new SAXReader();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xml.getBytes("UTF-8"));
        Document document = reader.read((InputStream)inputStream);
        Element root = document.getRootElement();
        Element processElement = root.element("process");
        Element extensionElements = processElement.element("extensionElements");
        if (extensionElements == null) {
            Element documentElement = processElement.element("documentation");
            processElement.remove(documentElement);
            Element processNewElement = processElement.createCopy();
            processElement.clearContent();
            processElement.add(documentElement.createCopy());
            Element newExtensionElements = processElement.addElement("extensionElements");
            XmlActivitiUtil.addListenerElement(newExtensionElements, "executionListener", ID_DEF_START, "start", CLASS_DEF_START);
            XmlActivitiUtil.addListenerElement(newExtensionElements, "executionListener", ID_DEF_END, "end", CLASS_DEF_END);
            processNewElement.elements().forEach(element -> processElement.add(element.createCopy()));
        } else {
            List eElements = extensionElements.elements();
            boolean haveStart = false;
            boolean haveEnd = false;
            for (Element eElement : eElements) {
                if (CLASS_DEF_START.equals(eElement.attributeValue("class"))) {
                    haveStart = true;
                    continue;
                }
                if (!CLASS_DEF_END.equals(eElement.attributeValue("class"))) continue;
                haveEnd = true;
            }
            if (!haveStart) {
                XmlActivitiUtil.addListenerElement(extensionElements, "executionListener", ID_DEF_START, "start", CLASS_DEF_START);
            }
            if (!haveEnd) {
                XmlActivitiUtil.addListenerElement(extensionElements, "executionListener", ID_DEF_END, "end", CLASS_DEF_END);
            }
        }
        List userTaskElements = processElement.elements("userTask");
        for (Element userTaskElement : userTaskElements) {
            Element lisElements = userTaskElement.element("extensionElements");
            if (lisElements == null) {
                Element newTaskElements = userTaskElement.addElement("extensionElements");
                XmlActivitiUtil.addListenerElement(newTaskElements, "taskListener", ID_DEF_CREATE, "create", CLASS_DEF_CREATE);
                XmlActivitiUtil.addListenerElement(newTaskElements, "taskListener", ID_DEF_COMPLETE, "complete", CLASS_DEF_COMPLETE);
                continue;
            }
            List eElements = lisElements.elements();
            boolean haveCreate = false;
            boolean haveComplete = false;
            for (Element eElement : eElements) {
                if (CLASS_DEF_CREATE.equals(eElement.attributeValue("class"))) {
                    haveCreate = true;
                    continue;
                }
                if (!CLASS_DEF_COMPLETE.equals(eElement.attributeValue("class"))) continue;
                haveComplete = true;
            }
            if (!haveCreate) {
                XmlActivitiUtil.addListenerElement(lisElements, "taskListener", ID_DEF_CREATE, "create", CLASS_DEF_CREATE);
            }
            if (haveComplete) continue;
            XmlActivitiUtil.addListenerElement(lisElements, "taskListener", ID_DEF_COMPLETE, "complete", CLASS_DEF_COMPLETE);
        }
        return document.asXML();
    }

    private static void addListenerElement(Element element, String type, String id, String event, String clazz) throws Exception {
        Element newElement = element.addElement("activiti:" + type);
        newElement.addAttribute("id", id);
        newElement.addAttribute("event", event);
        newElement.addAttribute("class", clazz);
    }

    public static String addMultiInstanceProperties(String xml, Map<String, Map<String, String>> nodePropertiesMap) throws Exception {
        SAXReader reader = new SAXReader();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xml.getBytes("UTF-8"));
        Document document = reader.read((InputStream)inputStream);
        Element root = document.getRootElement();
        Element processElement = root.element("process");
        List taskList = processElement.elements("userTask");
        if (CollectionUtils.isNotEmpty((Collection)taskList)) {
            for (Element element : taskList) {
                String taskId = element.attributeValue("id");
                if (!nodePropertiesMap.containsKey(taskId)) continue;
                XmlActivitiUtil.setTaskAssignee(nodePropertiesMap, element, taskId);
            }
        }
        return document.asXML();
    }

    private static void setTaskAssignee(Map<String, Map<String, String>> nodePropertiesMap, Element element, String taskId) {
        Map<String, String> taskProperties = nodePropertiesMap.get(taskId);
        if (taskProperties.containsKey(ASSIGNEE_PROP_IS_SEQ)) {
            Element newTaskElement = element.element("multiInstanceLoopCharacteristics");
            if (newTaskElement == null) {
                newTaskElement = element.addElement("multiInstanceLoopCharacteristics");
            }
            newTaskElement.addAttribute(ASSIGNEE_PROP_IS_SEQ, taskProperties.get(ASSIGNEE_PROP_IS_SEQ));
            Element loopElement = newTaskElement.element(ASSIGNEE_PROP_LOOP);
            Element conditionElement = newTaskElement.element(ASSIGNEE_PROP_CC);
            if (taskProperties.containsKey(ASSIGNEE_PROP_LOOP)) {
                if (loopElement == null) {
                    loopElement = newTaskElement.addElement(ASSIGNEE_PROP_LOOP);
                }
                loopElement.setText(taskProperties.get(ASSIGNEE_PROP_LOOP));
            } else if (loopElement != null) {
                newTaskElement.remove(loopElement);
            }
            if (taskProperties.containsKey(ASSIGNEE_PROP_CLC)) {
                newTaskElement.addAttribute(ASSIGNEE_PROP_CLC, taskProperties.get(ASSIGNEE_PROP_CLC));
            } else {
                XmlActivitiUtil.deleteElementAttribute(newTaskElement, ASSIGNEE_PROP_CLC);
            }
            if (taskProperties.containsKey(ASSIGNEE_PROP_VAR)) {
                newTaskElement.addAttribute(ASSIGNEE_PROP_VAR, taskProperties.get(ASSIGNEE_PROP_VAR));
            } else {
                XmlActivitiUtil.deleteElementAttribute(newTaskElement, ASSIGNEE_PROP_VAR);
            }
            if (taskProperties.containsKey(ASSIGNEE_PROP_CC)) {
                String condition = XmlActivitiUtil.convertEl(taskProperties.get(ASSIGNEE_PROP_CC));
                if (conditionElement == null) {
                    conditionElement = newTaskElement.addElement(ASSIGNEE_PROP_CC);
                }
                conditionElement.setText(condition);
            } else if (conditionElement != null) {
                newTaskElement.remove(conditionElement);
            }
        }
    }

    public static String convertEl(String elStr) {
        return elStr.replace("{eq}", "==").replace("{ne}", "!=").replace("{le}", "<=").replace("{ge}", ">=").replace("{lt}", "<").replace("{gt}", ">");
    }

    public static void deleteElementAttribute(Element element, String attr) {
        Attribute attribute = element.attribute(attr);
        if (attribute != null) {
            element.remove(attribute);
        }
    }

    public static List<TaNodeConfigEntity> getNodes(byte[] xmlByte) throws Exception {
        SAXReader reader = new SAXReader();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlByte);
        Document document = reader.read((InputStream)inputStream);
        Element root = document.getRootElement();
        Element processElement = root.element("process");
        List userTaskElements = processElement.elements("userTask");
        if (CollectionUtils.isNotEmpty((Collection)userTaskElements)) {
            ArrayList<TaNodeConfigEntity> nodeConfigs = new ArrayList<TaNodeConfigEntity>();
            for (int i = 0; i < userTaskElements.size(); ++i) {
                Element userTaskElement = (Element)userTaskElements.get(i);
                TaNodeConfigEntity node = new TaNodeConfigEntity();
                node.setProcessNodeCode(userTaskElement.attributeValue("id"));
                node.setProcessNodeName(userTaskElement.attributeValue("name"));
                node.setNodeIndex(Integer.valueOf(i + 1));
                nodeConfigs.add(node);
            }
            return nodeConfigs;
        }
        return null;
    }
}

