/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.activiti.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.activiti.entity.ActivitiBusinessEntity;
import com.biz.crm.activiti.entity.TaActFileEntity;
import com.biz.crm.activiti.entity.TaActTargetEntity;
import com.biz.crm.activiti.entity.TaNodeConfigEntity;
import com.biz.crm.activiti.entity.TaTaskCommunicateEntity;
import com.biz.crm.activiti.mapper.ActReModelMapper;
import com.biz.crm.activiti.mapper.ActivitiBusinessMapper;
import com.biz.crm.activiti.mapper.ActivitiCurrentTaskMapper;
import com.biz.crm.activiti.mapper.TaActFileMapper;
import com.biz.crm.activiti.mapper.TaActTargetMapper;
import com.biz.crm.activiti.mapper.TaNodeConfigMapper;
import com.biz.crm.activiti.mapper.TaTaskCommunicateMapper;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BaseServiceHelper;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.activiti.ActivitiOperateTypeEnum;
import com.biz.crm.eunm.activiti.ColumnStr;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.mdm.user.MdmUserFeign;
import com.biz.crm.nebular.activiti.act.resp.TaActFileRespVo;
import com.biz.crm.nebular.activiti.act.resp.TaActTargetRespVo;
import com.biz.crm.nebular.activiti.design.resp.OptBtnVO;
import com.biz.crm.nebular.activiti.task.resp.OptRecordRspVO;
import com.biz.crm.nebular.activiti.vo.ActGeByteArrayVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionUserOrgReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserPageReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserPageRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.PositionUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.TaskService;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActivitiBusinessHelper
extends BaseServiceHelper {
    private static final Logger log = LoggerFactory.getLogger(ActivitiBusinessHelper.class);
    @Resource
    private TaTaskCommunicateMapper communicateMapper;
    @Resource
    private TaActFileMapper actFileMapper;
    @Resource
    private ActivitiBusinessMapper activitiBusinessMapper;
    @Resource
    private TaActTargetMapper actTargetMapper;
    @Autowired
    private MdmPositionFeign positionFeign;
    @Resource
    private ActReModelMapper modelMapper;
    @Resource
    private ActivitiCurrentTaskMapper currentTaskMapper;
    @Autowired
    private TaskService taskService;
    @Autowired
    private RepositoryService repositoryService;
    @Resource
    private TaNodeConfigMapper nodeConfigMapper;
    @Autowired
    private MdmUserFeign userFeign;

    public String computeProcessTotalHandleTime(String createDateAll, String endDateString) {
        if (StringUtils.isNotEmpty((CharSequence)createDateAll) && StringUtils.isNotEmpty((CharSequence)endDateString)) {
            Date date = DateUtil.str2Date((String)createDateAll, (SimpleDateFormat)DateUtil.datetimeFormat);
            Date nowDate = DateUtil.str2Date((String)endDateString, (SimpleDateFormat)DateUtil.datetimeFormat);
            long time = date.getTime();
            long nowDateTime = nowDate.getTime();
            long l = nowDateTime - time;
            StringBuffer stringBuffer = new StringBuffer();
            long l1 = l / 86400000L;
            stringBuffer.append(l1).append("\u5929");
            long l2 = l - l1 * 86400000L;
            long l3 = l2 / 3600000L;
            stringBuffer.append(l3).append("\u5c0f\u65f6");
            long l4 = l2 - l3 * 3600000L;
            long l5 = l4 / 60000L;
            stringBuffer.append(l5).append("\u5206");
            return stringBuffer.toString();
        }
        return null;
    }

    public List<TaActFileRespVo> findActFileByProcessInstanceIds(List<String> processInstanceIds, Integer fileType) {
        if (CollectionUtils.isEmpty(processInstanceIds)) {
            return Lists.newArrayList();
        }
        List taActFileEntities = this.actFileMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TaActFileEntity.class).in(TaActFileEntity::getProcessInstId, processInstanceIds)).eq(Objects.nonNull(fileType), TaActFileEntity::getFileType, (Object)fileType)).orderByDesc(CrmBaseEntity::getCreateDateAll));
        return CrmBeanUtil.copyList((List)taActFileEntities, TaActFileRespVo.class);
    }

    public List<TaActTargetRespVo> findActTargetConfigByProcessKey(String processKey) {
        if (StringUtils.isEmpty((CharSequence)processKey)) {
            return Lists.newArrayList();
        }
        List entities = this.actTargetMapper.selectList((Wrapper)Wrappers.lambdaQuery(TaActTargetEntity.class).eq(TaActTargetEntity::getProcessKey, (Object)processKey));
        return CrmBeanUtil.copyList((List)entities, TaActTargetRespVo.class);
    }

    public ActivitiBusinessEntity findActivitiBusinessEntityByInstanceId(String processInstanceId) {
        ActivitiBusinessEntity businessEntity = (ActivitiBusinessEntity)this.activitiBusinessMapper.selectOne((Wrapper)Wrappers.lambdaQuery(ActivitiBusinessEntity.class).eq(ActivitiBusinessEntity::getProcessInstanceId, (Object)processInstanceId));
        return businessEntity;
    }

    public ActivitiBusinessEntity findActivitiBusinessEntityByCrmInstanceId(String crmProcessInstanceId) {
        ActivitiBusinessEntity businessEntity = (ActivitiBusinessEntity)this.activitiBusinessMapper.selectOne((Wrapper)Wrappers.lambdaQuery(ActivitiBusinessEntity.class).eq(ActivitiBusinessEntity::getCrmProcessInstanceId, (Object)crmProcessInstanceId));
        return businessEntity;
    }

    public Map<String, MdmPositionUserOrgRespVo> findPositionMapByCodes(List<String> positionCodes) {
        Map<Object, Object> positionMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(positionCodes)) {
            MdmPositionUserOrgReqVo reqVo = new MdmPositionUserOrgReqVo();
            reqVo.setPositionCodeList(positionCodes);
            reqVo.setIncludeEmptyUserPosition(Boolean.valueOf(true));
            List positionByCodeList = Lists.newArrayList();
            try {
                Result positionUserOrgList = this.positionFeign.findPositionUserOrgList(reqVo);
                positionByCodeList = (List)positionUserOrgList.getResult();
            }
            catch (Exception e) {
                log.error("\u8c03\u7528Mdm\u83b7\u53d6\u804c\u4f4d\u6570\u636e\u5f02\u5e38,e={}", (Throwable)e);
            }
            if (CollectionUtils.isNotEmpty((Collection)positionByCodeList)) {
                positionMap = positionByCodeList.stream().collect(Collectors.toMap(MdmPositionUserOrgRespVo::getPositionCode, Function.identity()));
            }
        }
        return positionMap;
    }

    public ActGeByteArrayVo findProcessXmlByDeploymentId(String deploymentId) {
        ActGeByteArrayVo vo = this.modelMapper.findProcessXmlByDeploymentId(deploymentId);
        return vo;
    }

    public List<String> getCurrentUserPositionCodes() {
        UserRedis user = UserUtils.getUser();
        MdmUserReqVo reqVo = new MdmUserReqVo();
        reqVo.setUserName(user.getUsername());
        List mdmPositionRespVos = (List)ApiResultUtil.objResult((Result)this.positionFeign.getUserAllPositionList(reqVo), (boolean)false);
        if (CollectionUtils.isNotEmpty((Collection)mdmPositionRespVos)) {
            return mdmPositionRespVos.stream().map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    public String getProcessOperateLogDesc(String operateType, String positionCode, Boolean isRecall) {
        UserRedis user = UserUtils.getUser();
        if (StringUtils.isEmpty((CharSequence)positionCode)) {
            positionCode = user.getPoscode();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(user.getRealname()).append("[").append(positionCode).append("]");
        if (StringUtils.equals((CharSequence)ActivitiOperateTypeEnum.RECOVER.getCode(), (CharSequence)operateType)) {
            buffer.append("\u8ffd\u56de\u6d41\u7a0b");
        }
        if (StringUtils.equals((CharSequence)ActivitiOperateTypeEnum.PASS.getCode(), (CharSequence)operateType)) {
            buffer.append("\u7b7e\u6279\u6d41\u7a0b");
        }
        if (StringUtils.equals((CharSequence)ActivitiOperateTypeEnum.REJECT.getCode(), (CharSequence)operateType)) {
            buffer.append("\u9a73\u56de\u6d41\u7a0b");
        }
        if (StringUtils.equals((CharSequence)ActivitiOperateTypeEnum.COMMUNICATE.getCode(), (CharSequence)operateType)) {
            buffer.append("\u53d1\u8d77\u6c9f\u901a");
        }
        if (StringUtils.equals((CharSequence)ActivitiOperateTypeEnum.CONFIRM_COMMUNICATE.getCode(), (CharSequence)operateType)) {
            buffer.append("\u786e\u8ba4\u6c9f\u901a");
        }
        if (StringUtils.equals((CharSequence)ActivitiOperateTypeEnum.DELEGATE.getCode(), (CharSequence)operateType)) {
            buffer.append("\u59d4\u6d3e\u4efb\u52a1");
        }
        return buffer.toString();
    }

    public Task findCurrentTaskByTaskId(String taskId) {
        if (StringUtils.isNotEmpty((CharSequence)taskId)) {
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            return task;
        }
        return null;
    }

    public TaNodeConfigEntity findNodeByProcessVersionKeyAndNodeCode(String processVersionKey, String nodeCode) {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processVersionKey).singleResult();
        String nodeId = processDefinition.getKey() + ":" + processDefinition.getVersion() + ":" + nodeCode;
        TaNodeConfigEntity configEntity = (TaNodeConfigEntity)this.nodeConfigMapper.selectOne((Wrapper)Wrappers.lambdaQuery(TaNodeConfigEntity.class).eq(TaNodeConfigEntity::getProcessNodeId, (Object)nodeId));
        return configEntity;
    }

    public void setCurrentTaskPosition(OptRecordRspVO rspVO, Task task) {
        List identityLinks;
        StringBuffer nameBuffer = new StringBuffer();
        StringBuffer codeBuffer = new StringBuffer();
        HashSet existsPositionCodes = Sets.newHashSet();
        if (StringUtils.isNotEmpty((CharSequence)task.getAssignee())) {
            rspVO.setPositionCode(task.getAssignee());
            existsPositionCodes.add(task.getAssignee());
            MdmPositionRespVo positionByCode = PositionUtil.getPositionByCode((String)task.getAssignee());
            codeBuffer.append(task.getAssignee()).append(",");
            if (Objects.nonNull(positionByCode)) {
                nameBuffer.append(positionByCode.getPositionName()).append(",");
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(identityLinks = this.taskService.getIdentityLinksForTask(task.getId())))) {
            identityLinks.forEach(r -> {
                if (StringUtils.isNotEmpty((CharSequence)r.getGroupId())) {
                    Set positionCodes = (Set)ApiResultUtil.objResult((Result)this.positionFeign.findPositionCodeSetByOrgParentAndBpmRoleCodeList(null, (List)Lists.newArrayList((Object[])new String[]{r.getGroupId()})), (boolean)false);
                    List positions = PositionUtil.getPositionByCodeList((List)Lists.newArrayList((Iterable)positionCodes));
                    codeBuffer.append(r.getGroupId()).append(",");
                    positions.stream().filter(o -> !existsPositionCodes.contains(o.getPositionCode())).forEach(o -> {
                        existsPositionCodes.add(o.getPositionCode());
                        nameBuffer.append(o.getPositionName()).append(",");
                    });
                }
            });
        }
        rspVO.setPositionName(nameBuffer.toString());
        rspVO.setPositionCode(codeBuffer.toString());
    }

    public List<TaNodeConfigEntity> findFutureNodesByProcessVersionKey(String processVersionKey, List<Task> taskList) {
        List<TaNodeConfigEntity> entities;
        if (StringUtils.isNotEmpty((CharSequence)processVersionKey) && CollectionUtils.isNotEmpty(entities = this.findNodesByProcessVersionKey(processVersionKey))) {
            Map<String, Integer> map = entities.stream().collect(Collectors.toMap(TaNodeConfigEntity::getProcessNodeCode, TaNodeConfigEntity::getNodeIndex));
            AtomicInteger doneMaxIndex = new AtomicInteger(0);
            HashSet doneNodeCodes = Sets.newHashSet();
            if (CollectionUtils.isNotEmpty(taskList)) {
                for (Task task : taskList) {
                    Integer integer = map.get(task.getTaskDefinitionKey());
                    if (doneMaxIndex.get() < integer) {
                        doneMaxIndex.getAndSet(integer);
                    }
                    doneNodeCodes.add(task.getTaskDefinitionKey());
                }
            }
            return entities.stream().filter(o -> !doneNodeCodes.contains(o.getProcessNodeCode())).filter(o -> o.getNodeIndex() > doneMaxIndex.get()).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    public List<TaNodeConfigEntity> findNodesByProcessVersionKey(String processVersionKey) {
        if (StringUtils.isNotEmpty((CharSequence)processVersionKey)) {
            List entities = this.nodeConfigMapper.selectList((Wrapper)Wrappers.lambdaQuery(TaNodeConfigEntity.class).eq(TaNodeConfigEntity::getProcessVersionKey, (Object)processVersionKey));
            return entities;
        }
        return Lists.newArrayList();
    }

    public List<Task> findCurrentTasksByProcessInstanceId(String processInstanceId) {
        return ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).list();
    }

    public List<OptBtnVO> parseBtnList(String btnAuth) {
        ArrayList<OptBtnVO> btnList = new ArrayList<OptBtnVO>();
        if (StringUtils.isNotEmpty((CharSequence)btnAuth)) {
            String[] btnStr;
            for (String btn : btnStr = btnAuth.split(",")) {
                if (!StringUtils.isNotEmpty((CharSequence)ColumnStr.PROCESS_BTN.getLabelByCode(btn))) continue;
                OptBtnVO btnVO = new OptBtnVO();
                btnVO.setBtnCode(btn);
                btnVO.setBtnName(ColumnStr.PROCESS_BTN.getLabelByCode(btn));
                btnList.add(btnVO);
            }
        }
        return btnList;
    }

    public List<MdmUserPageRespVo> findUsersByCodeList(List<String> userNames) {
        MdmUserPageReqVo userPageReqVo = new MdmUserPageReqVo();
        userPageReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        userPageReqVo.setPageSize(Integer.valueOf(userNames.size()));
        userPageReqVo.setUserNames(userNames);
        Result pageResultResult = this.userFeign.pageList(userPageReqVo);
        PageResult mdmUserPageRespVoPageResult = (PageResult)ApiResultUtil.objResult((Result)pageResultResult, (boolean)true);
        List data = mdmUserPageRespVoPageResult.getData();
        AssertUtils.isTrue((userNames.size() == data.size() ? 1 : 0) != 0, (String)"\u7528\u6237\u6570\u636e\u53d1\u751f\u53d8\u66f4,\u8bf7\u91cd\u65b0\u9009\u62e9\u7528\u6237");
        return data;
    }

    public List<TaTaskCommunicateEntity> findCommunicatesByTaskId(String taskId) {
        return this.communicateMapper.selectList((Wrapper)Wrappers.lambdaQuery(TaTaskCommunicateEntity.class).eq(TaTaskCommunicateEntity::getTaskId, (Object)taskId));
    }
}

