/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.activiti.controller;

import com.biz.crm.activiti.service.TaProcessBizRelationService;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.util.Result;
import com.biz.crm.vo.TaProcessBizRelationReqVo;
import com.biz.crm.vo.TaProcessBizRelationRespVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"taProcessBizRelationController"})
@Api(tags={" \u8fd9\u662f\u6d41\u7a0b\u7ed8\u5236-\u4e1a\u52a1\u5173\u7cfb\u76f8\u5173\u64cd\u4f5c"})
public class TaProcessBizRelationController {
    private static final Logger log = LoggerFactory.getLogger(TaProcessBizRelationController.class);
    @Autowired
    private TaProcessBizRelationService relationService;

    @ApiOperation(value="\u6839\u636e\u6d41\u7a0bkey\u67e5\u627e\u5bf9\u5e94\u7684\u4e1a\u52a1\u5173\u7cfb(\u9700\u8981\u4f20\u5165\u53c2\u6570processKey)")
    @PostMapping(value={"/getRelationByProcessKey"})
    @CrmLog
    public Result<TaProcessBizRelationRespVo> getRelationByProcessKey(@RequestBody String processKey) {
        return Result.ok((Object)this.relationService.getRelationByProcessKey(processKey));
    }

    @ApiOperation(value="\u67e5\u51fa\u6d41\u7a0b\u5217\u8868")
    @PostMapping(value={"/getListRelation"})
    @CrmLog
    public Result<List<TaProcessBizRelationRespVo>> getListRelation(@RequestBody TaProcessBizRelationReqVo taProcessBizRelationReqVo) {
        return Result.ok(this.relationService.getListRelation(taProcessBizRelationReqVo));
    }

    @ApiOperation(value="\u65b0\u589e\u6216\u66f4\u65b0\u4e1a\u52a1\u5173\u7cfb")
    @PostMapping(value={"/insertRelation"})
    @CrmLog
    public Result insertRelation(@RequestBody TaProcessBizRelationReqVo taProcessBizRelationReqVo) {
        this.relationService.insertRelation(taProcessBizRelationReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u5220\u9664\u4e1a\u52a1\u5173\u7cfb")
    @PostMapping(value={"/deleteRelation"})
    @CrmLog
    public Result deleteRelation(@RequestBody String processKey) {
        this.relationService.deleteRelation(processKey);
        return Result.ok();
    }
}

