/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.activiti.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activiti.entity.TaProcessBizRelationEntity;
import com.biz.crm.activiti.mapper.TaProcessBizRelationMapper;
import com.biz.crm.activiti.service.TaProcessBizRelationService;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.activiti.act.TaProcessBizRelationEnum;
import com.biz.crm.nebular.activiti.design.resp.TaProcessOrgRespVO;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.vo.RelationVo;
import com.biz.crm.vo.TaProcessBizRelationReqVo;
import com.biz.crm.vo.TaProcessBizRelationRespVo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TaProcessBizRelationServiceImpl"})
public class TaProcessBizRelationServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TaProcessBizRelationMapper, TaProcessBizRelationEntity>
implements TaProcessBizRelationService {
    private static final Logger log = LoggerFactory.getLogger(TaProcessBizRelationServiceImpl.class);

    @Override
    public TaProcessBizRelationRespVo getRelationByProcessKey(String processKey) {
        if (processKey == null || StringUtils.isEmpty((String)processKey)) {
            throw new BusinessException("\u6d41\u7a0bKey\u4e3a\u7a7a");
        }
        List entityList = this.list((Wrapper)Wrappers.lambdaQuery(TaProcessBizRelationEntity.class).eq(TaProcessBizRelationEntity::getProcessKey, (Object)processKey));
        List menuList = entityList.stream().filter(data -> TaProcessBizRelationEnum.BizRelationEnum.MENU.getVal().equals(data.getRelationType())).collect(Collectors.toList());
        List menuVoList = CrmBeanUtil.copyList(menuList, RelationVo.class);
        List orgList = entityList.stream().filter(data -> TaProcessBizRelationEnum.BizRelationEnum.ORG.getVal().equals(data.getRelationType())).collect(Collectors.toList());
        List orgVoList = CrmBeanUtil.copyList(orgList, RelationVo.class);
        TaProcessBizRelationRespVo respVo = new TaProcessBizRelationRespVo();
        respVo.setProcessKey(((TaProcessBizRelationEntity)entityList.get(0)).getProcessKey());
        respVo.setMenuList(menuVoList);
        respVo.setOrgList(orgVoList);
        return respVo;
    }

    @Override
    public List<TaProcessBizRelationRespVo> getListRelation(TaProcessBizRelationReqVo taProcessBizRelationReqVo) {
        List taProcessBizRelationEntities = this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TaProcessBizRelationEntity.class).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).eq(TaProcessBizRelationEntity::getProcessKey, (Object)taProcessBizRelationReqVo.getProcessKey()));
        ArrayList<TaProcessBizRelationRespVo> result = new ArrayList<TaProcessBizRelationRespVo>();
        Map<String, List<TaProcessBizRelationEntity>> listGroupByProcessKey = taProcessBizRelationEntities.stream().collect(Collectors.groupingBy(TaProcessBizRelationEntity::getProcessKey));
        Set<String> keySet = listGroupByProcessKey.keySet();
        keySet.stream().forEach(data -> {
            TaProcessBizRelationRespVo respVo = new TaProcessBizRelationRespVo();
            respVo.setProcessKey((String)data);
            List menuEntityList = ((List)listGroupByProcessKey.get(data)).stream().filter(entity -> TaProcessBizRelationEnum.BizRelationEnum.MENU.getVal().equals(entity.getRelationType())).collect(Collectors.toList());
            List menuList = CrmBeanUtil.copyList(menuEntityList, RelationVo.class);
            List orgEntityList = ((List)listGroupByProcessKey.get(data)).stream().filter(entity -> TaProcessBizRelationEnum.BizRelationEnum.ORG.getVal().equals(entity.getRelationType())).collect(Collectors.toList());
            List orgList = CrmBeanUtil.copyList(orgEntityList, RelationVo.class);
            respVo.setMenuList(menuList);
            respVo.setOrgList(orgList);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)orgList) && StringUtils.isNotEmpty((String)((RelationVo)orgList.get(0)).getIsOnlyCurrentOrg())) {
                respVo.setIsOnlyCurrentOrg(((RelationVo)orgList.get(0)).getIsOnlyCurrentOrg());
            } else {
                respVo.setIsOnlyCurrentOrg(GlobalWhetherEnum.YES.getCode());
            }
            result.add(respVo);
        });
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteRelation(String processKey) {
        if (processKey == null || StringUtils.isEmpty((String)processKey)) {
            throw new BusinessException("\u6d41\u7a0bKey\u4e3a\u7a7a");
        }
        TaProcessBizRelationEntity entity = new TaProcessBizRelationEntity();
        entity.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
        this.update(entity, (Wrapper)Wrappers.lambdaUpdate(TaProcessBizRelationEntity.class).eq(TaProcessBizRelationEntity::getProcessKey, (Object)processKey));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void insertRelation(TaProcessBizRelationReqVo taProcessBizRelationReqVo) {
        this.checkVo(taProcessBizRelationReqVo);
        this.remove((Wrapper)Wrappers.lambdaQuery(TaProcessBizRelationEntity.class).eq(TaProcessBizRelationEntity::getProcessKey, (Object)taProcessBizRelationReqVo.getProcessKey()));
        this.saveBatch(this.getEntityList(taProcessBizRelationReqVo));
    }

    @Override
    public List<TaProcessOrgRespVO> getListTaProcessByParentOrgs(List<String> parentOrgCodes, String menuCode, String orgCode) {
        return null;
    }

    private void checkVo(TaProcessBizRelationReqVo taProcessBizRelationReqVo) {
        if (taProcessBizRelationReqVo == null) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef");
        }
        String processKey = taProcessBizRelationReqVo.getProcessKey();
        List<RelationVo> menuList = taProcessBizRelationReqVo.getMenuList();
        List<RelationVo> orgList = taProcessBizRelationReqVo.getOrgList();
        if (processKey == null || StringUtils.isEmpty((String)processKey)) {
            throw new BusinessException("\u6d41\u7a0bkey\u4e3a\u7a7a");
        }
        if (menuList == null || menuList.size() == 0) {
            throw new BusinessException("\u83dc\u5355\u4e3a\u7a7a");
        }
        if (orgList == null || orgList.size() == 0) {
            throw new BusinessException("\u7ec4\u7ec7\u4e3a\u7a7a");
        }
        if (!this.checkRepeat(menuList)) {
            throw new BusinessException("\u83dc\u5355\u91cd\u590d");
        }
        if (!this.checkRepeat(orgList)) {
            throw new BusinessException("\u7ec4\u7ec7\u91cd\u590d");
        }
    }

    private List<TaProcessBizRelationEntity> getEntityList(TaProcessBizRelationReqVo taProcessBizRelationReqVo) {
        List entityMenuList = CrmBeanUtil.copyList(taProcessBizRelationReqVo.getMenuList(), TaProcessBizRelationEntity.class);
        entityMenuList.forEach(data -> data.setRelationType(TaProcessBizRelationEnum.BizRelationEnum.MENU.getVal()).setProcessKey(taProcessBizRelationReqVo.getProcessKey()).setDelFlag(CrmDelFlagEnum.NORMAL.getCode()));
        List entityOrgList = CrmBeanUtil.copyList(taProcessBizRelationReqVo.getOrgList(), TaProcessBizRelationEntity.class);
        entityOrgList.forEach(data -> data.setRelationType(TaProcessBizRelationEnum.BizRelationEnum.ORG.getVal()).setProcessKey(taProcessBizRelationReqVo.getProcessKey()).setIsOnlyCurrentOrg(taProcessBizRelationReqVo.getIsOnlyCurrentOrg()).setDelFlag(CrmDelFlagEnum.NORMAL.getCode()));
        entityMenuList.addAll(entityOrgList);
        return entityMenuList;
    }

    private boolean checkRepeat(List<RelationVo> list) {
        List collect = list.stream().distinct().collect(Collectors.toList());
        return collect.size() == list.size();
    }
}

