/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.activiti.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.activiti.entity.ActivitiBusinessEntity;
import com.biz.crm.activiti.entity.TaActFileEntity;
import com.biz.crm.activiti.entity.TaActTargetEntity;
import com.biz.crm.activiti.entity.TaNodeConfigEntity;
import com.biz.crm.activiti.entity.TaTaskCommunicateEntity;
import com.biz.crm.activiti.mapper.ActReModelMapper;
import com.biz.crm.activiti.mapper.ActivitiBusinessMapper;
import com.biz.crm.activiti.mapper.ActivitiCurrentTaskMapper;
import com.biz.crm.activiti.mapper.TaActFileMapper;
import com.biz.crm.activiti.mapper.TaActTargetMapper;
import com.biz.crm.activiti.mapper.TaNodeConfigMapper;
import com.biz.crm.activiti.mapper.TaTaskCommunicateMapper;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BaseServiceHelper;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.activiti.ActivitiOperateTypeEnum;
import com.biz.crm.eunm.activiti.ColumnStr;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.mdm.user.MdmUserFeign;
import com.biz.crm.nebular.activiti.act.resp.TaActFileRespVo;
import com.biz.crm.nebular.activiti.act.resp.TaActTargetRespVo;
import com.biz.crm.nebular.activiti.design.resp.OptBtnVO;
import com.biz.crm.nebular.activiti.task.resp.OptRecordRspVO;
import com.biz.crm.nebular.activiti.vo.ActGeByteArrayVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionUserOrgReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserPageReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserPageRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.PositionUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import org.activiti.engine.impl.javax.el.ELContext;
import org.activiti.engine.impl.javax.el.ValueExpression;
import org.activiti.engine.impl.juel.ExpressionFactoryImpl;
import org.activiti.engine.impl.juel.SimpleContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.task.TaskDefinition;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActivitiBusinessHelper
extends BaseServiceHelper {
    private static final Logger log = LoggerFactory.getLogger(ActivitiBusinessHelper.class);
    @Resource
    private TaTaskCommunicateMapper communicateMapper;
    @Resource
    private TaActFileMapper actFileMapper;
    @Resource
    private ActivitiBusinessMapper activitiBusinessMapper;
    @Resource
    private TaActTargetMapper actTargetMapper;
    @Autowired
    private MdmPositionFeign positionFeign;
    @Resource
    private ActReModelMapper modelMapper;
    @Resource
    private ActivitiCurrentTaskMapper currentTaskMapper;
    @Autowired
    private TaskService taskService;
    @Autowired
    private RepositoryService repositoryService;
    @Resource
    private TaNodeConfigMapper nodeConfigMapper;
    @Autowired
    private MdmUserFeign userFeign;
    @Autowired
    private RuntimeService runtimeService;

    public String computeProcessTotalHandleTime(String createDateAll, String endDateString) {
        if (StringUtils.isNotEmpty((CharSequence)createDateAll) && StringUtils.isNotEmpty((CharSequence)endDateString)) {
            Date date = DateUtil.str2Date((String)createDateAll, (SimpleDateFormat)DateUtil.datetimeFormat);
            Date nowDate = DateUtil.str2Date((String)endDateString, (SimpleDateFormat)DateUtil.datetimeFormat);
            long time = date.getTime();
            long nowDateTime = nowDate.getTime();
            long l = nowDateTime - time;
            StringBuffer stringBuffer = new StringBuffer();
            long l1 = l / 86400000L;
            stringBuffer.append(l1).append("\u5929");
            long l2 = l - l1 * 86400000L;
            long l3 = l2 / 3600000L;
            stringBuffer.append(l3).append("\u5c0f\u65f6");
            long l4 = l2 - l3 * 3600000L;
            long l5 = l4 / 60000L;
            stringBuffer.append(l5).append("\u5206");
            return stringBuffer.toString();
        }
        return null;
    }

    public List<TaActFileRespVo> findActFileByProcessInstanceIds(List<String> processInstanceIds, Integer fileType) {
        if (CollectionUtils.isEmpty(processInstanceIds)) {
            return Lists.newArrayList();
        }
        List taActFileEntities = this.actFileMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TaActFileEntity.class).in(TaActFileEntity::getProcessInstId, processInstanceIds)).eq(Objects.nonNull(fileType), TaActFileEntity::getFileType, (Object)fileType)).orderByDesc(CrmBaseEntity::getCreateDateAll));
        return CrmBeanUtil.copyList((List)taActFileEntities, TaActFileRespVo.class);
    }

    public List<TaActTargetRespVo> findActTargetConfigByProcessKey(String processKey) {
        if (StringUtils.isEmpty((CharSequence)processKey)) {
            return Lists.newArrayList();
        }
        List entities = this.actTargetMapper.selectList((Wrapper)Wrappers.lambdaQuery(TaActTargetEntity.class).eq(TaActTargetEntity::getProcessKey, (Object)processKey));
        return CrmBeanUtil.copyList((List)entities, TaActTargetRespVo.class);
    }

    public ActivitiBusinessEntity findActivitiBusinessEntityByInstanceId(String processInstanceId) {
        ActivitiBusinessEntity businessEntity = (ActivitiBusinessEntity)this.activitiBusinessMapper.selectOne((Wrapper)Wrappers.lambdaQuery(ActivitiBusinessEntity.class).eq(ActivitiBusinessEntity::getProcessInstanceId, (Object)processInstanceId));
        return businessEntity;
    }

    public ActivitiBusinessEntity findActivitiBusinessEntityByCrmInstanceId(String crmProcessInstanceId) {
        ActivitiBusinessEntity businessEntity = (ActivitiBusinessEntity)this.activitiBusinessMapper.selectOne((Wrapper)Wrappers.lambdaQuery(ActivitiBusinessEntity.class).eq(ActivitiBusinessEntity::getCrmProcessInstanceId, (Object)crmProcessInstanceId));
        return businessEntity;
    }

    public Map<String, MdmPositionUserOrgRespVo> findPositionMapByCodes(List<String> positionCodes) {
        Map<Object, Object> positionMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(positionCodes)) {
            MdmPositionUserOrgReqVo reqVo = new MdmPositionUserOrgReqVo();
            reqVo.setPositionCodeList(positionCodes);
            reqVo.setIncludeEmptyUserPosition(Boolean.valueOf(true));
            List positionByCodeList = Lists.newArrayList();
            try {
                Result positionUserOrgList = this.positionFeign.findPositionUserOrgList(reqVo);
                positionByCodeList = (List)positionUserOrgList.getResult();
            }
            catch (Exception e) {
                log.error("\u8c03\u7528Mdm\u83b7\u53d6\u804c\u4f4d\u6570\u636e\u5f02\u5e38,e={}", (Throwable)e);
            }
            if (CollectionUtils.isNotEmpty((Collection)positionByCodeList)) {
                positionMap = positionByCodeList.stream().collect(Collectors.toMap(MdmPositionUserOrgRespVo::getPositionCode, Function.identity()));
            }
        }
        return positionMap;
    }

    public ActGeByteArrayVo findProcessXmlByDeploymentId(String deploymentId) {
        ActGeByteArrayVo vo = this.modelMapper.findProcessXmlByDeploymentId(deploymentId);
        return vo;
    }

    public List<String> getCurrentUserPositionCodes() {
        UserRedis user = UserUtils.getUser();
        MdmUserReqVo reqVo = new MdmUserReqVo();
        reqVo.setUserName(user.getUsername());
        List mdmPositionRespVos = (List)ApiResultUtil.objResult((Result)this.positionFeign.getUserAllPositionList(reqVo), (boolean)false);
        if (CollectionUtils.isNotEmpty((Collection)mdmPositionRespVos)) {
            return mdmPositionRespVos.stream().map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    public String getProcessOperateLogDesc(String operateType, String positionCode, Boolean isRecall) {
        UserRedis user = UserUtils.getUser();
        if (StringUtils.isEmpty((CharSequence)positionCode)) {
            positionCode = user.getPoscode();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(user.getRealname()).append("[").append(positionCode).append("]");
        if (StringUtils.equals((CharSequence)ActivitiOperateTypeEnum.RECOVER.getCode(), (CharSequence)operateType)) {
            buffer.append("\u8ffd\u56de\u6d41\u7a0b");
        }
        if (StringUtils.equals((CharSequence)ActivitiOperateTypeEnum.PASS.getCode(), (CharSequence)operateType)) {
            buffer.append("\u7b7e\u6279\u6d41\u7a0b");
        }
        if (StringUtils.equals((CharSequence)ActivitiOperateTypeEnum.REJECT.getCode(), (CharSequence)operateType)) {
            buffer.append("\u9a73\u56de\u6d41\u7a0b");
        }
        if (StringUtils.equals((CharSequence)ActivitiOperateTypeEnum.COMMUNICATE.getCode(), (CharSequence)operateType)) {
            buffer.append("\u53d1\u8d77\u6c9f\u901a");
        }
        if (StringUtils.equals((CharSequence)ActivitiOperateTypeEnum.CONFIRM_COMMUNICATE.getCode(), (CharSequence)operateType)) {
            buffer.append("\u786e\u8ba4\u6c9f\u901a");
        }
        if (StringUtils.equals((CharSequence)ActivitiOperateTypeEnum.DELEGATE.getCode(), (CharSequence)operateType)) {
            buffer.append("\u59d4\u6d3e\u4efb\u52a1");
        }
        return buffer.toString();
    }

    public Task findCurrentTaskByTaskId(String taskId) {
        if (StringUtils.isNotEmpty((CharSequence)taskId)) {
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            return task;
        }
        return null;
    }

    public TaNodeConfigEntity findNodeByProcessVersionKeyAndNodeCode(String processVersionKey, String nodeCode) {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processVersionKey).singleResult();
        String nodeId = processDefinition.getKey() + ":" + processDefinition.getVersion() + ":" + nodeCode;
        TaNodeConfigEntity configEntity = (TaNodeConfigEntity)this.nodeConfigMapper.selectOne((Wrapper)Wrappers.lambdaQuery(TaNodeConfigEntity.class).eq(TaNodeConfigEntity::getProcessNodeId, (Object)nodeId));
        return configEntity;
    }

    public void setCurrentTaskPosition(OptRecordRspVO rspVO, Task task) {
        List identityLinks;
        StringBuffer nameBuffer = new StringBuffer();
        StringBuffer codeBuffer = new StringBuffer();
        HashSet existsPositionCodes = Sets.newHashSet();
        if (StringUtils.isNotEmpty((CharSequence)task.getAssignee())) {
            rspVO.setPositionCode(task.getAssignee());
            existsPositionCodes.add(task.getAssignee());
            MdmPositionRespVo positionByCode = PositionUtil.getPositionByCode((String)task.getAssignee());
            codeBuffer.append(task.getAssignee()).append(",");
            if (Objects.nonNull(positionByCode)) {
                nameBuffer.append(positionByCode.getPositionName()).append(",");
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(identityLinks = this.taskService.getIdentityLinksForTask(task.getId())))) {
            identityLinks.forEach(r -> {
                if (StringUtils.isNotEmpty((CharSequence)r.getGroupId())) {
                    Set positionCodes = (Set)ApiResultUtil.objResult((Result)this.positionFeign.findPositionCodeSetByOrgParentAndBpmRoleCodeList(null, (List)Lists.newArrayList((Object[])new String[]{r.getGroupId()})), (boolean)false);
                    List positions = PositionUtil.getPositionByCodeList((List)Lists.newArrayList((Iterable)positionCodes));
                    codeBuffer.append(r.getGroupId()).append(",");
                    positions.stream().filter(o -> !existsPositionCodes.contains(o.getPositionCode())).forEach(o -> {
                        existsPositionCodes.add(o.getPositionCode());
                        nameBuffer.append(o.getPositionName()).append(",");
                    });
                }
            });
        }
        rspVO.setPositionName(nameBuffer.toString());
        rspVO.setPositionCode(codeBuffer.toString());
    }

    public List<TaNodeConfigEntity> findFutureNodesByProcessVersionKey(String processVersionKey, List<Task> taskList) {
        List<TaNodeConfigEntity> entities;
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(taskList.get(0).getProcessDefinitionId());
        String currentTaskDefKey = taskList.get(0).getTaskDefinitionKey();
        ArrayList list = Lists.newArrayList();
        Boolean outFlag = false;
        while (!outFlag.booleanValue()) {
            ActivityImpl activityImpl = processDefinition.findActivity(currentTaskDefKey);
            List outTransitions = activityImpl.getOutgoingTransitions();
            if (CollectionUtils.isEmpty((Collection)outTransitions)) {
                outFlag = true;
            }
            for (PvmTransition tr : outTransitions) {
                PvmActivity ac = tr.getDestination();
                if (!Objects.nonNull(ac)) continue;
                Object type = ac.getProperty("type");
                if (Objects.isNull(type) || StringUtils.contains((CharSequence)type.toString().toLowerCase(), (CharSequence)"end")) {
                    outFlag = true;
                    continue;
                }
                list.add(ac.getId());
                currentTaskDefKey = ac.getId();
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)processVersionKey) && CollectionUtils.isNotEmpty((Collection)list) && CollectionUtils.isNotEmpty(entities = this.findNodesByProcessVersionKey(processVersionKey))) {
            Map map = entities.stream().collect(Collectors.toMap(TaNodeConfigEntity::getProcessNodeCode, Function.identity()));
            Collections.reverse(list);
            return list.stream().filter(o -> map.containsKey(o)).map(o -> {
                TaNodeConfigEntity nodeConfigEntity = (TaNodeConfigEntity)map.get(o);
                return nodeConfigEntity;
            }).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    public List<TaNodeConfigEntity> findNodesByProcessVersionKey(String processVersionKey) {
        if (StringUtils.isNotEmpty((CharSequence)processVersionKey)) {
            List entities = this.nodeConfigMapper.selectList((Wrapper)Wrappers.lambdaQuery(TaNodeConfigEntity.class).eq(TaNodeConfigEntity::getProcessVersionKey, (Object)processVersionKey));
            return entities;
        }
        return Lists.newArrayList();
    }

    public List<Task> findCurrentTasksByProcessInstanceId(String processInstanceId) {
        return ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).list();
    }

    public List<OptBtnVO> parseBtnList(String btnAuth) {
        ArrayList<OptBtnVO> btnList = new ArrayList<OptBtnVO>();
        if (StringUtils.isNotEmpty((CharSequence)btnAuth)) {
            String[] btnStr;
            for (String btn : btnStr = btnAuth.split(",")) {
                if (!StringUtils.isNotEmpty((CharSequence)ColumnStr.PROCESS_BTN.getLabelByCode(btn))) continue;
                OptBtnVO btnVO = new OptBtnVO();
                btnVO.setBtnCode(btn);
                btnVO.setBtnName(ColumnStr.PROCESS_BTN.getLabelByCode(btn));
                btnList.add(btnVO);
            }
        }
        return btnList;
    }

    public List<MdmUserPageRespVo> findUsersByCodeList(List<String> userNames) {
        MdmUserPageReqVo userPageReqVo = new MdmUserPageReqVo();
        userPageReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        userPageReqVo.setPageSize(Integer.valueOf(userNames.size()));
        userPageReqVo.setUserNames(userNames);
        Result pageResultResult = this.userFeign.pageList(userPageReqVo);
        PageResult mdmUserPageRespVoPageResult = (PageResult)ApiResultUtil.objResult((Result)pageResultResult, (boolean)true);
        List data = mdmUserPageRespVoPageResult.getData();
        AssertUtils.isTrue((userNames.size() == data.size() ? 1 : 0) != 0, (String)"\u7528\u6237\u6570\u636e\u53d1\u751f\u53d8\u66f4,\u8bf7\u91cd\u65b0\u9009\u62e9\u7528\u6237");
        return data;
    }

    public List<TaTaskCommunicateEntity> findCommunicatesByTaskId(String taskId) {
        return this.communicateMapper.selectList((Wrapper)Wrappers.lambdaQuery(TaTaskCommunicateEntity.class).eq(TaTaskCommunicateEntity::getTaskId, (Object)taskId));
    }

    public MdmPositionUserOrgRespVo findUserByPositionCode(String positionCode) {
        MdmPositionUserOrgReqVo mdmPositionUserOrgReqVo = new MdmPositionUserOrgReqVo();
        mdmPositionUserOrgReqVo.setPositionCode(positionCode);
        mdmPositionUserOrgReqVo.setUserEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        List mdmPositionUserOrgRespVos = (List)ApiResultUtil.objResult((Result)this.positionFeign.findPositionUserOrgList(mdmPositionUserOrgReqVo), (boolean)true);
        return CollectionUtils.isNotEmpty((Collection)mdmPositionUserOrgRespVos) ? (MdmPositionUserOrgRespVo)mdmPositionUserOrgRespVos.get(0) : null;
    }

    public TaskDefinition getNextTaskGroup(String taskId) throws Exception {
        ProcessDefinitionEntity processDefinitionEntity = null;
        String id = null;
        TaskDefinition task = null;
        String processInstanceId = ((Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult()).getProcessInstanceId();
        String definitionId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult()).getProcessDefinitionId();
        processDefinitionEntity = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(definitionId);
        ExecutionEntity execution = (ExecutionEntity)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        String activitiId = execution.getActivityId();
        List activitiList = processDefinitionEntity.getActivities();
        for (ActivityImpl activityImpl : activitiList) {
            id = activityImpl.getId();
            if (!activitiId.equals(id)) continue;
            task = this.nextTaskDefinition(activityImpl, activityImpl.getId(), null, processInstanceId);
            break;
        }
        return task;
    }

    private TaskDefinition nextTaskDefinition(ActivityImpl activityImpl, String activityId, String elString, String processInstanceId) {
        PvmActivity ac = null;
        Object s = null;
        if ("userTask".equals(activityImpl.getProperty("type")) && !activityId.equals(activityImpl.getId())) {
            TaskDefinition taskDefinition = ((UserTaskActivityBehavior)activityImpl.getActivityBehavior()).getTaskDefinition();
            return taskDefinition;
        }
        List outTransitions = activityImpl.getOutgoingTransitions();
        List outTransitionsTemp = null;
        for (PvmTransition tr : outTransitions) {
            ac = tr.getDestination();
            if ("exclusiveGateway".equals(ac.getProperty("type"))) {
                outTransitionsTemp = ac.getOutgoingTransitions();
                if (StringUtils.isEmpty((CharSequence)elString)) {
                    elString = this.getGatewayCondition(ac.getId(), processInstanceId);
                }
                if (outTransitionsTemp.size() == 1) {
                    return this.nextTaskDefinition((ActivityImpl)((PvmTransition)outTransitionsTemp.get(0)).getDestination(), activityId, elString, processInstanceId);
                }
                if (outTransitionsTemp.size() <= 1) continue;
                for (PvmTransition tr1 : outTransitionsTemp) {
                    s = tr1.getProperty("conditionText");
                    if (!this.isCondition(ac.getId(), StringUtils.trim((String)s.toString()), elString)) continue;
                    return this.nextTaskDefinition((ActivityImpl)tr1.getDestination(), activityId, elString, processInstanceId);
                }
                continue;
            }
            if (!"userTask".equals(ac.getProperty("type"))) continue;
            return ((UserTaskActivityBehavior)((ActivityImpl)ac).getActivityBehavior()).getTaskDefinition();
        }
        return null;
    }

    public boolean isCondition(String key, String el, String value) {
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        SimpleContext context = new SimpleContext();
        context.setVariable(key, factory.createValueExpression((Object)value, String.class));
        ValueExpression e = factory.createValueExpression((ELContext)context, el, Boolean.TYPE);
        return (Boolean)e.getValue((ELContext)context);
    }

    public String getGatewayCondition(String gatewayId, String processInstanceId) {
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(processInstanceId).singleResult();
        return this.runtimeService.getVariable(execution.getId(), gatewayId).toString();
    }

    public Map<String, Set<String>> getCurrentTaskAllPositions(String processInstanceId) {
        List<Task> taskList;
        UserRedis user = UserUtils.getUser();
        HashMap map = Maps.newHashMap();
        if (StringUtils.isNotEmpty((CharSequence)processInstanceId) && CollectionUtils.isNotEmpty(taskList = this.findCurrentTasksByProcessInstanceId(processInstanceId))) {
            taskList.forEach(o -> {
                HashSet positions = Sets.newHashSet();
                if (StringUtils.isNotEmpty((CharSequence)o.getAssignee())) {
                    positions.add(o.getAssignee());
                }
                List identityLinksForTask = this.taskService.getIdentityLinksForTask(o.getId());
                identityLinksForTask.forEach(p -> {
                    if (StringUtils.isNotEmpty((CharSequence)p.getUserId())) {
                        positions.add(p.getUserId());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)p.getGroupId())) {
                        Set posCodes = (Set)ApiResultUtil.objResult((Result)this.positionFeign.findPositionCodeSetByOrgAndBpmRoleCodeList(user.getOrgcode(), (List)Lists.newArrayList((Object[])new String[]{p.getGroupId()})));
                        positions.addAll(posCodes);
                    }
                });
                map.put(o.getId(), positions);
            });
        }
        return map;
    }
}

