/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.activiti.controller;

import com.biz.crm.activiti.service.ReceiveMdmService;
import com.biz.crm.activiti.user.GroupActivitiVo;
import com.biz.crm.activiti.user.MembershipActivitiVo;
import com.biz.crm.activiti.user.UserActivitiVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.ProcessEngines;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/receiveMdmController"})
@Api(value="\u540c\u6b65MDM\u4e3b\u6570\u636e", tags={"\u540c\u6b65MDM\u4e3b\u6570\u636e"})
public class ReceiveMdmController {
    private static final Logger log = LoggerFactory.getLogger(ReceiveMdmController.class);
    @Autowired
    private ReceiveMdmService receiveMdmService;

    @ApiOperation(value="\u4fee\u6539\u4e0e\u66f4\u65b0\u7528\u6237")
    @PostMapping(value={"saveUser"})
    public Result saveUser(@RequestBody UserActivitiVo userActivitiVo) {
        Result result = new Result();
        this.receiveMdmService.saveUser(userActivitiVo);
        return result;
    }

    @ApiOperation(value="\u5220\u9664\u7528\u6237")
    @PostMapping(value={"deleteUser"})
    public Result deleteUser(@RequestParam(value="username") String username) {
        Result result = new Result();
        ProcessEngine engine = ProcessEngines.getDefaultProcessEngine();
        IdentityService identityService = engine.getIdentityService();
        identityService.deleteUser(username);
        return result;
    }

    @ApiOperation(value="\u4fdd\u5b58\u4fee\u6539\u7528\u6237\u7ec4")
    @PostMapping(value={"saveUserGroup"})
    public Result saveUserGroup(@RequestBody GroupActivitiVo groupActivitiVo) {
        Result result = new Result();
        this.receiveMdmService.saveGroup(groupActivitiVo);
        return result;
    }

    @ApiOperation(value="\u5220\u9664\u7528\u6237\u7ec4")
    @PostMapping(value={"deleteGroup"})
    public Result deleteGroup(@RequestParam(value="type") String type) {
        Result result = new Result();
        ProcessEngine engine = ProcessEngines.getDefaultProcessEngine();
        IdentityService identityService = engine.getIdentityService();
        identityService.deleteGroup(type);
        return result;
    }

    @ApiOperation(value="\u4fdd\u5b58\u7528\u6237\u4e0e\u7528\u6237\u7ec4\u5173\u7cfb")
    @PostMapping(value={"saveMembership"})
    public Result saveMembership(@RequestBody List<MembershipActivitiVo> membershipActivitiVos) {
        Result result = new Result();
        membershipActivitiVos.forEach(item -> this.receiveMdmService.saveMembership((MembershipActivitiVo)item));
        return result;
    }

    @ApiOperation(value="\u5220\u9664\u7528\u6237\u4e0e\u7528\u6237\u7ec4\u5173\u7cfb")
    @PostMapping(value={"deleteMembership"})
    public Result deleteMembership(@RequestBody List<MembershipActivitiVo> membershipActivitiVos) {
        Result result = new Result();
        ProcessEngine engine = ProcessEngines.getDefaultProcessEngine();
        IdentityService identityService = engine.getIdentityService();
        membershipActivitiVos.forEach(item -> identityService.deleteMembership(item.getPosCode(), item.getBpmRoleCode()));
        return result;
    }
}

