/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.design.controller;

import com.biz.crm.activiti.service.BizRuntimeService;
import com.biz.crm.design.service.DesignService;
import com.biz.crm.design.vo.NewModelVo;
import com.biz.crm.design.vo.SaveModelVo;
import com.biz.crm.util.HttpServletRequestUtil;
import com.biz.crm.util.Result;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.ProcessDefinition;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/designController"})
public class DesignController {
    private static final Logger log = LoggerFactory.getLogger(DesignController.class);
    @Autowired
    private DesignService designService;
    @Resource
    private RepositoryService repositoryService;
    @Autowired
    private BizRuntimeService bizRuntimeService;

    @ResponseBody
    @PostMapping(value={"newModel"})
    public Result newModel(@RequestBody NewModelVo newModelVo) {
        String id = this.designService.newModel(newModelVo);
        return Result.ok((String)id);
    }

    @GetMapping(value={"editor"})
    public ModelAndView modelOpen() {
        ModelAndView model = new ModelAndView("modeler");
        return model;
    }

    @RequestMapping(value={"/model/{modelId}/json"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ObjectNode getEditorJson(@PathVariable String modelId) {
        ObjectNode modelNode = this.designService.getEditorJson(modelId);
        return modelNode;
    }

    @RequestMapping(value={"/editor/stencilset"}, method={RequestMethod.GET}, produces={"application/json;charset=utf-8"})
    @ResponseBody
    public String getStencilset() {
        InputStream stencilsetStream = this.getClass().getClassLoader().getResourceAsStream("stencilset.json");
        try {
            return IOUtils.toString((InputStream)stencilsetStream, (String)"utf-8");
        }
        catch (Exception e) {
            throw new ActivitiException("Error while loading stencil set", (Throwable)e);
        }
    }

    @ApiOperation(value="\u7f16\u8f91\u6d41\u7a0b\u4fe1\u606f")
    @PostMapping(value={"/model/{modelId}/save"})
    @ResponseStatus(value=HttpStatus.OK)
    public void saveModel(@PathVariable String modelId, @RequestBody SaveModelVo saveModelVo) {
        saveModelVo.setModelId(modelId);
        this.designService.updateModel(saveModelVo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"showPic"})
    @ResponseStatus(value=HttpStatus.OK)
    public void showPic(@RequestParam(value="deploymentId") String deploymentId) throws IOException {
        HttpServletResponse httpServletResponse = HttpServletRequestUtil.getResponse();
        String ext = ".png";
        if (StringUtils.isEmpty((CharSequence)deploymentId) || StringUtils.isEmpty((CharSequence)ext)) {
            return;
        }
        InputStream in = null;
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deploymentId).singleResult();
        if (".png".equalsIgnoreCase(ext)) {
            in = this.repositoryService.getProcessDiagram(processDefinition.getId());
        } else if (".bpmn".equalsIgnoreCase(ext)) {
            in = this.repositoryService.getResourceAsStream(deploymentId, processDefinition.getResourceName());
        }
        ServletOutputStream out = null;
        byte[] buf = new byte[1024];
        int legth = 0;
        try {
            out = httpServletResponse.getOutputStream();
            while ((legth = in.read(buf)) != -1) {
                out.write(buf, 0, legth);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"showBpmn"})
    @ResponseStatus(value=HttpStatus.OK)
    public void showBpmn(@RequestParam(value="deploymentId") String deploymentId) throws IOException {
        HttpServletResponse httpServletResponse = HttpServletRequestUtil.getResponse();
        httpServletResponse.setContentType("UTF-8");
        httpServletResponse.setCharacterEncoding("UTF-8");
        String ext = ".bpmn";
        if (StringUtils.isEmpty((CharSequence)deploymentId) || StringUtils.isEmpty((CharSequence)ext)) {
            return;
        }
        InputStream in = null;
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deploymentId).singleResult();
        if (".png".equalsIgnoreCase(ext)) {
            in = this.repositoryService.getProcessDiagram(processDefinition.getId());
        } else if (".bpmn".equalsIgnoreCase(ext)) {
            in = this.repositoryService.getResourceAsStream(deploymentId, processDefinition.getResourceName());
        }
        ServletOutputStream out = null;
        byte[] buf = new byte[1024];
        int legth = 0;
        try {
            out = httpServletResponse.getOutputStream();
            while ((legth = in.read(buf)) != -1) {
                out.write(buf, 0, legth);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    @GetMapping(value={"getProcessPicInfo"})
    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u56fe\u7247\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processInstanceId", value="\u6d41\u7a0b\u7f16\u7801", required=false, dataType="String", paramType="query")})
    @ResponseStatus(value=HttpStatus.OK)
    public void getProcessPicInfo(@RequestParam(value="processInstanceId", required=true) String processInstanceId) {
        HttpServletResponse response = HttpServletRequestUtil.getResponse();
        response.setContentType("UTF-8");
        response.setCharacterEncoding("UTF-8");
        try {
            InputStream is = this.bizRuntimeService.getProcessInstancePicInfo(processInstanceId);
            int len = 0;
            byte[] b = new byte[1024];
            while ((len = is.read(b, 0, 1024)) != -1) {
                response.getOutputStream().write(b, 0, len);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }
}

