/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.activiti.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activiti.entity.ActivitiBusinessEntity;
import com.biz.crm.activiti.mapper.ActivitiBusinessMapper;
import com.biz.crm.activiti.service.ActivitiBusinessService;
import com.biz.crm.activiti.service.impl.ActivitiBusinessHelper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.activiti.ActivitiOperateTypeEnum;
import com.biz.crm.eunm.activiti.ProcessInstanceStatusEnum;
import com.biz.crm.nebular.activiti.vo.ActivitiBusinessVo;
import com.biz.crm.nebular.activiti.vo.ProcessInstanceQueryReqVo;
import com.biz.crm.nebular.activiti.vo.ProcessInstanceQueryRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"ActivitiBusinessExpandServiceImpl"})
public class ActivitiBusinessServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<ActivitiBusinessMapper, ActivitiBusinessEntity>
implements ActivitiBusinessService {
    private static final Logger log = LoggerFactory.getLogger(ActivitiBusinessServiceImpl.class);
    @Resource
    private ActivitiBusinessMapper activitiBusinessMapper;
    @Autowired
    private ActivitiBusinessHelper helper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ActivitiBusinessEntity save(ProcessInstance processInstance, ActivitiBusinessVo activitiBusinessVo) {
        ActivitiBusinessEntity activitiBusinessEntity = (ActivitiBusinessEntity)CrmBeanUtil.copy((Object)activitiBusinessVo, ActivitiBusinessEntity.class);
        activitiBusinessEntity.setRemarks(activitiBusinessVo.getRemark());
        activitiBusinessEntity.setCrmProcessInstanceId(CodeUtil.getCodeYyyymmddHHmm());
        activitiBusinessEntity.setProcessInstanceId(processInstance.getId());
        activitiBusinessEntity.setProcessVersionKey(processInstance.getProcessDefinitionId());
        activitiBusinessEntity.setBpmStatus(ActivitiOperateTypeEnum.COMMIT.getCode());
        activitiBusinessEntity.setProcessInstanceStatus(ProcessInstanceStatusEnum.ENABLE.getCode());
        activitiBusinessEntity.setCommitDate(DateUtil.date2Str((Date)new Date(), (SimpleDateFormat)DateUtil.datetimeFormat));
        this.save(activitiBusinessEntity);
        return activitiBusinessEntity;
    }

    @Override
    public ActivitiBusinessEntity getByProcessInstanceId(String crmProcessInstanceId) {
        List activitiBusinessEntities = this.list((Wrapper)Wrappers.lambdaQuery(ActivitiBusinessEntity.class).eq(ActivitiBusinessEntity::getCrmProcessInstanceId, (Object)crmProcessInstanceId));
        AssertUtils.isNotEmpty((Collection)activitiBusinessEntities, (String)("\u6d41\u7a0b\u7f16\u53f7\u5df2\u4e0d\u5b58\u5728[" + crmProcessInstanceId + "]"));
        return (ActivitiBusinessEntity)activitiBusinessEntities.get(0);
    }

    @Override
    public ActivitiBusinessEntity getByCrmProcessInstanceId(String processInstanceId) {
        List activitiBusinessEntities = this.list((Wrapper)Wrappers.lambdaQuery(ActivitiBusinessEntity.class).eq(ActivitiBusinessEntity::getProcessInstanceId, (Object)processInstanceId));
        AssertUtils.isNotEmpty((Collection)activitiBusinessEntities, (String)("\u6d41\u7a0b\u5b9e\u4f8b\u5df2\u4e0d\u5b58\u5728[" + processInstanceId + "]"));
        return (ActivitiBusinessEntity)activitiBusinessEntities.get(0);
    }

    @Override
    public ActivitiBusinessEntity getActivitiBusiness(String crmProcessInstanceId, String processInstanceId) {
        if (StringUtils.isEmpty((CharSequence)crmProcessInstanceId) && StringUtils.isEmpty((CharSequence)processInstanceId)) {
            throw new BusinessException("\u53c2\u6570\u4e0d\u80fd\u5168\u4e3a\u7a7a[crmProcessInstanceId][processInstanceId]");
        }
        if (StringUtils.isNotBlank((CharSequence)crmProcessInstanceId)) {
            List activitiBusinessEntities = this.list((Wrapper)Wrappers.lambdaQuery(ActivitiBusinessEntity.class).eq(ActivitiBusinessEntity::getCrmProcessInstanceId, (Object)crmProcessInstanceId));
            AssertUtils.isNotEmpty((Collection)activitiBusinessEntities, (String)("\u6d41\u7a0b\u7f16\u53f7\u5df2\u4e0d\u5b58\u5728[" + crmProcessInstanceId + "]"));
            return (ActivitiBusinessEntity)activitiBusinessEntities.get(0);
        }
        if (StringUtils.isNotBlank((CharSequence)processInstanceId)) {
            List activitiBusinessEntities = this.list((Wrapper)Wrappers.lambdaQuery(ActivitiBusinessEntity.class).eq(ActivitiBusinessEntity::getProcessInstanceId, (Object)processInstanceId));
            AssertUtils.isNotEmpty((Collection)activitiBusinessEntities, (String)("\u6d41\u7a0b\u5b9e\u4f8b\u5df2\u4e0d\u5b58\u5728[" + processInstanceId + "]"));
            return (ActivitiBusinessEntity)activitiBusinessEntities.get(0);
        }
        throw new BusinessException("\u903b\u8f91\u5f02\u5e38");
    }

    @Override
    public List<ActivitiBusinessEntity> getListByBusinessIdOrNum(String businessIdOrNum, List<String> bpmStatus) {
        List activitiBusinessEntities = this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ActivitiBusinessEntity.class).eq(ActivitiBusinessEntity::getBusinessId, (Object)businessIdOrNum)).in(CollectionUtils.isNotEmpty(bpmStatus), ActivitiBusinessEntity::getBpmStatus, bpmStatus));
        return activitiBusinessEntities;
    }

    @Override
    public PageResult<ProcessInstanceQueryRespVo> processInstancePage(ProcessInstanceQueryReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<ProcessInstanceQueryRespVo> list = this.activitiBusinessMapper.processInstancePage((Page<ProcessInstanceQueryRespVo>)page, reqVo);
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(o -> {
                this.helper.setCurrentPositionAndUserByProcessInstanceId((ProcessInstanceQueryRespVo)o);
                o.setBpmStatusName(ActivitiOperateTypeEnum.getStatusNameByCode((String)o.getBpmStatus()));
                o.setProcessInstanceStatusName(ProcessInstanceStatusEnum.getStatusNameByCode((String)o.getProcessInstanceStatus()));
                String commitElapsedTime = null;
                if (StringUtils.equals((CharSequence)ActivitiOperateTypeEnum.COMMIT.getCode(), (CharSequence)o.getBpmStatus())) {
                    commitElapsedTime = this.helper.computeProcessTotalHandleTime(o.getCreateDateAll(), DateUtil.date2Str((Date)new Date(), (SimpleDateFormat)DateUtil.datetimeFormat));
                } else {
                    commitElapsedTime = this.helper.computeProcessTotalHandleTime(o.getCreateDateAll(), o.getUpdateDateAll());
                    o.setProcessEndDate(o.getUpdateDateAll());
                }
                o.setCommitElapsedTime(commitElapsedTime);
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ActivitiBusinessEntity updateBpmStatus(String processInstanceId, String bpmStatus, String processInstanceStatus) {
        log.info("\u4fee\u6539\u6d41\u7a0b\u72b6\u6001");
        AssertUtils.isNotEmpty((String)bpmStatus, (String)"\u6d41\u7a0b\u72b6\u6001\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)processInstanceId, (String)"\u6d41\u7a0b\u5b9e\u4f8bid\u4e0d\u80fd\u4e3a\u7a7a");
        boolean checkCodeExist = ActivitiOperateTypeEnum.checkCodeExist((String)bpmStatus);
        if (!checkCodeExist) {
            throw new BusinessException("\u6d41\u7a0b\u72b6\u6001\u7f16\u7801\u503c:" + bpmStatus + ",\u4e0d\u5b58\u5728");
        }
        List activitiBusinessEntities = this.list((Wrapper)Wrappers.lambdaQuery(ActivitiBusinessEntity.class).eq(ActivitiBusinessEntity::getProcessInstanceId, (Object)processInstanceId));
        AssertUtils.isNotEmpty((Collection)activitiBusinessEntities, (String)("\u6d41\u7a0b\u5b9e\u4f8b\u5df2\u4e0d\u5b58\u5728[" + processInstanceId + "]"));
        if (activitiBusinessEntities.size() > 1) {
            throw new BusinessException("\u6d41\u7a0b\u5b9e\u4f8b\u91cd\u590d\uff0c\u8bf7\u8054\u7cfb\u7a0b\u5e8f\u7ba1\u7406\u5458[" + processInstanceId + "]");
        }
        ActivitiBusinessEntity entity = (ActivitiBusinessEntity)activitiBusinessEntities.get(0);
        entity.setBpmStatus(bpmStatus);
        entity.setProcessInstanceStatus(processInstanceStatus);
        this.updateById(entity);
        return entity;
    }

    @Override
    public PageResult<ProcessInstanceQueryRespVo> taskDonePage(ProcessInstanceQueryReqVo reqVo) {
        UserRedis user = UserUtils.getUser();
        reqVo.setCreateCode(user.getUsername());
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<ProcessInstanceQueryRespVo> list = this.activitiBusinessMapper.taskDonePage((Page<ProcessInstanceQueryRespVo>)page, reqVo);
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(o -> {
                o.setBpmStatusName(ActivitiOperateTypeEnum.getStatusNameByCode((String)o.getBpmStatus()));
                o.setProcessInstanceStatusName(ProcessInstanceStatusEnum.getStatusNameByCode((String)o.getProcessInstanceStatus()));
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }
}

