/*
 * Activiti Modeler component part of the Activiti project
 * Copyright 2005-2014 Alfresco Software, Ltd. All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * Assignment
 */
var KisBpmAssignmentCtrl = ['$scope', '$modal', function ($scope, $modal) {

  // Config for the modal window
  var opts = {
    template: '/activiti/activitipage/editor-app/configuration/properties/assignment-popup.html?version=' + Date.now(),
    scope: $scope
  };

  // Open the dialog
  $modal(opts);
}];

var KisBpmAssignmentPopupCtrl = ['$scope', '$http', function ($scope, $http) {

  // Put json representing assignment on scope
  if ($scope.property.value !== undefined && $scope.property.value !== null
    && $scope.property.value.assignment !== undefined
    && $scope.property.value.assignment !== null) {
    $scope.assignment = $scope.property.value.assignment;
  } else {
    $scope.assignment = {};
  }

  if ($scope.assignment.candidateUsers == undefined || $scope.assignment.candidateUsers.length == 0) {
    $scope.assignment.candidateUsers = [];
  }

  // Click handler for + button after enum value
  var userValueIndex = 1;
  $scope.addCandidateUserValue = function (index) {
    $scope.assignment.candidateUsers.splice(index + 1, 0, {value: 'value ' + userValueIndex++});
  };

  // Click handler for - button after enum value
  $scope.removeCandidateUserValue = function (index) {
    $scope.assignment.candidateUsers.splice(index, 1);
  };

  if ($scope.assignment.candidateGroups == undefined || $scope.assignment.candidateGroups.length == 0) {
    $scope.assignment.candidateGroups = [];
  }

  var groupValueIndex = 1;
  $scope.addCandidateGroupValue = function (index) {
    $scope.assignment.candidateGroups.splice(index + 1, 0, {value: 'value ' + groupValueIndex++});
  };

  // Click handler for - button after enum value
  $scope.removeCandidateGroupValue = function (index) {
    $scope.assignment.candidateGroups.splice(index, 1);
  };

  $scope.save = function () {

    $scope.property.value = {};
    handleAssignmentInput($scope);
    $scope.property.value.assignment = $scope.assignment;

    $scope.updatePropertyInModel($scope.property);
    $scope.close();
  };

  // Close button handler
  $scope.close = function () {
    handleAssignmentInput($scope);
    $scope.property.mode = 'read';
    $scope.$hide();
  };

  var handleAssignmentInput = function ($scope) {
    if ($scope.assignment.candidateUsers) {
      var emptyUsers = true;
      var toRemoveIndexes = [];
      for (var i = 0; i < $scope.assignment.candidateUsers.length; i++) {
        if ($scope.assignment.candidateUsers[i].value != '') {
          emptyUsers = false;
        } else {
          toRemoveIndexes[toRemoveIndexes.length] = i;
        }
      }

      for (var i = 0; i < toRemoveIndexes.length; i++) {
        $scope.assignment.candidateUsers.splice(toRemoveIndexes[i], 1);
      }

      if (emptyUsers) {
        $scope.assignment.candidateUsers = undefined;
      }
    }

    if ($scope.assignment.candidateGroups) {
      var emptyGroups = true;
      var toRemoveIndexes = [];
      for (var i = 0; i < $scope.assignment.candidateGroups.length; i++) {
        if ($scope.assignment.candidateGroups[i].value != '') {
          emptyGroups = false;
        } else {
          toRemoveIndexes[toRemoveIndexes.length] = i;
        }
      }

      for (var i = 0; i < toRemoveIndexes.length; i++) {
        $scope.assignment.candidateGroups.splice(toRemoveIndexes[i], 1);
      }

      if (emptyGroups) {
        $scope.assignment.candidateGroups = undefined;
      }
    }
  };

  $scope.subModalconfig = {
    visible: false,
    columns: [{
      name: '组织',
      field: 'orgName'
    }, {
      name: '用户姓名',
      field: 'fullName'
    }, {
      name: '职位名称',
      field: 'positionName'
    }, {
      name: '职位编码',
      field: 'positionCode'
    }],
    list: [],
    type: 'positionCode',
    params: {
      currentPage: 1,// 当前页
      totalPages: 0,// 总页数
      pageList: [], // 当前页
      enableStatus: '009'
    },
    select_all: false,
    goPageNum: '',
    checkType: '',
  };

  $scope.searchForm = {
    orgName: '',
    fullName: '',
    positionName: ''
  }

  $scope.openModal = function (type, checkType) {
    $scope.subModalconfig.checkType = checkType
    if (type === 'positionCode') {
      $scope.subModalconfig.columns = [{
        name: '组织',
        field: 'orgName'
      }, {
        name: '用户姓名',
        field: 'fullName'
      }, {
        name: '职位名称',
        field: 'positionName'
      }, {
        name: '职位编码',
        field: 'positionCode'
      }]
    } else {
      $scope.subModalconfig.columns = [{
        name: '角色名称',
        field: 'bpmRoleName'
      }, {
        name: '角色编码',
        field: 'bpmRoleCode'
      }]
    }
    $scope.subModalconfig.list = []
    $scope.subModalconfig.type = type
    $scope.subModalconfig.select_all = false
    $scope.subModalconfig.goPageNum = ''
    $scope.subModalconfig.params = {
      currentPage: 1,// 当前页
      totalPages: 0,// 总页数
      pageList: [], // 当前页
    }
    $scope.searchForm = {
      orgName: '',
      fullName: '',
      positionName: '',
      enableStatus: '009'
    }

    // 初始化，选中第一页
    $scope.selectPage(1);
    $scope.subModalconfig.visible = true
  }
  $scope.closeModal = function () {
    $scope.subModalconfig.visible = false;
    $scope.selectList = [];
  }

  $scope.selectList = [];

  $scope.resetData = (list1, list2, state) => {
    let list = [];

    if (list1.length > 0) {
      list1.forEach(v1 => {
        let notRepeat = true;
        const rowData = v1;

        list2.forEach(v2 => {
          if (rowData[$scope.subModalconfig.type] === v2[$scope.subModalconfig.type]) {
            notRepeat = false;
          }
        })
        if (notRepeat) {
          list.push(rowData);
        }
      })
    }

    if (state) {
      list = list.concat(list2)
    }

    return list;
  }

  $scope.selectItem = (type, item) => {
    if (type === 'all') {
      $scope.selectList = $scope.resetData($scope.selectList, $scope.subModalconfig.list, item)

      for (let v1 in $scope.subModalconfig.list) {
        $scope.subModalconfig.list[v1].checked = item
      }
    } else {
      $scope.subModalconfig.select_all = $scope.subModalconfig.list.every(v => v.checked)
      $scope.selectList = $scope.resetData($scope.selectList, [item], item.checked)
    }
  }
  $scope.selectRadioItem = (item) => {
    $scope.selectList = [item]
  }

  $scope.selectFn = () => {
    if ($scope.selectList.length === 0) {
      return false
    }
    if ($scope.subModalconfig.type === 'positionCode') {
      if ($scope.subModalconfig.checkType === 'check') {
        $scope.assignment.candidateUsers = $scope.selectList.map(v => {
          v.value = v.positionCode

          return v
        })
      } else {
        $scope.assignment.assignee = $scope.selectList[0].positionCode
      }
    } else {
      $scope.assignment.candidateGroups = $scope.selectList.map(v => {
        v.value = v.bpmRoleCode

        return v
      })
    }
    $scope.closeModal()
  }

  $scope.tabDelFn = (type, item) => {
    let newList = []
    if (type === 'user') {
      $scope.assignment.candidateUsers.forEach(v1 => {
        if (v1.positionCode !== item.positionCode) {
          newList.push(v1)
        }
      })

      $scope.assignment.candidateUsers = newList;
    } else {
      $scope.assignment.candidateGroups.forEach(v1 => {
        if (v1.bpmRoleCode !== item.bpmRoleCode) {
          newList.push(v1)
        }
      })

      $scope.assignment.candidateGroups = newList;
    }

  }

  //加载上一页
  $scope.prev = function () {
    $scope.selectPage($scope.subModalconfig.params.currentPage - 1);
  }
  //加载下一页
  $scope.next = function () {
    $scope.selectPage($scope.subModalconfig.params.currentPage + 1);
  }
  //判断是否是当前页
  $scope.isActivePage = function (page) {
    let t = $scope.subModalconfig.params.totalPages;
    let c = $scope.subModalconfig.params.currentPage;
    let p = page;

    let num = (c < 2 || c > (t - 2)) ? 5 : 2;

    let className = {
      'active': p === c,
      'is-hidden': t > 7 && (p < (c - num) || p > (c + num))
    }

    return className
  }


  $scope.goPageNum = ''
  $scope.goPageInput = () => {
    let state = /(^[1-9]\d*$)/.test($scope.subModalconfig.goPageNum)
    $scope.subModalconfig.goPageNum = state ? $scope.subModalconfig.goPageNum : ''
  }
  $scope.goPage = () => {
    $scope.selectPage(Number($scope.subModalconfig.goPageNum))
    $scope.subModalconfig.goPageNum = ''
  }

  // 搜索
  $scope.searchFn = () => {
    $scope.selectPage(1)
  }

  //加载指定页
  $scope.selectPage = function (page) {
    let url = '/mdm/mdmPositionController/pageList'

    if ($scope.subModalconfig.type === 'bpmRoleCode') {
      url = '/mdm/mdmBpmRoleController/pageList'
    }

    // page 超出范围
    if ($scope.subModalconfig.params.totalPages !== 0 && (page < 1 || page > $scope.subModalconfig.params.totalPages)) {
      return;
    }

    //发送请求
    $http({
      method: 'post',
      url: url,
      data: {
        pageNum: page, // 页码
        pageSize: 15, // 每页记录数
        ...$scope.searchForm
      },
      // headers: {
      //   loginUserToken: '12f65514a3d6422da44d8158f5decfa4'
      // }
    }).success(function (data) {
      if (data.code === 200) {
        // 显示表格数据
        $scope.subModalconfig.list = data.result.data.map(v => {
          v.checked = false;

          return v
        })

        let pageList = []
        for (let i = 1; i <= Math.ceil(data.result.count / 15); i++) {
          pageList.push(i);
        }

        $scope.subModalconfig.params = {
          currentPage: page,// 更新当前显示页码
          totalPages: Math.ceil(data.result.count / 15),// 总页数
          pageList: pageList// 当前页count
        }
      }
    }).error(function (data, status, headers, config) {
      // 当响应以错误状态返回时调用
      alert("出错，请联系管理员 ");
    });
  }
}];