/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.activiti.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activiti.entity.ActivitiBusinessEntity;
import com.biz.crm.activiti.mapper.ActivitiBusinessMapper;
import com.biz.crm.activiti.service.ActivitiBusinessService;
import com.biz.crm.base.BusinessException;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ActivitiBusinessServiceImpl
extends ServiceImpl<ActivitiBusinessMapper, ActivitiBusinessEntity>
implements ActivitiBusinessService {
    @Override
    public ActivitiBusinessEntity save(String processInstanceId, String bpmStatus, String businessIdOrNum) {
        ActivitiBusinessEntity activitiBusinessEntity = new ActivitiBusinessEntity();
        activitiBusinessEntity.setCrmProcessInstanceId(CodeUtil.getCodeDefault());
        activitiBusinessEntity.setProcessInstanceId(processInstanceId);
        activitiBusinessEntity.setBpmStatus(bpmStatus);
        activitiBusinessEntity.setBusinessIdOrNum(businessIdOrNum);
        this.save(activitiBusinessEntity);
        return activitiBusinessEntity;
    }

    @Override
    public String getByProcessInstanceId(String crmProcessInstanceId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"crm_process_instance_id", (Object)crmProcessInstanceId);
        List activitiBusinessEntities = this.list((Wrapper)queryWrapper);
        if (CollectionUtil.listEmpty((List)activitiBusinessEntities)) {
            throw new BusinessException("\u6d41\u7a0b\u7f16\u53f7\u5df2\u4e0d\u5b58\u5728[" + crmProcessInstanceId + "]");
        }
        return ((ActivitiBusinessEntity)activitiBusinessEntities.get(0)).getProcessInstanceId();
    }

    @Override
    public List<ActivitiBusinessEntity> getListByBusinessIdOrNum(String businessIdOrNum, List<String> bpmStatus) {
        List activitiBusinessEntities;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"business_id_or_num", (Object)businessIdOrNum);
        if (CollectionUtil.listNotEmptyNotSizeZero(bpmStatus)) {
            queryWrapper.in((Object)"bpm_status", bpmStatus);
        }
        activitiBusinessEntities = (activitiBusinessEntities = this.list((Wrapper)queryWrapper)) == null ? new ArrayList() : activitiBusinessEntities;
        return activitiBusinessEntities;
    }
}

