/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.activiti.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activiti.entity.ActReModelEntity;
import com.biz.crm.activiti.entity.TaProcessBizRelationEntity;
import com.biz.crm.activiti.mapper.ActReModelMapper;
import com.biz.crm.activiti.mapper.TaProcessBizRelationMapper;
import com.biz.crm.activiti.service.TaProcessBizRelationService;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.activiti.Indicator;
import com.biz.crm.eunm.activiti.act.TaProcessBizRelationEnum;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.vo.RelationVo;
import com.biz.crm.vo.SubmitActivitiKeyDetail;
import com.biz.crm.vo.SubmitActivitiResp;
import com.biz.crm.vo.TaProcessBizRelationReqVo;
import com.biz.crm.vo.TaProcessBizRelationRespVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TaProcessBizRelationExpandServiceImpl"})
public class TaProcessBizRelationServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TaProcessBizRelationMapper, TaProcessBizRelationEntity>
implements TaProcessBizRelationService {
    private static final Logger log = LoggerFactory.getLogger(TaProcessBizRelationServiceImpl.class);
    @Resource
    private TaProcessBizRelationMapper mapper;
    @Resource
    private ActReModelMapper actReModelMapper;

    @Override
    public TaProcessBizRelationRespVo getRelationByProcessKey(String processKey) {
        AssertUtils.isNotEmpty((String)processKey, (String)"\u6d41\u7a0bKey\u4e0d\u80fd\u4e3a\u7a7a");
        List entityList = this.list((Wrapper)Wrappers.lambdaQuery(TaProcessBizRelationEntity.class).eq(TaProcessBizRelationEntity::getProcessKey, (Object)processKey));
        List menuList = entityList.stream().filter(data -> TaProcessBizRelationEnum.BizRelationEnum.MENU.getVal().equals(data.getRelationType())).collect(Collectors.toList());
        List menuVoList = CrmBeanUtil.copyList(menuList, RelationVo.class);
        List orgList = entityList.stream().filter(data -> TaProcessBizRelationEnum.BizRelationEnum.ORG.getVal().equals(data.getRelationType())).collect(Collectors.toList());
        List orgVoList = CrmBeanUtil.copyList(orgList, RelationVo.class);
        TaProcessBizRelationRespVo respVo = new TaProcessBizRelationRespVo();
        respVo.setProcessKey(((TaProcessBizRelationEntity)entityList.get(0)).getProcessKey());
        respVo.setMenuList(menuVoList);
        respVo.setOrgList(orgVoList);
        return respVo;
    }

    @Override
    public List<TaProcessBizRelationRespVo> getListRelation(TaProcessBizRelationReqVo taProcessBizRelationReqVo) {
        List entities = this.list((Wrapper)Wrappers.lambdaQuery(TaProcessBizRelationEntity.class).eq(TaProcessBizRelationEntity::getProcessKey, (Object)taProcessBizRelationReqVo.getProcessKey()));
        if (CollectionUtils.isEmpty((Collection)entities)) {
            return Collections.emptyList();
        }
        ArrayList<TaProcessBizRelationRespVo> result = new ArrayList<TaProcessBizRelationRespVo>();
        Map<String, List<TaProcessBizRelationEntity>> listGroupByProcessKey = entities.stream().collect(Collectors.groupingBy(TaProcessBizRelationEntity::getProcessKey));
        Set<String> keySet = listGroupByProcessKey.keySet();
        keySet.stream().forEach(data -> {
            TaProcessBizRelationRespVo respVo = new TaProcessBizRelationRespVo();
            respVo.setProcessKey((String)data);
            List menuEntityList = ((List)listGroupByProcessKey.get(data)).stream().filter(entity -> TaProcessBizRelationEnum.BizRelationEnum.MENU.getVal().equals(entity.getRelationType())).collect(Collectors.toList());
            List menuList = CrmBeanUtil.copyList(menuEntityList, RelationVo.class);
            List orgEntityList = ((List)listGroupByProcessKey.get(data)).stream().filter(entity -> TaProcessBizRelationEnum.BizRelationEnum.ORG.getVal().equals(entity.getRelationType())).collect(Collectors.toList());
            List orgList = CrmBeanUtil.copyList(orgEntityList, RelationVo.class);
            respVo.setMenuList(menuList);
            respVo.setOrgList(orgList);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)orgList) && StringUtils.isNotEmpty((String)((RelationVo)orgList.get(0)).getIsOnlyCurrentOrg())) {
                respVo.setIsOnlyCurrentOrg(((RelationVo)orgList.get(0)).getIsOnlyCurrentOrg());
            } else {
                respVo.setIsOnlyCurrentOrg(GlobalWhetherEnum.YES.getCode());
            }
            result.add(respVo);
        });
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteRelation(String processKey) {
        AssertUtils.isNotEmpty((String)processKey, (String)"\u6d41\u7a0b\u7f16\u7801[processKey]\u4e0d\u80fd\u4e3a\u7a7a");
        this.mapper.delete((Wrapper)Wrappers.lambdaQuery(TaProcessBizRelationEntity.class).eq(TaProcessBizRelationEntity::getProcessKey, (Object)processKey));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void insertRelation(TaProcessBizRelationReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getProcessKey(), (String)"\u6d41\u7a0b\u7f16\u7801[processKey]\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty(reqVo.getMenuList(), (String)"\u8bf7\u9009\u62e9\u53ef\u9009\u9875\u9762[menuList]");
        AssertUtils.isNotEmpty(reqVo.getOrgList(), (String)"\u8bf7\u9009\u62e9\u53ef\u9009\u7ec4\u7ec7[orgList]");
        AssertUtils.isTrue((reqVo.getMenuList().size() == reqVo.getMenuList().stream().map(RelationVo::getBizCode).collect(Collectors.toSet()).size() ? 1 : 0) != 0, (String)"\u8bf7\u52ff\u9009\u62e9\u91cd\u590d\u7684\u53ef\u9009\u9875\u9762\u83dc\u5355\u7f16\u7801");
        AssertUtils.isTrue((reqVo.getOrgList().size() == reqVo.getOrgList().stream().map(RelationVo::getBizCode).collect(Collectors.toSet()).size() ? 1 : 0) != 0, (String)"\u8bf7\u52ff\u9009\u62e9\u91cd\u590d\u7684\u53ef\u9009\u7ec4\u7ec7\u7f16\u7801");
        this.remove((Wrapper)Wrappers.lambdaQuery(TaProcessBizRelationEntity.class).eq(TaProcessBizRelationEntity::getProcessKey, (Object)reqVo.getProcessKey()));
        List<TaProcessBizRelationEntity> entityList = this.getEntityList(reqVo);
        this.saveOrUpdateBatch(entityList);
    }

    private List<TaProcessBizRelationEntity> getEntityList(TaProcessBizRelationReqVo reqVo) {
        ArrayList saveList = Lists.newArrayList();
        ArrayList needRemoveIds = Lists.newArrayList();
        HashSet set = Sets.newHashSet();
        List entities = this.mapper.selectList((Wrapper)Wrappers.lambdaQuery(TaProcessBizRelationEntity.class).eq(TaProcessBizRelationEntity::getProcessKey, (Object)reqVo.getProcessKey()));
        HashMap map = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            entities.stream().forEach(o -> map.put(o.getBizCode() + o.getRelationType(), o));
        }
        reqVo.getMenuList().forEach(o -> {
            AssertUtils.isNotEmpty((String)o.getBizCode(), (String)"\u53ef\u9009\u9875\u9762\u7684\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            set.add(o.getBizCode() + TaProcessBizRelationEnum.BizRelationEnum.MENU.getVal());
            TaProcessBizRelationEntity entity = (TaProcessBizRelationEntity)map.get(o.getBizCode() + TaProcessBizRelationEnum.BizRelationEnum.MENU.getVal());
            if (Objects.isNull(entity)) {
                entity = new TaProcessBizRelationEntity();
                entity.setProcessKey(reqVo.getProcessKey());
                entity.setRelationType(TaProcessBizRelationEnum.BizRelationEnum.MENU.getVal());
                entity.setIsOnlyCurrentOrg(reqVo.getIsOnlyCurrentOrg());
                entity.setBizCode(o.getBizCode());
                entity.setBizName(o.getBizName());
            } else {
                entity.setIsOnlyCurrentOrg(reqVo.getIsOnlyCurrentOrg());
                entity.setBizName(o.getBizName());
            }
            saveList.add(entity);
        });
        reqVo.getOrgList().forEach(o -> {
            AssertUtils.isNotEmpty((String)o.getBizCode(), (String)"\u53ef\u9009\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            set.add(o.getBizCode() + TaProcessBizRelationEnum.BizRelationEnum.ORG.getVal());
            TaProcessBizRelationEntity entity = (TaProcessBizRelationEntity)map.get(o.getBizCode() + TaProcessBizRelationEnum.BizRelationEnum.ORG.getVal());
            if (Objects.isNull(entity)) {
                entity = new TaProcessBizRelationEntity();
                entity.setProcessKey(reqVo.getProcessKey());
                entity.setRelationType(TaProcessBizRelationEnum.BizRelationEnum.ORG.getVal());
                entity.setIsOnlyCurrentOrg(reqVo.getIsOnlyCurrentOrg());
                entity.setBizCode(o.getBizCode());
                entity.setBizName(o.getBizName());
            } else {
                entity.setIsOnlyCurrentOrg(reqVo.getIsOnlyCurrentOrg());
                entity.setBizName(o.getBizName());
            }
            saveList.add(entity);
        });
        entities.forEach(o -> {
            if (!set.contains(o.getBizCode() + o.getRelationType())) {
                needRemoveIds.add(o.getId());
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)needRemoveIds)) {
            this.mapper.deleteBatchIds(needRemoveIds);
        }
        return saveList;
    }

    @Override
    public SubmitActivitiResp findProcessByCurrentUserAndMenu() {
        SubmitActivitiResp submitActivitiResp = new SubmitActivitiResp();
        UserRedis userRedis = UserUtils.getUser();
        submitActivitiResp.setApplierName(userRedis.getUsername());
        submitActivitiResp.setOrgName(userRedis.getOrgname());
        ArrayList<SubmitActivitiKeyDetail> details = new ArrayList<SubmitActivitiKeyDetail>();
        Object obj = ThreadLocalUtil.getObj((String)"menuCode");
        AssertUtils.isNotNull((Object)obj, (String)"\u672a\u83b7\u53d6\u5230\u83dc\u5355\u7f16\u7801");
        String menuCode = String.valueOf(obj);
        AssertUtils.isNotEmpty((String)userRedis.getOrgcode(), (String)"\u767b\u5f55\u4eba\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
        List menuRelationEntities = this.mapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TaProcessBizRelationEntity.class).eq(TaProcessBizRelationEntity::getBizCode, (Object)menuCode)).eq(TaProcessBizRelationEntity::getRelationType, (Object)TaProcessBizRelationEnum.BizRelationEnum.MENU.getVal()));
        if (CollectionUtils.isEmpty((Collection)menuRelationEntities)) {
            return submitActivitiResp;
        }
        Set processKeys = menuRelationEntities.stream().map(TaProcessBizRelationEntity::getProcessKey).collect(Collectors.toSet());
        List orgRelationEntities = this.mapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TaProcessBizRelationEntity.class).in(TaProcessBizRelationEntity::getProcessKey, processKeys)).eq(TaProcessBizRelationEntity::getRelationType, (Object)TaProcessBizRelationEnum.BizRelationEnum.ORG.getVal()));
        HashSet orgCodeSet = Sets.newHashSet();
        orgCodeSet.add(userRedis.getOrgcode());
        orgRelationEntities.stream().forEach(o -> orgCodeSet.add(o.getBizCode()));
        List orgList = OrgUtil.getOrgByCodeList((List)Lists.newArrayList((Iterable)orgCodeSet));
        Map orgMap = orgList.stream().collect(Collectors.toMap(MdmOrgRespVo::getOrgCode, Function.identity()));
        HashSet canUseProcessKeySet = Sets.newHashSet();
        MdmOrgRespVo loginUserOrg = (MdmOrgRespVo)orgMap.get(userRedis.getOrgcode());
        orgRelationEntities.forEach(o -> {
            String ruleCode = loginUserOrg.getRuleCode();
            MdmOrgRespVo orgRespVo = (MdmOrgRespVo)orgMap.get(o.getBizCode());
            if (org.apache.commons.lang3.StringUtils.equals((CharSequence)GlobalWhetherEnum.YES.getCode(), (CharSequence)o.getIsOnlyCurrentOrg())) {
                if (org.apache.commons.lang3.StringUtils.equals((CharSequence)loginUserOrg.getOrgCode(), (CharSequence)o.getBizCode())) {
                    canUseProcessKeySet.add(o.getProcessKey());
                }
            } else if (org.apache.commons.lang3.StringUtils.contains((CharSequence)o.getBizCode(), (CharSequence)loginUserOrg.getOrgCode())) {
                canUseProcessKeySet.add(o.getProcessKey());
            }
        });
        if (CollectionUtils.isEmpty((Collection)canUseProcessKeySet)) {
            return submitActivitiResp;
        }
        List processList = this.actReModelMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ActReModelEntity.class).in(ActReModelEntity::getKey, (Collection)canUseProcessKeySet)).eq(ActReModelEntity::getProcessStatus, (Object)Indicator.PROCESS_STATE_DEPLOY.getCode()));
        List detailList = processList.stream().map(o -> {
            SubmitActivitiKeyDetail submitActivitiKeyDetail = new SubmitActivitiKeyDetail();
            submitActivitiKeyDetail.setProcessKey(o.getKey());
            submitActivitiKeyDetail.setProcessName(o.getName());
            return submitActivitiKeyDetail;
        }).collect(Collectors.toList());
        submitActivitiResp.setDetails(details);
        return submitActivitiResp;
    }
}

