/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.activiti.service;

import com.biz.crm.activiti.entity.ActivitiBusinessEntity;
import com.biz.crm.activiti.service.ActivitiBusinessService;
import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.activiti.ActivitiOperateTypeEnum;
import com.biz.crm.nebular.activiti.vo.CurrentVo;
import com.biz.crm.util.CollectionUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivityTaskUtil {
    private static final Logger log = LoggerFactory.getLogger(ActivityTaskUtil.class);
    @Autowired
    private ActivitiBusinessService activitiBusinessService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private RepositoryService repositoryService;

    public ProcessInstance getProcessInstance(String processInstanceId, String crmProcessInstanceId) {
        if (StringUtils.isEmpty((CharSequence)processInstanceId) && StringUtils.isEmpty((CharSequence)crmProcessInstanceId)) {
            throw new BusinessException("\u68c0\u67e5\u6d41\u7a0b\u7ed3\u675f\u72b6\u6001\u53c2\u6570\u9519\u8bef[\u53c2\u6570\u4e0d\u80fd\u5168\u4e3a\u7a7a]");
        }
        if (StringUtils.isEmpty((CharSequence)processInstanceId)) {
            processInstanceId = this.activitiBusinessService.getByProcessInstanceId(crmProcessInstanceId);
        }
        ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        return pi;
    }

    public boolean checkEnd(String processInstanceId, String crmProcessInstanceId) {
        ProcessInstance pi;
        if (StringUtils.isEmpty((CharSequence)processInstanceId) && StringUtils.isEmpty((CharSequence)crmProcessInstanceId)) {
            throw new BusinessException("\u68c0\u67e5\u6d41\u7a0b\u7ed3\u675f\u72b6\u6001\u53c2\u6570\u9519\u8bef[\u53c2\u6570\u4e0d\u80fd\u5168\u4e3a\u7a7a]");
        }
        if (StringUtils.isEmpty((CharSequence)processInstanceId)) {
            processInstanceId = this.activitiBusinessService.getByProcessInstanceId(crmProcessInstanceId);
        }
        return (pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult()) == null;
    }

    public CurrentVo getCurrentVo(String processInstanceId, String crmProcessInstanceId) {
        if (StringUtils.isEmpty((CharSequence)processInstanceId) && StringUtils.isEmpty((CharSequence)crmProcessInstanceId)) {
            throw new BusinessException("\u68c0\u67e5\u6d41\u7a0b\u7ed3\u675f\u72b6\u6001\u53c2\u6570\u9519\u8bef[\u53c2\u6570\u4e0d\u80fd\u5168\u4e3a\u7a7a]");
        }
        if (StringUtils.isEmpty((CharSequence)processInstanceId)) {
            processInstanceId = this.activitiBusinessService.getByProcessInstanceId(crmProcessInstanceId);
        }
        CurrentVo currentVo = null;
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).list();
        for (Task task : tasks) {
            List identityLinks = this.taskService.getIdentityLinksForTask(task.getId());
            if (!CollectionUtil.listNotEmptyNotSizeZero((List)identityLinks)) continue;
            HashSet<String> positionCode = new HashSet<String>();
            HashSet<String> bpmRoleCode = new HashSet<String>();
            for (IdentityLink identityLink : identityLinks) {
                if (StringUtils.isNotBlank((CharSequence)identityLink.getUserId())) {
                    positionCode.add(identityLink.getUserId());
                }
                if (!StringUtils.isNotBlank((CharSequence)identityLink.getGroupId())) continue;
                bpmRoleCode.add(identityLink.getGroupId());
            }
            if (positionCode.isEmpty() && bpmRoleCode.isEmpty()) continue;
            currentVo = new CurrentVo();
            currentVo.setBpmRoleCode(bpmRoleCode);
            currentVo.setPositionCode(positionCode);
        }
        return currentVo;
    }

    public void checkRepeatCommit(String businessIdOrNum) {
        ArrayList<String> bpmStatus = new ArrayList<String>();
        bpmStatus.add(ActivitiOperateTypeEnum.COMMIT.getCode());
        List<ActivitiBusinessEntity> entities = this.activitiBusinessService.getListByBusinessIdOrNum(businessIdOrNum, bpmStatus);
        if (CollectionUtil.listNotEmptyNotSizeZero(entities)) {
            throw new BusinessException("\u8be5\u6570\u636e\u5728\u6d41\u7a0b[" + entities.get(0).getCrmProcessInstanceId() + "]\u5ba1\u6279\u4e2d,\u8bf7\u4e0d\u8981\u91cd\u590d\u63d0\u4ea4==>[" + businessIdOrNum + "]");
        }
    }

    public List<String> getHighLightedFlows(ProcessDefinitionEntity processDefinitionEntity, List<HistoricActivityInstance> historicActivityInstances) {
        ArrayList<String> highFlows = new ArrayList<String>();
        for (int i = 0; i < historicActivityInstances.size() - 1; ++i) {
            ActivityImpl activityImpl = processDefinitionEntity.findActivity(historicActivityInstances.get(i).getActivityId());
            ArrayList<ActivityImpl> sameStartTimeNodes = new ArrayList<ActivityImpl>();
            ActivityImpl sameActivityImpl1 = processDefinitionEntity.findActivity(historicActivityInstances.get(i + 1).getActivityId());
            sameStartTimeNodes.add(sameActivityImpl1);
            for (int j = i + 1; j < historicActivityInstances.size() - 1; ++j) {
                HistoricActivityInstance activityImpl1 = historicActivityInstances.get(j);
                HistoricActivityInstance activityImpl2 = historicActivityInstances.get(j + 1);
                if (!activityImpl1.getStartTime().equals(activityImpl2.getStartTime())) break;
                ActivityImpl sameActivityImpl2 = processDefinitionEntity.findActivity(activityImpl2.getActivityId());
                sameStartTimeNodes.add(sameActivityImpl2);
            }
            List pvmTransitions = activityImpl.getOutgoingTransitions();
            for (PvmTransition pvmTransition : pvmTransitions) {
                ActivityImpl pvmActivityImpl = (ActivityImpl)pvmTransition.getDestination();
                if (!sameStartTimeNodes.contains(pvmActivityImpl)) continue;
                highFlows.add(pvmTransition.getId());
            }
        }
        return highFlows;
    }

    public ProcessDefinitionEntity findProcessDefinitionEntityByTaskId(String taskId) {
        TaskEntity task = (TaskEntity)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(task.getProcessDefinitionId());
        if (processDefinition == null) {
            throw new BusinessException("\u6d41\u7a0b\u5b9a\u4e49\u672a\u627e\u5230!");
        }
        return processDefinition;
    }

    public List<PvmTransition> clearTransition(ActivityImpl activityImpl) {
        ArrayList<PvmTransition> oriPvmTransitionList = new ArrayList<PvmTransition>();
        List pvmTransitionList = activityImpl.getOutgoingTransitions();
        for (PvmTransition pvmTransition : pvmTransitionList) {
            oriPvmTransitionList.add(pvmTransition);
        }
        pvmTransitionList.clear();
        return oriPvmTransitionList;
    }

    public void restoreTransition(ActivityImpl activityImpl, List<PvmTransition> oriPvmTransitionList) {
        List pvmTransitionList = activityImpl.getOutgoingTransitions();
        pvmTransitionList.clear();
        for (PvmTransition pvmTransition : oriPvmTransitionList) {
            pvmTransitionList.add(pvmTransition);
        }
    }

    public void setbpmOperation(Map<String, Object> variable, String approveOpt) {
        variable.put("approveOpt", approveOpt);
    }
}

