/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.bpmlog.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activiti.entity.ActivitiBusinessEntity;
import com.biz.crm.activiti.entity.TaNodeConfigEntity;
import com.biz.crm.activiti.mapper.ActivitiBusinessMapper;
import com.biz.crm.activiti.service.impl.ActivitiBusinessHelper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.bpmlog.entity.ActivitiBpmlogEntity;
import com.biz.crm.bpmlog.mapper.ActivitiBpmlogMapper;
import com.biz.crm.bpmlog.service.ActivitiBpmlogService;
import com.biz.crm.bpmlog.vo.ActivitiBpmlogVo;
import com.biz.crm.eunm.activiti.ActivitiOperateTypeEnum;
import com.biz.crm.mdm.bpmrole.MdmBpmRoleFeign;
import com.biz.crm.nebular.activiti.act.resp.TaActFileRespVo;
import com.biz.crm.nebular.activiti.start.req.OptRecordReqVO;
import com.biz.crm.nebular.activiti.task.resp.OptLogsRspVO;
import com.biz.crm.nebular.activiti.task.resp.OptRecordRspVO;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.DateUtil;
import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"ActivitiBpmlogExpandServiceImpl"})
public class ActivitiBpmlogServiceImpl
extends ServiceImpl<ActivitiBpmlogMapper, ActivitiBpmlogEntity>
implements ActivitiBpmlogService {
    @Autowired
    private TaskService taskService;
    @Resource
    private ActivitiBpmlogMapper logMapper;
    @Resource
    private MdmBpmRoleFeign mdmBpmRoleFeign;
    @Resource
    private ActivitiBusinessMapper activitiBusinessMapper;
    @Autowired
    private ActivitiBusinessHelper helper;

    @Override
    @Transactional
    public void commomSaveLog(ActivitiBpmlogVo activitiBpmlogVo) {
        ActivitiBpmlogEntity entity = new ActivitiBpmlogEntity();
        CrmBeanUtil.copyProperties((Object)((Object)activitiBpmlogVo), (Object)entity);
        entity.setCreateDateAll(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
        entity.setLogCode(CodeUtil.getCodeDefault());
        this.save(entity);
    }

    @Override
    @Transactional
    public void commomSaveLog(String crmProcessInstanceId, String processInstanceId, String businessId, String businessNo, String remarks, String operateType) {
        ActivitiBpmlogVo activitiBpmlogVo = new ActivitiBpmlogVo(crmProcessInstanceId, processInstanceId, businessId, businessNo, operateType);
        activitiBpmlogVo.setRemarks(remarks);
        this.commomSaveLog(activitiBpmlogVo);
    }

    @Override
    public List<OptLogsRspVO> getOptLogs(OptRecordReqVO reqVO) {
        List activitiBusinessEntities;
        if (StringUtils.isEmpty((CharSequence)reqVO.getProcessNo()) && StringUtils.isEmpty((CharSequence)reqVO.getProcessInstanceId()) && StringUtils.isEmpty((CharSequence)reqVO.getFormNo())) {
            throw new BusinessException("\u67e5\u8be2\u6d41\u7a0b\u65e5\u5fd7\u65f6,\u6d41\u7a0b\u7f16\u7801[processNo]\u548c\u6d41\u7a0b\u5b9e\u4f8bid[processInstanceId]\u548c\u4e1a\u52a1\u5355\u636eid[formNo]\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        ArrayList respVos = Lists.newArrayList();
        if (StringUtils.isNotEmpty((CharSequence)reqVO.getProcessNo())) {
            ActivitiBusinessEntity entity = (ActivitiBusinessEntity)this.activitiBusinessMapper.selectOne((Wrapper)Wrappers.lambdaQuery(ActivitiBusinessEntity.class).eq(ActivitiBusinessEntity::getCrmProcessInstanceId, (Object)reqVO.getProcessNo()));
            reqVO.setFormNo(entity.getBusinessId());
        }
        if (CollectionUtils.isEmpty((Collection)(activitiBusinessEntities = this.activitiBusinessMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ActivitiBusinessEntity.class).eq(StringUtils.isNotEmpty((CharSequence)reqVO.getProcessInstanceId()), ActivitiBusinessEntity::getProcessInstanceId, (Object)reqVO.getProcessInstanceId())).eq(StringUtils.isNotEmpty((CharSequence)reqVO.getFormNo()), ActivitiBusinessEntity::getBusinessId, (Object)reqVO.getFormNo())).orderByDesc(CrmBaseEntity::getCreateDateAll))))) {
            return Lists.newArrayList();
        }
        Map businessEntityMap = activitiBusinessEntities.stream().collect(Collectors.toMap(ActivitiBusinessEntity::getCrmProcessInstanceId, Function.identity()));
        List logEntities = this.logMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ActivitiBpmlogEntity.class).eq(StringUtils.isNotEmpty((CharSequence)reqVO.getProcessInstanceId()), ActivitiBpmlogEntity::getProcessInstanceId, (Object)reqVO.getProcessInstanceId())).eq(StringUtils.isNotEmpty((CharSequence)reqVO.getFormNo()), ActivitiBpmlogEntity::getBusinessId, (Object)reqVO.getFormNo())).orderByDesc(CrmBaseEntity::getCreateDateAll));
        List taskList = ((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(((ActivitiBusinessEntity)activitiBusinessEntities.get(0)).getProcessInstanceId())).orderByTaskCreateTime()).desc()).list();
        if (CollectionUtils.isNotEmpty((Collection)taskList)) {
            ActivitiBusinessEntity activitiBusinessEntity = (ActivitiBusinessEntity)activitiBusinessEntities.get(0);
            OptLogsRspVO optLogsRspVO = new OptLogsRspVO();
            ArrayList collect = Lists.newArrayList();
            List<TaNodeConfigEntity> nodes = this.helper.findFutureNodesByProcessVersionKey(activitiBusinessEntity.getProcessVersionKey(), taskList);
            if (CollectionUtils.isNotEmpty(nodes)) {
                nodes.stream().forEach(o -> {
                    OptRecordRspVO rspVO = new OptRecordRspVO();
                    rspVO.setTaskDefKey(o.getProcessNodeCode());
                    rspVO.setCreateTime(new Date());
                    rspVO.setTaskName(o.getProcessNodeName());
                    rspVO.setProcessKey(activitiBusinessEntity.getProcessKey());
                    rspVO.setProcessName(activitiBusinessEntity.getProcessName());
                    rspVO.setContent("\u5f85\u5904\u7406\u8282\u70b9");
                    rspVO.setTitle(activitiBusinessEntity.getProcessTitle());
                    rspVO.setApplierName(activitiBusinessEntity.getCommitName());
                    rspVO.setFormNo(activitiBusinessEntity.getBusinessId());
                    rspVO.setId(o.getId());
                    rspVO.setOperation("BTN_999");
                    rspVO.setOperationStr("\u5f85\u5904\u7406");
                    collect.add(rspVO);
                });
            }
            taskList.stream().forEach(o -> {
                OptRecordRspVO rspVO = new OptRecordRspVO();
                this.helper.setCurrentTaskPosition(rspVO, (Task)o);
                rspVO.setCreateTime(new Date());
                rspVO.setTaskDefKey(o.getTaskDefinitionKey());
                rspVO.setTaskName(o.getName());
                rspVO.setTaskId(o.getId());
                rspVO.setProcessVersionKey(o.getProcessDefinitionId());
                rspVO.setProcessKey(activitiBusinessEntity.getProcessKey());
                rspVO.setProcessName(activitiBusinessEntity.getProcessName());
                rspVO.setContent("\u5f53\u524d\u5f85\u529e\u8282\u70b9");
                rspVO.setTitle(activitiBusinessEntity.getProcessTitle());
                rspVO.setApplierName(activitiBusinessEntity.getCommitName());
                rspVO.setFormNo(activitiBusinessEntity.getBusinessId());
                rspVO.setId(o.getId());
                rspVO.setOperation("BTN_999");
                rspVO.setOperationStr("\u5f85\u5904\u7406");
                rspVO.setUserName(rspVO.getCurrentAccounts());
                collect.add(rspVO);
            });
            String date = DateUtil.formatDate((Date)new Date(), (String)"yyyy-MM-dd");
            optLogsRspVO.setLogDate(date);
            optLogsRspVO.setOptRecordRspVOList((List)collect);
            respVos.add(optLogsRspVO);
        }
        List<TaActFileRespVo> actFileRespVos = this.helper.findActFileByProcessInstanceIds(activitiBusinessEntities.stream().map(ActivitiBusinessEntity::getProcessInstanceId).collect(Collectors.toList()), 2);
        Map<String, List<TaActFileRespVo>> fileMap = actFileRespVos.stream().collect(Collectors.groupingBy(o -> o.getProcessInstId() + o.getNodeId()));
        Map<String, List<ActivitiBpmlogEntity>> map = logEntities.stream().collect(Collectors.groupingBy(CrmBaseEntity::getCreateDate));
        if (MapUtils.isNotEmpty(map)) {
            map.forEach((key, value) -> {
                OptLogsRspVO optLogsRspVO = new OptLogsRspVO();
                optLogsRspVO.setLogDate(key);
                List recordRspVOS = value.stream().map(r -> {
                    ActivitiBusinessEntity activitiBusinessEntity = (ActivitiBusinessEntity)businessEntityMap.get(r.getCrmProcessInstanceId());
                    OptRecordRspVO rspVO = new OptRecordRspVO();
                    rspVO.setProcessName(activitiBusinessEntity.getProcessName());
                    rspVO.setCreateTime(DateUtil.str2Date((String)r.getCreateDateAll(), (SimpleDateFormat)DateUtil.datetimeFormat));
                    rspVO.setProcessKey(activitiBusinessEntity.getProcessKey());
                    rspVO.setUserName(r.getCreateName());
                    rspVO.setUserCode(r.getCreateCode());
                    rspVO.setTaskName(r.getNodeName());
                    rspVO.setPositionCode(r.getCreatePosCode());
                    rspVO.setPositionName(r.getCreatePosName());
                    rspVO.setContent(r.getRemarks());
                    rspVO.setTitle(activitiBusinessEntity.getProcessTitle());
                    rspVO.setApplierName(activitiBusinessEntity.getCommitName());
                    rspVO.setFormNo(activitiBusinessEntity.getBusinessId());
                    rspVO.setOperation(r.getOperateType());
                    rspVO.setOperationStr(ActivitiOperateTypeEnum.getStatusNameByCode((String)r.getOperateType()));
                    rspVO.setCurrentAccounts(r.getCreateName() + "(" + r.getCreateCode() + ")");
                    if (StringUtils.equals((CharSequence)ActivitiOperateTypeEnum.COPY.getCode(), (CharSequence)r.getOperateType())) {
                        rspVO.setPositionName(null);
                        rspVO.setUserName(null);
                        rspVO.setCurrentAccounts(null);
                    }
                    if (MapUtils.isNotEmpty((Map)fileMap)) {
                        List taActFileRespVos = (List)fileMap.get(r.getProcessInstanceId() + r.getNodeId());
                        rspVO.setFileList(Optional.ofNullable(taActFileRespVos).orElse(Lists.newArrayList()));
                    }
                    return rspVO;
                }).collect(Collectors.toList());
                optLogsRspVO.setOptRecordRspVOList(recordRspVOS);
                respVos.add(optLogsRspVO);
            });
        }
        return respVos;
    }

    @Override
    public List<ActivitiBpmlogEntity> findLogByUserAndCrmProcessInstanceId(String crmProcessInstanceId) {
        List bpmlogEntities = this.logMapper.selectList((Wrapper)Wrappers.lambdaQuery(ActivitiBpmlogEntity.class).eq(ActivitiBpmlogEntity::getCrmProcessInstanceId, (Object)crmProcessInstanceId));
        return bpmlogEntities;
    }

    @Override
    public List<OptLogsRspVO> getOptLogsOrderAsc(OptRecordReqVO reqVO) {
        List activitiBusinessEntities;
        if (StringUtils.isEmpty((CharSequence)reqVO.getProcessNo()) && StringUtils.isEmpty((CharSequence)reqVO.getProcessInstanceId()) && StringUtils.isEmpty((CharSequence)reqVO.getFormNo())) {
            throw new BusinessException("\u67e5\u8be2\u6d41\u7a0b\u65e5\u5fd7\u65f6,\u6d41\u7a0b\u7f16\u7801[processNo]\u548c\u6d41\u7a0b\u5b9e\u4f8bid[processInstanceId]\u548c\u4e1a\u52a1\u5355\u636eid[formNo]\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        ArrayList respVos = Lists.newArrayList();
        if (StringUtils.isNotEmpty((CharSequence)reqVO.getProcessNo())) {
            ActivitiBusinessEntity entity = (ActivitiBusinessEntity)this.activitiBusinessMapper.selectOne((Wrapper)Wrappers.lambdaQuery(ActivitiBusinessEntity.class).eq(ActivitiBusinessEntity::getCrmProcessInstanceId, (Object)reqVO.getProcessNo()));
            reqVO.setFormNo(entity.getBusinessId());
        }
        if (CollectionUtils.isEmpty((Collection)(activitiBusinessEntities = this.activitiBusinessMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ActivitiBusinessEntity.class).eq(StringUtils.isNotEmpty((CharSequence)reqVO.getProcessInstanceId()), ActivitiBusinessEntity::getProcessInstanceId, (Object)reqVO.getProcessInstanceId())).eq(StringUtils.isNotEmpty((CharSequence)reqVO.getFormNo()), ActivitiBusinessEntity::getBusinessId, (Object)reqVO.getFormNo())).orderByDesc(CrmBaseEntity::getCreateDateAll))))) {
            return Lists.newArrayList();
        }
        Map businessEntityMap = activitiBusinessEntities.stream().collect(Collectors.toMap(ActivitiBusinessEntity::getCrmProcessInstanceId, Function.identity()));
        List logEntities = this.logMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ActivitiBpmlogEntity.class).eq(StringUtils.isNotEmpty((CharSequence)reqVO.getProcessInstanceId()), ActivitiBpmlogEntity::getProcessInstanceId, (Object)reqVO.getProcessInstanceId())).eq(StringUtils.isNotEmpty((CharSequence)reqVO.getFormNo()), ActivitiBpmlogEntity::getBusinessId, (Object)reqVO.getFormNo())).orderByAsc(CrmBaseEntity::getCreateDateAll));
        List taskList = ((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(((ActivitiBusinessEntity)activitiBusinessEntities.get(0)).getProcessInstanceId())).orderByTaskCreateTime()).desc()).list();
        List<TaActFileRespVo> actFileRespVos = this.helper.findActFileByProcessInstanceIds(activitiBusinessEntities.stream().map(ActivitiBusinessEntity::getProcessInstanceId).collect(Collectors.toList()), 2);
        Map<String, List<TaActFileRespVo>> fileMap = actFileRespVos.stream().collect(Collectors.groupingBy(o -> o.getProcessInstId() + o.getNodeId()));
        Map<String, List<ActivitiBpmlogEntity>> map = logEntities.stream().collect(Collectors.groupingBy(CrmBaseEntity::getCreateDate));
        if (MapUtils.isNotEmpty(map)) {
            map.forEach((key, value) -> {
                OptLogsRspVO optLogsRspVO = new OptLogsRspVO();
                optLogsRspVO.setLogDate(key);
                List recordRspVOS = value.stream().map(r -> {
                    ActivitiBusinessEntity activitiBusinessEntity = (ActivitiBusinessEntity)businessEntityMap.get(r.getCrmProcessInstanceId());
                    OptRecordRspVO rspVO = new OptRecordRspVO();
                    rspVO.setProcessName(activitiBusinessEntity.getProcessName());
                    rspVO.setCreateTime(DateUtil.str2Date((String)r.getCreateDateAll(), (SimpleDateFormat)DateUtil.datetimeFormat));
                    rspVO.setProcessKey(activitiBusinessEntity.getProcessKey());
                    rspVO.setUserName(r.getCreateName());
                    rspVO.setUserCode(r.getCreateCode());
                    rspVO.setTaskName(r.getNodeName());
                    rspVO.setPositionCode(r.getCreatePosCode());
                    rspVO.setPositionName(r.getCreatePosName());
                    rspVO.setContent(r.getRemarks());
                    rspVO.setTitle(activitiBusinessEntity.getProcessTitle());
                    rspVO.setApplierName(activitiBusinessEntity.getCommitName());
                    rspVO.setFormNo(activitiBusinessEntity.getBusinessId());
                    rspVO.setOperation(r.getOperateType());
                    rspVO.setOperationStr(ActivitiOperateTypeEnum.getStatusNameByCode((String)r.getOperateType()));
                    rspVO.setCurrentAccounts(r.getCreateName() + "(" + r.getCreateCode() + ")");
                    if (StringUtils.equals((CharSequence)ActivitiOperateTypeEnum.COPY.getCode(), (CharSequence)r.getOperateType())) {
                        rspVO.setPositionName(null);
                        rspVO.setUserName(null);
                        rspVO.setCurrentAccounts(null);
                    }
                    if (MapUtils.isNotEmpty((Map)fileMap)) {
                        List taActFileRespVos = (List)fileMap.get(r.getProcessInstanceId() + r.getNodeId());
                        rspVO.setFileList(Optional.ofNullable(taActFileRespVos).orElse(Lists.newArrayList()));
                    }
                    return rspVO;
                }).collect(Collectors.toList());
                optLogsRspVO.setOptRecordRspVOList(recordRspVOS);
                respVos.add(optLogsRspVO);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)taskList)) {
            ActivitiBusinessEntity activitiBusinessEntity = (ActivitiBusinessEntity)activitiBusinessEntities.get(0);
            OptLogsRspVO optLogsRspVO = new OptLogsRspVO();
            ArrayList collect = Lists.newArrayList();
            List<TaNodeConfigEntity> nodes = this.helper.findFutureNodesByProcessVersionKey(activitiBusinessEntity.getProcessVersionKey(), taskList);
            taskList.stream().forEach(o -> {
                OptRecordRspVO rspVO = new OptRecordRspVO();
                this.helper.setCurrentTaskPosition(rspVO, (Task)o);
                rspVO.setCreateTime(new Date());
                rspVO.setTaskDefKey(o.getTaskDefinitionKey());
                rspVO.setTaskName(o.getName());
                rspVO.setTaskId(o.getId());
                rspVO.setProcessVersionKey(o.getProcessDefinitionId());
                rspVO.setProcessKey(activitiBusinessEntity.getProcessKey());
                rspVO.setProcessName(activitiBusinessEntity.getProcessName());
                rspVO.setContent("\u5f53\u524d\u5f85\u529e\u8282\u70b9");
                rspVO.setTitle(activitiBusinessEntity.getProcessTitle());
                rspVO.setApplierName(activitiBusinessEntity.getCommitName());
                rspVO.setFormNo(activitiBusinessEntity.getBusinessId());
                rspVO.setId(o.getId());
                rspVO.setOperation("BTN_999");
                rspVO.setOperationStr("\u5f85\u5904\u7406");
                rspVO.setUserName(rspVO.getCurrentAccounts());
                collect.add(rspVO);
            });
            if (CollectionUtils.isNotEmpty(nodes)) {
                nodes.stream().forEach(o -> {
                    OptRecordRspVO rspVO = new OptRecordRspVO();
                    rspVO.setTaskDefKey(o.getProcessNodeCode());
                    rspVO.setCreateTime(new Date());
                    rspVO.setTaskName(o.getProcessNodeName());
                    rspVO.setProcessKey(activitiBusinessEntity.getProcessKey());
                    rspVO.setProcessName(activitiBusinessEntity.getProcessName());
                    rspVO.setContent("\u5f85\u5904\u7406\u8282\u70b9");
                    rspVO.setTitle(activitiBusinessEntity.getProcessTitle());
                    rspVO.setApplierName(activitiBusinessEntity.getCommitName());
                    rspVO.setFormNo(activitiBusinessEntity.getBusinessId());
                    rspVO.setId(o.getId());
                    rspVO.setOperation("BTN_999");
                    rspVO.setOperationStr("\u5f85\u5904\u7406");
                    collect.add(rspVO);
                });
            }
            String date = DateUtil.formatDate((Date)new Date(), (String)"yyyy-MM-dd");
            optLogsRspVO.setLogDate(date);
            optLogsRspVO.setOptRecordRspVOList((List)collect);
            respVos.add(optLogsRspVO);
        }
        return respVos;
    }
}

