/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.copy.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activiti.entity.ActivitiBusinessEntity;
import com.biz.crm.activiti.service.ActivitiBusinessService;
import com.biz.crm.activiti.service.impl.ActivitiBusinessHelper;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.bpmlog.service.ActivitiBpmlogService;
import com.biz.crm.bpmlog.vo.ActivitiBpmlogVo;
import com.biz.crm.copy.entity.ActivitiCopyConfigEntity;
import com.biz.crm.copy.entity.ActivitiCopyTaskEntity;
import com.biz.crm.copy.mapper.ActivitiCopyConfigMapper;
import com.biz.crm.copy.service.ActivitiCopyConfigService;
import com.biz.crm.copy.service.ActivitiCopyTaskService;
import com.biz.crm.copy.vo.ActivitiCopySaveDetailVo;
import com.biz.crm.copy.vo.ActivitiCopySaveVo;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.activiti.ActivitiOperateTypeEnum;
import com.biz.crm.eunm.activiti.ActivityCopyFilterTypeEnum;
import com.biz.crm.eunm.activiti.ActivityCopyTaskTypeEnum;
import com.biz.crm.listener.mapper.TaListenerMapper;
import com.biz.crm.listener.model.TaListenerEntity;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActivitiCopyConfigServiceImpl
extends ServiceImpl<ActivitiCopyConfigMapper, ActivitiCopyConfigEntity>
implements ActivitiCopyConfigService {
    private static final Logger log = LoggerFactory.getLogger(ActivitiCopyConfigServiceImpl.class);
    @Autowired
    private ActivitiBusinessService activitiBusinessService;
    @Autowired
    private MdmPositionFeign positionFeign;
    @Autowired
    private ActivitiCopyTaskService activitiCopyTaskService;
    @Resource
    private TaListenerMapper listenerMapper;
    @Autowired
    private ActivitiBpmlogService logService;
    @Autowired
    private ActivitiBusinessHelper helper;

    @Override
    public List<ActivitiCopyConfigEntity> getListByProcessKey(String processKey) {
        AssertUtils.isNotEmpty((String)processKey, (String)"\u6d41\u7a0b\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a[processKey]");
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(ActivitiCopyConfigEntity::getProcessKey, (Object)processKey)).list();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveOrUpdate(ActivitiCopySaveVo activitiCopySaveVo) {
        String processKey = activitiCopySaveVo.getProcessKey();
        AssertUtils.isNotEmpty((String)processKey, (String)"\u6d41\u7a0b\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a[processKey]");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"process_key", (Object)processKey);
        this.remove((Wrapper)queryWrapper);
        List<ActivitiCopySaveDetailVo> items = activitiCopySaveVo.getItems();
        if (CollectionUtil.listNotEmptyNotSizeZero(items)) {
            ArrayList entities = new ArrayList();
            items.forEach(item -> {
                AssertUtils.isNotEmpty((String)item.getDataType(), (String)"\u6284\u9001\u7c7b\u578b[dataType]\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.isNotEmpty((String)item.getFilterType(), (String)"\u8fc7\u6ee4\u7c7b\u578b[filterType]\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.isNotEmpty((String)item.getDateCode(), (String)"\u89d2\u8272\u6216\u8005\u804c\u4f4d\u7f16\u7801[dateCode]\u4e0d\u80fd\u4e3a\u7a7a");
                ActivitiCopyConfigEntity entity = new ActivitiCopyConfigEntity();
                entity.setProcessKey(processKey);
                entity.setDataType(item.getDataType());
                if ("0".equals(item.getDataType())) {
                    entity.setFilterType(ActivityCopyFilterTypeEnum.POS.getCode());
                }
                entity.setFilterType(item.getFilterType());
                entity.setDateCode(item.getDateCode());
                entity.setDateName(item.getDateName());
                if (StringUtils.isNotEmpty((CharSequence)item.getExpandLister())) {
                    List taListenerEntities = this.listenerMapper.selectList((Wrapper)Wrappers.lambdaQuery(TaListenerEntity.class).eq(TaListenerEntity::getListenerValue, (Object)item.getExpandLister()));
                    AssertUtils.isNotEmpty((Collection)taListenerEntities, (String)("\u6284\u9001\u6269\u5c55\u76d1\u542c\u5668[" + item.getExpandLister() + "]\u4e0d\u5b58\u5728"));
                }
                entity.setExpandLister(item.getExpandLister());
                entities.add(entity);
            });
            this.saveBatch(entities);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void doCopyTask(String processKey, String processInstanceId) {
        List copyTaskEntities;
        ActivitiBusinessEntity entity = this.activitiBusinessService.getByCrmProcessInstanceId(processInstanceId);
        List<ActivitiCopyConfigEntity> copyConfigEntities = this.getListByProcessKey(entity.getProcessKey());
        if (CollectionUtil.listEmpty(copyConfigEntities)) {
            return;
        }
        HashSet posCodes = Sets.newHashSet();
        ArrayList roleCopy = new ArrayList();
        ArrayList roleCodes1 = Lists.newArrayList();
        ArrayList roleCodes2 = Lists.newArrayList();
        ArrayList roleCodes3 = Lists.newArrayList();
        UserRedis user = UserUtils.getUser();
        copyConfigEntities.forEach(item -> {
            if (ActivityCopyFilterTypeEnum.POS.getCode().equals(item.getFilterType())) {
                posCodes.add(item.getDateCode());
            }
            if (ActivityCopyFilterTypeEnum.UNDER_ROLE_ALL_POS.getCode().equals(item.getFilterType())) {
                roleCodes1.add(item.getDateCode());
            }
            if (ActivityCopyFilterTypeEnum.CURRENT_POS_AND_ALL_PARENT.getCode().equals(item.getFilterType())) {
                roleCodes2.add(item.getDateCode());
            }
            if (ActivityCopyFilterTypeEnum.CURRENT_POS.getCode().equals(item.getFilterType())) {
                roleCodes3.add(item.getDateCode());
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)roleCodes1)) {
            Set posCode1 = (Set)ApiResultUtil.objResult((Result)this.positionFeign.findPositionCodeSetByOrgParentAndBpmRoleCodeList(null, (List)roleCodes1));
            posCodes.addAll(posCode1);
        }
        if (CollectionUtils.isNotEmpty((Collection)roleCodes2)) {
            Set posCode2 = (Set)ApiResultUtil.objResult((Result)this.positionFeign.findPositionCodeSetByOrgParentAndBpmRoleCodeList(user.getOrgcode(), (List)roleCodes2));
            posCodes.addAll(posCode2);
        }
        if (CollectionUtils.isNotEmpty((Collection)roleCodes3)) {
            Set posCode3 = (Set)ApiResultUtil.objResult((Result)this.positionFeign.findPositionCodeSetByOrgAndBpmRoleCodeList(user.getOrgcode(), (List)roleCodes3));
            posCodes.addAll(posCode3);
        }
        if (CollectionUtils.isNotEmpty(copyTaskEntities = posCodes.stream().map(posCode -> {
            ActivitiCopyTaskEntity activitiCopyTaskEntity = new ActivitiCopyTaskEntity();
            activitiCopyTaskEntity.setPositionCode(posCode);
            activitiCopyTaskEntity.setCrmProcessInstanceId(entity.getCrmProcessInstanceId());
            activitiCopyTaskEntity.setProcessInstanceId(processInstanceId);
            activitiCopyTaskEntity.setProcessKey(entity.getProcessKey());
            activitiCopyTaskEntity.setTaskType(ActivityCopyTaskTypeEnum.COPY.getCode());
            activitiCopyTaskEntity.setReadStatus(GlobalWhetherEnum.NO.getCode());
            return activitiCopyTaskEntity;
        }).collect(Collectors.toList()))) {
            this.activitiCopyTaskService.saveBatch(copyTaskEntities);
            List mdmPositionUserOrgRespVos = (List)ApiResultUtil.objResult((Result)this.positionFeign.detailBatchByPositionCodeList((List)Lists.newArrayList((Iterable)posCodes)), (boolean)true);
            StringBuffer buffer = new StringBuffer();
            mdmPositionUserOrgRespVos.forEach(o -> {
                if (StringUtils.isNotEmpty((CharSequence)o.getFullName())) {
                    buffer.append(o.getFullName());
                }
                buffer.append("[").append(o.getPositionCode()).append("]");
                buffer.append(",");
            });
            ActivitiBpmlogVo bpmlogVo = ActivitiBpmlogVo.builder().businessId(entity.getBusinessId()).businessNo(entity.getBusinessNo()).crmProcessInstanceId(entity.getCrmProcessInstanceId()).taskId(null).processInstanceId(entity.getProcessInstanceId()).nodeName(null).nodeCode(null).nodeId(null).build();
            bpmlogVo.setRemarks("\u7cfb\u7edf\u81ea\u52a8\u6284\u9001\u7ed9:" + buffer.toString().substring(0, buffer.toString().length() - 1));
            bpmlogVo.setOperateType(ActivitiOperateTypeEnum.COPY.getCode());
            this.logService.commomSaveLog(bpmlogVo);
        }
    }
}

