/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.activiti.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.activiti.act.ActConfig;
import com.biz.crm.activiti.act.ActRelation;
import com.biz.crm.activiti.act.TaskResInfoVo;
import com.biz.crm.activiti.entity.ActReModelEntity;
import com.biz.crm.activiti.entity.ActivitiBusinessEntity;
import com.biz.crm.activiti.entity.TaActFileEntity;
import com.biz.crm.activiti.entity.TaFuncRoleEntity;
import com.biz.crm.activiti.entity.TaNodeConfigEntity;
import com.biz.crm.activiti.entity.TaTaskCommunicateEntity;
import com.biz.crm.activiti.mapper.ActReModelMapper;
import com.biz.crm.activiti.mapper.ActivitiBusinessMapper;
import com.biz.crm.activiti.mapper.ActivitiCurrentTaskMapper;
import com.biz.crm.activiti.mapper.TaFuncRoleMapper;
import com.biz.crm.activiti.service.ActivitiBusinessService;
import com.biz.crm.activiti.service.ActivitiTaskService;
import com.biz.crm.activiti.service.ActivityTaskUtil;
import com.biz.crm.activiti.service.BizRuntimeService;
import com.biz.crm.activiti.service.ITaActFileService;
import com.biz.crm.activiti.service.ITaNodeConfigService;
import com.biz.crm.activiti.service.impl.ActivitiBusinessHelper;
import com.biz.crm.activiti.yzj.ActiontypeVo;
import com.biz.crm.activiti.yzj.DoActionVo;
import com.biz.crm.activiti.yzj.TaskOpenIdVo;
import com.biz.crm.activiti.yzj.ToDoTaskReqVo;
import com.biz.crm.activiti.yzj.ToYzjMqVo;
import com.biz.crm.annotation.Klock;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.bpmlog.entity.ActivitiBpmlogEntity;
import com.biz.crm.bpmlog.mapper.ActivitiBpmlogMapper;
import com.biz.crm.bpmlog.service.ActivitiBpmlogService;
import com.biz.crm.bpmlog.vo.ActivitiBpmlogVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.copy.entity.ActivitiCopyTaskEntity;
import com.biz.crm.copy.mapper.ActivitiCopyTaskMapper;
import com.biz.crm.copy.service.ActivitiCopyTaskService;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.activiti.ActivitiOperateTypeEnum;
import com.biz.crm.eunm.activiti.ActivityCopyTaskTypeEnum;
import com.biz.crm.eunm.activiti.Indicator;
import com.biz.crm.eunm.activiti.IndicatorStr;
import com.biz.crm.eunm.activiti.ProcessInstanceStatusEnum;
import com.biz.crm.mdm.bpmrole.MdmBpmRoleFeign;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.mdm.user.MdmUserFeign;
import com.biz.crm.nebular.activiti.act.req.TaActDelegateReqVo;
import com.biz.crm.nebular.activiti.act.resp.TaActFileRespVo;
import com.biz.crm.nebular.activiti.act.resp.TaActTargetRespVo;
import com.biz.crm.nebular.activiti.design.resp.OptBtnVO;
import com.biz.crm.nebular.activiti.task.resp.ProcessSummaryRspVO;
import com.biz.crm.nebular.activiti.vo.ActivitiBusinessVo;
import com.biz.crm.nebular.activiti.vo.ActivitiCurrentTaskVo;
import com.biz.crm.nebular.activiti.vo.BpmQueryVo;
import com.biz.crm.nebular.activiti.vo.CompleteTaskVo;
import com.biz.crm.nebular.activiti.vo.CurrentTaskVo;
import com.biz.crm.nebular.activiti.vo.CurrentVo;
import com.biz.crm.nebular.activiti.vo.ProcessCirculateReqVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionCurrentUserReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.PositionUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngineConfiguration;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.TransitionImpl;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.activiti.image.ProcessDiagramGenerator;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.elasticsearch.common.util.set.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Service
@ConditionalOnMissingBean(name={"BizRuntimeExpandServiceImpl"})
public class BizRuntimeServiceImpl
implements BizRuntimeService {
    private static final Logger log = LoggerFactory.getLogger(BizRuntimeServiceImpl.class);
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private RocketMQTemplate rocketMQTemplate;
    @Autowired
    private IdentityService identityService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ProcessEngineConfiguration processEngineConfiguration;
    @Autowired
    private ActivitiBusinessService activitiBusinessService;
    @Autowired
    private ActivitiBpmlogService logService;
    @Resource
    private ActivitiBpmlogMapper logMapper;
    @Autowired
    private ActivitiTaskService activitiTaskService;
    @Autowired
    private ActivityTaskUtil activityTaskUtil;
    @Resource
    private ActivitiCurrentTaskMapper activitiCurrentTaskMapper;
    @Resource
    private MdmBpmRoleFeign mdmBpmRoleFeign;
    @Autowired
    private ITaActFileService fileService;
    @Resource
    private ActReModelMapper actReModelMapper;
    @Resource
    private ActivitiBusinessMapper activitiBusinessMapper;
    @Autowired
    private ActivitiBusinessHelper helper;
    @Autowired
    private MdmUserFeign mdmUserFeign;
    @Autowired
    private MdmPositionFeign positionFeign;
    @Resource
    private ActivitiCopyTaskMapper copyTaskMapper;
    @Autowired
    private ActivitiCopyTaskService copyTaskService;
    @Autowired
    private ITaNodeConfigService nodeConfigService;
    @Resource
    private TaFuncRoleMapper funcRoleMapper;
    @Value(value="${yzj.appid:}")
    private String appid;
    @Value(value="${yzj.viewurl:}")
    private String viewHttp;
    @Autowired
    private MdmPositionFeign mdmPositionFeign;

    private ProcessInstance startProcessInstanceByKey(String processKey, String businessObjIdOrNum, Map<String, Object> variables) {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(processKey, businessObjIdOrNum, variables);
        return processInstance;
    }

    @Override
    @Klock(keys={"#activitiBusinessVo.businessId"}, waitTime=60L, leaseTime=300L)
    @Transactional(rollbackFor={Exception.class})
    public String startProcess(final ActivitiBusinessVo activitiBusinessVo) {
        UserRedis userRedis = UserUtils.getUser();
        log.info("\u63d0\u4ea4\u5de5\u4f5c\u6d41", (Object)activitiBusinessVo);
        String checkResult = this.checkStartProcess(activitiBusinessVo, userRedis);
        if (com.biz.crm.util.StringUtils.isNotEmpty((String)checkResult)) {
            return checkResult;
        }
        this.identityService.setAuthenticatedUserId(activitiBusinessVo.getPositionCode());
        Map variables = activitiBusinessVo.getVariables();
        if (activitiBusinessVo.getVariables() != null && !activitiBusinessVo.getVariables().isEmpty()) {
            variables.putAll(activitiBusinessVo.getVariables());
        } else {
            variables = Maps.newHashMap();
        }
        variables.put("COMMIT_ORG_", userRedis.getOrgcode());
        variables.put("COMMIT_POS_", userRedis.getPoscode());
        ProcessInstance processInstance = this.startProcessInstanceByKey(activitiBusinessVo.getProcessKey(), activitiBusinessVo.getBusinessId(), variables);
        if (processInstance == null) {
            throw new BusinessException("\u53d1\u8d77\u6d41\u7a0b\u5931\u8d25");
        }
        if (StringUtils.isEmpty((CharSequence)processInstance.getId())) {
            throw new BusinessException("\u53d1\u8d77\u6d41\u7a0b\u5931\u8d25");
        }
        final ActivitiBusinessEntity businessEntity = this.activitiBusinessService.save(processInstance, activitiBusinessVo);
        StringBuffer buffer = new StringBuffer();
        buffer.append(userRedis.getRealname()).append("[").append(activitiBusinessVo.getPositionCode()).append("]").append("\u53d1\u8d77\u6d41\u7a0b");
        ActivitiCurrentTaskVo currentTaskVo = new ActivitiCurrentTaskVo(businessEntity.getCrmProcessInstanceId(), businessEntity.getProcessInstanceId(), "5", activitiBusinessVo.getProcessTitle(), userRedis.getRealname(), activitiBusinessVo.getPositionCode());
        ProcessInstance processInstanceNow = this.activityTaskUtil.getProcessInstance(businessEntity.getProcessInstanceId(), null);
        if (processInstanceNow != null) {
            CurrentVo currentVo = this.activityTaskUtil.getCurrentVo(businessEntity.getProcessInstanceId(), null);
            this.saveCurrentTask(currentVo, currentTaskVo);
        }
        this.logService.commomSaveLog(businessEntity.getCrmProcessInstanceId(), businessEntity.getProcessInstanceId(), activitiBusinessVo.getBusinessId(), activitiBusinessVo.getBusinessNo(), buffer.toString(), ActivitiOperateTypeEnum.START.getCode());
        if (CollectionUtil.collectionNotEmpty((Collection)activitiBusinessVo.getAttachmentVos())) {
            List fileEntities = activitiBusinessVo.getAttachmentVos().stream().map(file -> {
                TaActFileEntity fileEntity = new TaActFileEntity();
                fileEntity.setFileAddress(file.getFileAddress());
                fileEntity.setObjectName(file.getObjectName());
                fileEntity.setFileType(Integer.valueOf(Indicator.ACTIVITI_FILE_START.getCode()));
                fileEntity.setProcessInstId(businessEntity.getProcessInstanceId());
                return fileEntity;
            }).collect(Collectors.toList());
            this.fileService.saveBatch(fileEntities);
        }
        this.startProcessDoOtherThings(businessEntity.getProcessInstanceId());
        List<Task> nextTasks = this.helper.findCurrentTasksByProcessInstanceId(businessEntity.getProcessInstanceId());
        if (CollectionUtils.isNotEmpty(nextTasks)) {
            Task nextTask = nextTasks.get(0);
            TaNodeConfigEntity nextNode = this.helper.findNodeByProcessVersionKeyAndNodeCode(businessEntity.getProcessVersionKey(), nextTasks.get(0).getTaskDefinitionKey());
            CompleteTaskVo vo = new CompleteTaskVo();
            vo.setPass(Boolean.valueOf(true));
            List identityLinksForTask = this.taskService.getIdentityLinksForTask(nextTask.getId());
            HashSet queryPosCodes = Sets.newHashSet((Object[])new String[0]);
            HashSet queryBpmRoleCodes = Sets.newHashSet((Object[])new String[0]);
            identityLinksForTask.forEach(o -> {
                if (StringUtils.isNotEmpty((CharSequence)o.getUserId())) {
                    queryPosCodes.add(o.getUserId());
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getGroupId())) {
                    queryBpmRoleCodes.add(o.getGroupId());
                }
            });
            Map<Object, Object> posMap = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty((Collection)queryPosCodes)) {
                posMap = this.helper.findUserByPositionCodes(queryPosCodes).stream().collect(Collectors.toMap(MdmPositionUserOrgRespVo::getPositionCode, Function.identity()));
            }
            HashMap bpmRoleMap = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty((Collection)queryBpmRoleCodes)) {
                queryBpmRoleCodes.forEach(o -> {
                    Set posCodes = (Set)ApiResultUtil.objResult((Result)this.positionFeign.findPositionCodeSetByOrgParentAndBpmRoleCodeList(null, (List)Lists.newArrayList((Object[])new String[]{o})));
                    bpmRoleMap.put(o, posCodes);
                });
            }
            vo.setTaskId(nextTask.getId());
            vo.setCrmProcessInstanceId(businessEntity.getCrmProcessInstanceId());
            if (Objects.equals(1, nextNode.getAuditNullSkip())) {
                Boolean nullSkipFlag = false;
                String nullSkipUserId = "";
                for (IdentityLink link : identityLinksForTask) {
                    Set posCodes;
                    if (StringUtils.isNotEmpty((CharSequence)link.getUserId())) {
                        MdmPositionUserOrgRespVo mdmPositionUserOrgRespVo = (MdmPositionUserOrgRespVo)posMap.get(link.getUserId());
                        if (Objects.nonNull(mdmPositionUserOrgRespVo)) {
                            nullSkipFlag = true;
                            break;
                        }
                        nullSkipUserId = link.getUserId();
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)link.getGroupId()) || !CollectionUtils.isNotEmpty((Collection)(posCodes = (Set)bpmRoleMap.get(link.getGroupId())))) continue;
                    nullSkipFlag = true;
                    break;
                }
                if (!nullSkipFlag.booleanValue()) {
                    if (StringUtils.isEmpty((CharSequence)nullSkipUserId)) {
                        nullSkipUserId = userRedis.getPoscode();
                    }
                    vo.setPositionCode(nullSkipUserId);
                    vo.setRemarks("\u5c97\u4f4d\u6216\u6d41\u7a0b\u89d2\u8272\u5bf9\u5e94\u4eba\u5458\u4e3a\u7a7a,\u81ea\u52a8\u8df3\u8fc7");
                    this.completeTasks(vo);
                }
            }
            if (Objects.equals(1, nextNode.getAuditRepeatSkip())) {
                Boolean flag = false;
                String repeatSkipUserId = "";
                List<ActivitiBpmlogEntity> logs = this.logService.findLogByUserAndCrmProcessInstanceId(businessEntity.getCrmProcessInstanceId());
                Set set = logs.stream().filter(o -> StringUtils.equals((CharSequence)ActivitiOperateTypeEnum.START.getCode(), (CharSequence)o.getOperateType())).map(CrmBaseEntity::getCreatePosCode).collect(Collectors.toSet());
                block1: for (IdentityLink link : identityLinksForTask) {
                    Set posCodes;
                    if (StringUtils.isNotEmpty((CharSequence)link.getUserId()) && (set.contains(link.getUserId()) || StringUtils.equals((CharSequence)userRedis.getPoscode(), (CharSequence)link.getUserId()))) {
                        flag = true;
                        repeatSkipUserId = link.getUserId();
                        break;
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)link.getGroupId()) || !CollectionUtils.isNotEmpty((Collection)(posCodes = (Set)bpmRoleMap.get(link.getGroupId())))) continue;
                    for (String posCode : posCodes) {
                        if (!set.contains(posCode)) continue;
                        flag = true;
                        repeatSkipUserId = posCode;
                        continue block1;
                    }
                }
                if (flag.booleanValue()) {
                    vo.setPositionCode(repeatSkipUserId);
                    vo.setRemarks("\u5c97\u4f4d[" + repeatSkipUserId + "]\u91cd\u590d\u5ba1\u6279,\u81ea\u52a8\u8df3\u8fc7");
                    this.completeTasks(vo);
                }
            }
        }
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

            public void afterCommit() {
                ToYzjMqVo mqVo = BizRuntimeServiceImpl.this.buioldMqInfo(businessEntity, false);
                if (CollectionUtil.listNotEmpty((List)mqVo.getToDoTaskReqVos()) || CollectionUtil.listNotEmpty((List)mqVo.getDoActionVos())) {
                    log.info("\u5f00\u542f\u5de5\u4f5c\u6d41\u6210\u529f\uff0c\u53d1\u9001MQ\u901a\u77e5\u4e91\u4e4b\u5bb6\uff0ccrmprocessInstanceId={},\u4e1a\u52a1\u5355\u53f7={}", (Object)businessEntity.getCrmProcessInstanceId(), (Object)activitiBusinessVo.getBusinessNo());
                    BizRuntimeServiceImpl.this.sendData2Mq(mqVo);
                }
            }
        });
        return businessEntity.getCrmProcessInstanceId();
    }

    private void saveCurrentTask(CurrentVo currentVo, ActivitiCurrentTaskVo vo) {
        Set bpmRoleCode;
        if (currentVo == null) {
            return;
        }
        Set positionCode = currentVo.getPositionCode();
        if (positionCode != null && !positionCode.isEmpty()) {
            positionCode.forEach(item -> {
                ActivitiCurrentTaskVo currentTaskVo = new ActivitiCurrentTaskVo();
                BeanUtils.copyProperties((Object)vo, (Object)currentTaskVo);
                currentTaskVo.setDateType("1");
                currentTaskVo.setPositionCode(item);
                currentTaskVo.setBpmRoeCode(null);
                this.activitiTaskService.saveTask(currentTaskVo);
            });
        }
        if ((bpmRoleCode = currentVo.getBpmRoleCode()) != null && !bpmRoleCode.isEmpty()) {
            bpmRoleCode.forEach(item -> {
                ActivitiCurrentTaskVo currentTaskVo = new ActivitiCurrentTaskVo();
                BeanUtils.copyProperties((Object)vo, (Object)currentTaskVo);
                currentTaskVo.setDateType("1");
                currentTaskVo.setPositionCode(null);
                currentTaskVo.setBpmRoeCode(item);
                this.activitiTaskService.saveTask(currentTaskVo);
            });
        }
    }

    private String checkStartProcess(ActivitiBusinessVo activitiBusinessVo, UserRedis userRedis) {
        if (StringUtils.isEmpty((CharSequence)activitiBusinessVo.getProcessKey())) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u9700\u8981\u63d0\u4ea4\u7684\u6d41\u7a0b\u3010processKey\u3011");
        }
        if (StringUtils.isEmpty((CharSequence)activitiBusinessVo.getBusinessId())) {
            throw new BusinessException("\u4e1a\u52a1\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\u3010businessId\u3011");
        }
        if (StringUtils.isEmpty((CharSequence)activitiBusinessVo.getPositionCode())) {
            throw new BusinessException("\u5f53\u524d\u63d0\u4ea4\u4eba\u4e0d\u80fd\u4e3a\u7a7a\u3010positionCode\u3011");
        }
        ActReModelEntity actReModelEntity = (ActReModelEntity)this.actReModelMapper.selectOne((Wrapper)Wrappers.lambdaQuery(ActReModelEntity.class).eq(ActReModelEntity::getKey, (Object)activitiBusinessVo.getProcessKey()));
        AssertUtils.isNotNull((Object)actReModelEntity, (String)("\u60a8\u9009\u62e9\u7684\u6d41\u7a0b[" + activitiBusinessVo.getProcessKey() + "]\u5df2\u7ecf\u4e0d\u5b58\u5728,\u8bf7\u91cd\u65b0\u9009\u62e9"));
        activitiBusinessVo.setProcessName(actReModelEntity.getName());
        if (StringUtils.equals((CharSequence)activitiBusinessVo.getPositionCode(), (CharSequence)userRedis.getPoscode())) {
            activitiBusinessVo.setCommitCode(userRedis.getUsername());
            activitiBusinessVo.setCommitByOrg(userRedis.getOrgcode());
            activitiBusinessVo.setCommitByOrgName(userRedis.getOrgname());
            activitiBusinessVo.setCommitPos(userRedis.getPoscode());
            activitiBusinessVo.setCommitPosName(userRedis.getPosname());
            activitiBusinessVo.setCommitName(StringUtils.isEmpty((CharSequence)activitiBusinessVo.getCommitName()) ? userRedis.getRealname() : activitiBusinessVo.getCommitName());
        }
        return this.activityTaskUtil.checkRepeatCommit(activitiBusinessVo.getBusinessId());
    }

    @Override
    public PageResult<CurrentTaskVo> listByPositionCode(BpmQueryVo bpmQueryVo) {
        List<CurrentTaskVo> list;
        String positionCode = bpmQueryVo.getPositionCode();
        UserRedis userRedis = UserUtils.getUser();
        bpmQueryVo.setCurrentUserName(userRedis.getUsername());
        if (StringUtils.isEmpty((CharSequence)positionCode)) {
            positionCode = userRedis.getPoscode();
        }
        AssertUtils.isNotEmpty((String)positionCode, (String)"\u5f53\u524d\u767b\u5f55\u4eba\u672a\u83b7\u53d6\u5230\u804c\u4f4d\u4fe1\u606f");
        ArrayList<String> positionCodes = new ArrayList<String>();
        positionCodes.add(positionCode);
        Set bpmRoleCodeSet = (Set)ApiResultUtil.objResult((Result)this.mdmBpmRoleFeign.findBpmRoleCodeSetByPositionCodeList(positionCodes), (boolean)true);
        bpmRoleCodeSet = bpmRoleCodeSet == null ? new HashSet() : bpmRoleCodeSet;
        Page page = PageUtil.buildPage((Integer)bpmQueryVo.getPageNum(), (Integer)bpmQueryVo.getPageSize());
        if (StringUtils.isNotEmpty((CharSequence)bpmQueryVo.getCommitBeginDate())) {
            bpmQueryVo.setCommitBeginDate(bpmQueryVo.getCommitBeginDate() + " 00:00:00");
        }
        if (StringUtils.isNotEmpty((CharSequence)bpmQueryVo.getCommitEndDate())) {
            bpmQueryVo.setCommitEndDate(bpmQueryVo.getCommitEndDate() + " 23:59:59");
        }
        if (StringUtils.isNotEmpty((CharSequence)bpmQueryVo.getDoneBeginDate())) {
            bpmQueryVo.setDoneBeginDate(bpmQueryVo.getDoneBeginDate() + " 00:00:00");
        }
        if (StringUtils.isNotEmpty((CharSequence)bpmQueryVo.getDoneEndDate())) {
            bpmQueryVo.setDoneEndDate(bpmQueryVo.getDoneEndDate() + " 23:59:59");
        }
        if (CollectionUtils.isNotEmpty(list = this.activitiCurrentTaskMapper.listByPositionCode(page, positionCode, new ArrayList<String>(bpmRoleCodeSet), bpmQueryVo))) {
            list.forEach(o -> o.setBpmStatusName(ActivitiOperateTypeEnum.getStatusNameByCode((String)o.getBpmStatus())));
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<CurrentTaskVo> listYzjByPositionCode(BpmQueryVo bpmQueryVo) {
        List<CurrentTaskVo> list;
        ArrayList<String> positionCodes = new ArrayList<String>();
        String positionCode = bpmQueryVo.getPositionCode();
        UserRedis userRedis = UserUtils.getUser();
        bpmQueryVo.setCurrentUserName(userRedis.getUsername());
        if (StringUtils.isEmpty((CharSequence)positionCode)) {
            MdmPositionCurrentUserReqVo vo = new MdmPositionCurrentUserReqVo();
            vo.setUserName(userRedis.getUsername());
            Result allPositionsByUserName = this.mdmPositionFeign.findAllPositionsByUserName(vo);
            positionCodes.addAll((Collection)ApiResultUtil.objResult((Result)allPositionsByUserName));
        } else {
            positionCodes.add(positionCode);
        }
        Set bpmRoleCodeSet = (Set)ApiResultUtil.objResult((Result)this.mdmBpmRoleFeign.findBpmRoleCodeSetByPositionCodeList(positionCodes), (boolean)true);
        bpmRoleCodeSet = bpmRoleCodeSet == null ? new HashSet() : bpmRoleCodeSet;
        Page page = PageUtil.buildPage((Integer)bpmQueryVo.getPageNum(), (Integer)bpmQueryVo.getPageSize());
        if (StringUtils.isNotEmpty((CharSequence)bpmQueryVo.getCommitBeginDate())) {
            bpmQueryVo.setCommitBeginDate(bpmQueryVo.getCommitBeginDate() + " 00:00:00");
        }
        if (StringUtils.isNotEmpty((CharSequence)bpmQueryVo.getCommitEndDate())) {
            bpmQueryVo.setCommitEndDate(bpmQueryVo.getCommitEndDate() + " 23:59:59");
        }
        if (StringUtils.isNotEmpty((CharSequence)bpmQueryVo.getDoneBeginDate())) {
            bpmQueryVo.setDoneBeginDate(bpmQueryVo.getDoneBeginDate() + " 00:00:00");
        }
        if (StringUtils.isNotEmpty((CharSequence)bpmQueryVo.getDoneEndDate())) {
            bpmQueryVo.setDoneEndDate(bpmQueryVo.getDoneEndDate() + " 23:59:59");
        }
        if (CollectionUtils.isNotEmpty(list = this.activitiCurrentTaskMapper.listByYzjPositionCode(page, positionCodes, new ArrayList<String>(bpmRoleCodeSet), bpmQueryVo))) {
            list.forEach(o -> o.setBpmStatusName(ActivitiOperateTypeEnum.getStatusNameByCode((String)o.getBpmStatus())));
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<CurrentTaskVo> listMyBpm(BpmQueryVo bpmQueryVo) {
        UserRedis userRedis = UserUtils.getUser();
        List positionRespVos = PositionUtil.getAllPositionByUsername((String)userRedis.getUsername());
        HashSet<String> set = new HashSet<String>();
        for (MdmPositionRespVo item : positionRespVos) {
            set.add(item.getPositionCode());
        }
        Page page = PageUtil.buildPage((Integer)bpmQueryVo.getPageNum(), (Integer)bpmQueryVo.getPageSize());
        List<CurrentTaskVo> list = this.activitiCurrentTaskMapper.listMyBpmOther(page, new ArrayList<String>(set), bpmQueryVo.getBpmStatus());
        if (CollectionUtils.isNotEmpty(list)) {
            ArrayList positionCodes = Lists.newArrayList();
            list.stream().forEach(o -> {
                if (StringUtils.isNotEmpty((CharSequence)o.getCurrentTaskPositionCode())) {
                    positionCodes.add(o.getCurrentTaskPositionCode());
                }
            });
            Map<String, MdmPositionUserOrgRespVo> positionRespVoMap = this.helper.findPositionMapByCodes(positionCodes);
            list.forEach(o -> {
                this.helper.listMyBpmSetCurrentPositionAndUserByProcessInstanceId((CurrentTaskVo)o);
                o.setBpmStatusName(ActivitiOperateTypeEnum.getStatusNameByCode((String)o.getBpmStatus()));
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<CurrentTaskVo> listMyRejectBpm(BpmQueryVo bpmQueryVo) {
        UserRedis userRedis = UserUtils.getUser();
        List positionRespVos = PositionUtil.getAllPositionByUsername((String)userRedis.getUsername());
        HashSet<String> set = new HashSet<String>();
        for (MdmPositionRespVo item : positionRespVos) {
            set.add(item.getPositionCode());
        }
        Page page = PageUtil.buildPage((Integer)bpmQueryVo.getPageNum(), (Integer)bpmQueryVo.getPageSize());
        List<CurrentTaskVo> list = this.activitiCurrentTaskMapper.listMyRejectBpm(page, new ArrayList<String>(set));
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public InputStream getProcessInstancePicInfo(String processInstanceId) {
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (Objects.isNull(processInstance)) {
            throw new BusinessException("\u6d41\u7a0b\u6570\u636e\u5f02\u5e38,\u5f53\u524d\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u5b58\u5728");
        }
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processInstance.getProcessDefinitionId());
        Context.setProcessEngineConfiguration((ProcessEngineConfigurationImpl)((ProcessEngineConfigurationImpl)this.processEngineConfiguration));
        ProcessDiagramGenerator diagramGenerator = this.processEngineConfiguration.getProcessDiagramGenerator();
        ProcessDefinitionEntity definitionEntity = (ProcessDefinitionEntity)this.repositoryService.getProcessDefinition(processInstance.getProcessDefinitionId());
        List highLightedActivitList = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).list();
        ArrayList<String> highLightedActivitis = new ArrayList<String>();
        List<String> highLightedFlows = this.activityTaskUtil.getHighLightedFlows(definitionEntity, highLightedActivitList);
        for (HistoricActivityInstance tempActivity : highLightedActivitList) {
            String activityId = tempActivity.getActivityId();
            highLightedActivitis.add(activityId);
        }
        InputStream imageStream = diagramGenerator.generateDiagram(bpmnModel, "png", highLightedActivitis, highLightedFlows, "\u5b8b\u4f53", "\u5b8b\u4f53", "\u5b8b\u4f53", null, 1.0);
        return imageStream;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Klock(keys={"#completeTaskVo.taskId"}, waitTime=60L, leaseTime=300L)
    public void completeTasks(CompleteTaskVo completeTaskVo) {
        log.info("\u5b8c\u6210\u4efb\u52a1\u53c2\u6570\uff1ataskId={} ,params={}", (Object)completeTaskVo);
        AssertUtils.isNotEmpty((String)completeTaskVo.getTaskId(), (String)"\u8282\u70b9\u4efb\u52a1id[taskId]\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)completeTaskVo.getCrmProcessInstanceId(), (String)"\u6d41\u7a0b\u7f16\u53f7[crmProcessInstanceId]\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotNull((Object)completeTaskVo.getPass(), (String)"\u64cd\u4f5c\u7c7b\u578b[pass]\u4e0d\u80fd\u4e3a\u7a7a");
        final ActivitiBusinessEntity entity = this.helper.findActivitiBusinessEntityByCrmInstanceId(completeTaskVo.getCrmProcessInstanceId());
        AssertUtils.isNotNull((Object)entity, (String)("\u6d41\u7a0b\u7f16\u7801:" + completeTaskVo.getCrmProcessInstanceId() + ",\u5bf9\u5e94\u7684\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u5b58\u5728"));
        AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)ProcessInstanceStatusEnum.ENABLE.getCode(), (CharSequence)entity.getProcessInstanceStatus()), (String)"\u5f53\u524d\u6d41\u7a0b\u5b9e\u4f8b\u72b6\u6001\u4e0d\u4e3a\u542f\u7528,\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c");
        if (!StringUtils.equals((CharSequence)ActivitiOperateTypeEnum.COMMIT.getCode(), (CharSequence)entity.getBpmStatus())) {
            throw new BusinessException("\u60a8\u64cd\u4f5c\u7684\u6d41\u7a0b\u5b9e\u4f8b\u72b6\u6001\u5df2\u53d1\u751f\u53d8\u66f4,\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u64cd\u4f5c");
        }
        Task currentTaskByTask = this.helper.findCurrentTaskByTaskId(completeTaskVo.getTaskId());
        if (Objects.isNull(currentTaskByTask)) {
            throw new BusinessException("\u5f53\u524d\u4efb\u52a1\u5df2\u7ecf\u4e0d\u5b58\u5728,\u8bf7\u5237\u65b0\u540e\u518d\u64cd\u4f5c");
        }
        if (StringUtils.isEmpty((CharSequence)completeTaskVo.getPositionCode())) {
            completeTaskVo.setPositionCode(UserUtils.getUser().getPoscode());
        }
        TaNodeConfigEntity nodeConfigEntity = this.helper.findNodeByProcessVersionKeyAndNodeCode(entity.getProcessVersionKey(), currentTaskByTask.getTaskDefinitionKey());
        ActivitiBpmlogVo bpmlogVo = ActivitiBpmlogVo.builder().businessId(entity.getBusinessId()).businessNo(entity.getBusinessNo()).crmProcessInstanceId(entity.getCrmProcessInstanceId()).taskId(completeTaskVo.getTaskId()).processInstanceId(entity.getProcessInstanceId()).nodeName(currentTaskByTask.getName()).nodeCode(currentTaskByTask.getTaskDefinitionKey()).nodeId(Objects.nonNull(nodeConfigEntity) ? nodeConfigEntity.getProcessNodeId() : null).build();
        String operateTypeEnumCode = null;
        if (CollectionUtil.collectionNotEmpty((Collection)completeTaskVo.getAttachmentVos())) {
            List fileEntities = completeTaskVo.getAttachmentVos().stream().map(file -> {
                TaActFileEntity fileEntity = new TaActFileEntity();
                fileEntity.setFileAddress(file.getFileAddress());
                fileEntity.setTaskId(completeTaskVo.getTaskId());
                fileEntity.setNodeId(nodeConfigEntity.getProcessNodeId());
                fileEntity.setNodeName(nodeConfigEntity.getProcessNodeName());
                fileEntity.setNodeCode(nodeConfigEntity.getProcessNodeCode());
                fileEntity.setObjectName(file.getObjectName());
                fileEntity.setFileType(Integer.valueOf(Indicator.ACTIVITI_FILE_APPROVE.getCode()));
                fileEntity.setProcessInstId(entity.getProcessInstanceId());
                return fileEntity;
            }).collect(Collectors.toList());
            this.fileService.saveBatch(fileEntities);
        }
        if (completeTaskVo.getPass().booleanValue()) {
            this.checkUserOperatePermission(entity.getProcessVersionKey(), currentTaskByTask.getTaskDefinitionKey(), IndicatorStr.PROCESS_BTN_APPROVAL);
            operateTypeEnumCode = ActivitiOperateTypeEnum.PASS.getCode();
            if (com.biz.crm.util.StringUtils.isEmpty((String)completeTaskVo.getRemarks())) {
                completeTaskVo.setRemarks("\u540c\u610f");
            }
            bpmlogVo.setRemarks(this.helper.getProcessOperateLogDesc(operateTypeEnumCode, completeTaskVo.getPositionCode(), false) + ",\u5ba1\u6279\u610f\u89c1:" + completeTaskVo.getRemarks());
            bpmlogVo.setOperateType(operateTypeEnumCode);
            this.logService.commomSaveLog(bpmlogVo);
            this.passBpm(completeTaskVo);
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                public void afterCommit() {
                    ToYzjMqVo mqVo = BizRuntimeServiceImpl.this.buioldMqInfo(entity, true);
                    if (CollectionUtil.listNotEmpty((List)mqVo.getDoActionVos()) || CollectionUtil.listNotEmpty((List)mqVo.getToDoTaskReqVos())) {
                        log.info("\u5ba1\u6279\u901a\u8fc7\u6210\u529f\uff0c\u53d1\u9001MQ\u901a\u77e5\u4e91\u4e4b\u5bb6\uff0cmqVo={}", (Object)JSON.toJSONString((Object)mqVo));
                        BizRuntimeServiceImpl.this.sendData2Mq(mqVo);
                    }
                }
            });
        } else {
            this.checkUserOperatePermission(entity.getProcessVersionKey(), currentTaskByTask.getTaskDefinitionKey(), IndicatorStr.PROCESS_BTN_REJECT_FIRST);
            operateTypeEnumCode = ActivitiOperateTypeEnum.REJECT.getCode();
            bpmlogVo.setRemarks(this.helper.getProcessOperateLogDesc(operateTypeEnumCode, completeTaskVo.getPositionCode(), false) + ",\u5ba1\u6279\u610f\u89c1:" + completeTaskVo.getRemarks());
            bpmlogVo.setOperateType(operateTypeEnumCode);
            this.logService.commomSaveLog(bpmlogVo);
            this.rejectBpm(completeTaskVo, "ABORT");
            this.rejectTaskDoOtherThings(entity.getProcessInstanceId());
            if (nodeConfigEntity.getIsMobile() != null && nodeConfigEntity.getIsMobile() == 1) {
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                    public void afterCommit() {
                        ToYzjMqVo mqVo = BizRuntimeServiceImpl.this.buioldMqInfo(entity, true);
                        if (CollectionUtil.listNotEmpty((List)mqVo.getDoActionVos()) || CollectionUtil.listNotEmpty((List)mqVo.getToDoTaskReqVos())) {
                            log.info("\u9a73\u56de\u4efb\u52a1\u6210\u529f\uff0c\u53d1\u9001MQ\u901a\u77e5\u4e91\u4e4b\u5bb6\uff0cmqVo={}", (Object)JSON.toJSONString((Object)mqVo));
                            BizRuntimeServiceImpl.this.sendData2Mq(mqVo);
                        }
                    }
                });
            }
        }
        log.info("\u5b8c\u6210\u4efb\u52a1\uff1a\u4efb\u52a1ID\uff1a" + completeTaskVo.getTaskId());
    }

    private ToYzjMqVo buioldMqInfo(ActivitiBusinessEntity entity, boolean hadYb) {
        ToYzjMqVo mqVo = new ToYzjMqVo();
        mqVo.setProcessInstanceId(entity.getProcessInstanceId());
        mqVo.setCrmProcessInstanceId(entity.getCrmProcessInstanceId());
        mqVo.setToDoTaskReqVos(this.createToDoTask(entity));
        if (hadYb) {
            List<ToDoTaskReqVo> hasHandleTaskList = this.activitiBusinessMapper.findByProcessInstanceId(entity.getProcessInstanceId());
            ArrayList doActionVos = Lists.newArrayList();
            if (CollectionUtil.listNotEmpty(hasHandleTaskList)) {
                for (ToDoTaskReqVo toAction : hasHandleTaskList) {
                    DoActionVo doActionVo = new DoActionVo();
                    doActionVo.setOpenids((List)Lists.newArrayList((Object[])new String[]{toAction.getOpenId()}));
                    doActionVo.setSourceitemid(toAction.getSourceId());
                    doActionVo.setSourcetype(this.appid);
                    ActiontypeVo actiontypeVo = new ActiontypeVo();
                    actiontypeVo.setDeal(Integer.valueOf(1));
                    doActionVo.setActiontype(actiontypeVo);
                    doActionVo.setTaskId(toAction.getTaskId());
                    doActionVos.add(doActionVo);
                }
            }
            mqVo.setDoActionVos((List)doActionVos);
        }
        return mqVo;
    }

    private List<ToDoTaskReqVo> createToDoTask(ActivitiBusinessEntity entity) {
        ArrayList list = Lists.newArrayList();
        List<TaskResInfoVo> taskResInfo = this.activitiBusinessMapper.findTaskResInfo(entity.getProcessInstanceId());
        if (CollectionUtil.listNotEmpty(taskResInfo)) {
            TaskResInfoVo tmpTaskInfoVo = taskResInfo.get(0);
            TaNodeConfigEntity nodeConfigInfo = this.activitiBusinessMapper.findNodeConfigInfo(tmpTaskInfoVo.getTaskId());
            if (nodeConfigInfo == null || nodeConfigInfo.getIsMobile() == null || nodeConfigInfo.getIsMobile() == 0) {
                log.warn("\u5f53\u524d\u8282\u70b9\u4fe1\u606f\u4e0d\u63a8\u9001\u79fb\u52a8\u5ba1\u6279,nodeInfo={}", (Object)(nodeConfigInfo != null ? JSON.toJSONString((Object)nodeConfigInfo) : null));
                return Lists.newArrayList();
            }
            int i = 1;
            for (TaskResInfoVo infoVo : taskResInfo) {
                String positionCode;
                ToDoTaskReqVo reqVo = new ToDoTaskReqVo();
                reqVo.setTaskId(infoVo.getTaskId());
                reqVo.setSourceId(infoVo.getTaskId() + i);
                reqVo.setAppId(this.appid);
                reqVo.setContent(entity.getProcessName());
                reqVo.setHeadImg("https://yunzhijia.com/space/c/photo/load?id=5a2f7ad750f8dd7810e79981");
                reqVo.setItemtitle(entity.getProcessTitle());
                ArrayList openIdVos = Lists.newArrayList();
                TaskOpenIdVo taskOpenIdVo = new TaskOpenIdVo();
                String string = positionCode = com.biz.crm.util.StringUtils.isEmpty((String)infoVo.getAssignee()) ? infoVo.getUserId() : infoVo.getAssignee();
                if (com.biz.crm.util.StringUtils.isEmpty((String)positionCode)) {
                    log.error("\u5f53\u524d\u5f85\u529e\u4efb\u52a1\u6ca1\u6709\u5bf9\u5e94\u7684\u5f85\u529e\u4eba businessKey={}", (Object)entity.getBusinessNo());
                    continue;
                }
                Result userInfoBaicInfoByPositionCode = this.mdmUserFeign.getUserInfoBaicInfoByPositionCode(positionCode);
                MdmUserRespVo mdmUserRespVo = (MdmUserRespVo)ApiResultUtil.objResult((Result)userInfoBaicInfoByPositionCode);
                if (mdmUserRespVo == null) {
                    log.info("\u6839\u636e\u5c97\u4f4d\u7f16\u7801={}\u67e5\u8be2\u5230\u4eba\u5458\u4fe1\u606f\u4e3a\u7a7a", (Object)positionCode);
                    continue;
                }
                taskOpenIdVo.setOpenId(mdmUserRespVo.getExt3());
                openIdVos.add(taskOpenIdVo);
                reqVo.setParams((List)openIdVos);
                reqVo.setSenderId(UserUtils.getUser().getUsername());
                reqVo.setTitle(entity.getProcessName());
                ActRelation actRelation = ActRelation.getActRelation((String)entity.getProcessKey());
                if (actRelation == null) {
                    log.warn("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6d41\u7a0b\u914d\u7f6e\u4fe1\u606f\uff0c\u5f53\u524dcrminstanceId={}", (Object)entity.getCrmProcessInstanceId());
                    continue;
                }
                ActConfig actConfig = actRelation.getActConfig();
                String url = String.format(this.viewHttp, positionCode, infoVo.getBusinessId(), infoVo.getTaskId(), infoVo.getCrmProcessInstanceId(), actConfig.getFlag());
                reqVo.setUrl(url);
                list.add(reqVo);
                ++i;
            }
        }
        return list;
    }

    private void sendData2Mq(ToYzjMqVo yzjMqVo) {
        this.rocketMQTemplate.syncSendOrderly("ACTIVITI_MSG_2_YZJ_TOPIC", MessageBuilder.withPayload((Object)yzjMqVo).build(), "ACTIVITI_MSG_2_YZJ_TOPIC");
    }

    @Transactional(rollbackFor={Exception.class})
    public void rejectBpm(CompleteTaskVo completeTaskVo, String approveOpt) {
        String processInstanceId = this.activitiBusinessService.getByProcessInstanceId(completeTaskVo.getCrmProcessInstanceId()).getProcessInstanceId();
        if (StringUtils.isEmpty((CharSequence)completeTaskVo.getRemarks())) {
            throw new BusinessException("\u8bf7\u8f93\u5165\u9a73\u56de\u5907\u6ce8\u4fe1\u606f");
        }
        this.taskService.addComment(completeTaskVo.getTaskId(), processInstanceId, completeTaskVo.getRemarks());
        this.taskService.setOwner(completeTaskVo.getTaskId(), completeTaskVo.getPositionCode());
        HashMap<String, Object> variable = new HashMap<String, Object>();
        this.activityTaskUtil.setbpmOperation(variable, approveOpt);
        this.goProcessTaskNode(completeTaskVo.getTaskId(), "end", variable, processInstanceId);
    }

    public synchronized void goProcessTaskNode(String taskId, String taskDefinitionKey, Map<String, Object> variables, String processInstanceId) {
        Task taskCurrent = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        List taskList = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).taskDefinitionKey(taskCurrent.getTaskDefinitionKey())).list();
        for (Task task : taskList) {
            this.turnTransition(task.getId(), taskDefinitionKey, variables);
        }
    }

    private void turnTransition(String taskId, String taskDefinitionKey, Map<String, Object> variables) {
        ActivityImpl currActivity = this.findActivitiImpl(taskId, null);
        List<PvmTransition> oriPvmTransitionList = this.activityTaskUtil.clearTransition(currActivity);
        TransitionImpl newTransition = currActivity.createOutgoingTransition();
        ActivityImpl pointActivity = this.findActivitiImpl(taskId, taskDefinitionKey);
        newTransition.setDestination(pointActivity);
        try {
            this.taskService.complete(taskId, variables);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            pointActivity.getIncomingTransitions().remove(newTransition);
            this.activityTaskUtil.restoreTransition(currActivity, oriPvmTransitionList);
        }
    }

    private ActivityImpl findActivitiImpl(String taskId, String activityId) {
        ProcessDefinitionEntity processDefinition = this.activityTaskUtil.findProcessDefinitionEntityByTaskId(taskId);
        if (StringUtils.isEmpty((CharSequence)activityId)) {
            TaskEntity task = (TaskEntity)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            activityId = task.getTaskDefinitionKey();
        }
        if (activityId.toUpperCase().equals("END")) {
            for (ActivityImpl activityImpl : processDefinition.getActivities()) {
                List pvmTransitionList = activityImpl.getOutgoingTransitions();
                if (!pvmTransitionList.isEmpty()) continue;
                return activityImpl;
            }
        }
        ActivityImpl activityImpl = processDefinition.findActivity(activityId);
        return activityImpl;
    }

    @Transactional(rollbackFor={Exception.class})
    public void passBpm(CompleteTaskVo completeTaskVo) {
        UserRedis user = UserUtils.getUser();
        List<TaTaskCommunicateEntity> communicates = this.helper.findCommunicatesByTaskId(completeTaskVo.getTaskId());
        List collect = communicates.stream().filter(o -> StringUtils.equals((CharSequence)GlobalWhetherEnum.YES.getCode(), (CharSequence)o.getIsNeedReply())).filter(o -> Objects.equals(Indicator.COPY_TASK_STATUS_UNREAD.getCode(), o.getStatus())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect)) {
            throw new BusinessException("\u5f53\u524d\u4efb\u52a1\u8fd8\u6709\u672a\u786e\u8ba4\u7684\u6c9f\u901a\u4e8b\u9879,\u4e0d\u80fd\u6267\u884c\u7b7e\u6279\u64cd\u4f5c");
        }
        if (StringUtils.isEmpty((CharSequence)completeTaskVo.getRemarks())) {
            completeTaskVo.setRemarks("\u901a\u8fc7");
        }
        ActivitiBusinessEntity businessEntity = this.activitiBusinessService.getByProcessInstanceId(completeTaskVo.getCrmProcessInstanceId());
        Map variables = completeTaskVo.getVariables();
        variables = variables == null ? new HashMap() : variables;
        Task currentTask = this.helper.findCurrentTaskByTaskId(completeTaskVo.getTaskId());
        this.activityTaskUtil.setbpmOperation(variables, "PASS");
        this.taskService.setVariablesLocal(completeTaskVo.getTaskId(), variables);
        this.taskService.addComment(completeTaskVo.getTaskId(), businessEntity.getProcessInstanceId(), completeTaskVo.getRemarks());
        this.taskService.setOwner(completeTaskVo.getTaskId(), completeTaskVo.getPositionCode());
        this.taskService.complete(completeTaskVo.getTaskId(), variables);
        this.passTaskDoOtherThings(businessEntity.getProcessInstanceId());
        List<Task> nextTasks = this.helper.findCurrentTasksByProcessInstanceId(businessEntity.getProcessInstanceId());
        if (CollectionUtils.isNotEmpty(nextTasks)) {
            Task nextTask = nextTasks.get(0);
            TaNodeConfigEntity currentNode = this.helper.findNodeByProcessVersionKeyAndNodeCode(businessEntity.getProcessVersionKey(), currentTask.getTaskDefinitionKey());
            TaNodeConfigEntity nextNode = this.helper.findNodeByProcessVersionKeyAndNodeCode(businessEntity.getProcessVersionKey(), nextTasks.get(0).getTaskDefinitionKey());
            CompleteTaskVo vo = new CompleteTaskVo();
            vo.setPass(Boolean.valueOf(true));
            List identityLinksForTask = this.taskService.getIdentityLinksForTask(nextTask.getId());
            HashSet queryPosCodes = Sets.newHashSet((Object[])new String[0]);
            HashSet queryBpmRoleCodes = Sets.newHashSet((Object[])new String[0]);
            identityLinksForTask.forEach(o -> {
                if (StringUtils.isNotEmpty((CharSequence)o.getUserId())) {
                    queryPosCodes.add(o.getUserId());
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getGroupId())) {
                    queryBpmRoleCodes.add(o.getGroupId());
                }
            });
            Map<Object, Object> posMap = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty((Collection)queryPosCodes)) {
                posMap = this.helper.findUserByPositionCodes(queryPosCodes).stream().collect(Collectors.toMap(MdmPositionUserOrgRespVo::getPositionCode, Function.identity()));
            }
            HashMap bpmRoleMap = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty((Collection)queryBpmRoleCodes)) {
                queryBpmRoleCodes.forEach(o -> {
                    Set posCodes = (Set)ApiResultUtil.objResult((Result)this.positionFeign.findPositionCodeSetByOrgParentAndBpmRoleCodeList(null, (List)Lists.newArrayList((Object[])new String[]{o})));
                    bpmRoleMap.put(o, posCodes);
                });
            }
            vo.setTaskId(nextTask.getId());
            vo.setCrmProcessInstanceId(businessEntity.getCrmProcessInstanceId());
            if (Objects.equals(1, nextNode.getAuditNullSkip())) {
                Boolean nullSkipFlag = false;
                String nullSkipUserId = "";
                for (IdentityLink link : identityLinksForTask) {
                    Set posCodes;
                    if (StringUtils.isNotEmpty((CharSequence)link.getUserId())) {
                        MdmPositionUserOrgRespVo mdmPositionUserOrgRespVo = (MdmPositionUserOrgRespVo)posMap.get(link.getUserId());
                        if (Objects.nonNull(mdmPositionUserOrgRespVo)) {
                            nullSkipFlag = true;
                            break;
                        }
                        nullSkipUserId = link.getUserId();
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)link.getGroupId()) || !CollectionUtils.isNotEmpty((Collection)(posCodes = (Set)bpmRoleMap.get(link.getGroupId())))) continue;
                    nullSkipFlag = true;
                    break;
                }
                if (!nullSkipFlag.booleanValue()) {
                    if (StringUtils.isEmpty((CharSequence)nullSkipUserId)) {
                        nullSkipUserId = user.getPoscode();
                    }
                    vo.setPositionCode(nullSkipUserId);
                    vo.setRemarks("\u5c97\u4f4d\u6216\u6d41\u7a0b\u89d2\u8272\u5bf9\u5e94\u4eba\u5458\u4e3a\u7a7a,\u81ea\u52a8\u8df3\u8fc7");
                    this.completeTasks(vo);
                }
            }
            if (Objects.equals(1, nextNode.getAuditRepeatSkip())) {
                Boolean flag = false;
                String repeatSkipUserId = "";
                List<ActivitiBpmlogEntity> logs = this.logService.findLogByUserAndCrmProcessInstanceId(businessEntity.getCrmProcessInstanceId());
                Set set = logs.stream().filter(o -> StringUtils.equals((CharSequence)ActivitiOperateTypeEnum.PASS.getCode(), (CharSequence)o.getOperateType())).map(CrmBaseEntity::getCreatePosCode).collect(Collectors.toSet());
                block1: for (IdentityLink link : identityLinksForTask) {
                    Set posCodes;
                    if (StringUtils.isNotEmpty((CharSequence)link.getUserId()) && (set.contains(link.getUserId()) || StringUtils.equals((CharSequence)user.getPoscode(), (CharSequence)link.getUserId()))) {
                        flag = true;
                        repeatSkipUserId = link.getUserId();
                        break;
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)link.getGroupId()) || !CollectionUtils.isNotEmpty((Collection)(posCodes = (Set)bpmRoleMap.get(link.getGroupId())))) continue;
                    for (String posCode : posCodes) {
                        if (!set.contains(posCode)) continue;
                        flag = true;
                        repeatSkipUserId = posCode;
                        continue block1;
                    }
                }
                if (flag.booleanValue()) {
                    vo.setPositionCode(repeatSkipUserId);
                    vo.setRemarks("\u5c97\u4f4d[" + repeatSkipUserId + "]\u91cd\u590d\u5ba1\u6279,\u81ea\u52a8\u8df3\u8fc7");
                    this.completeTasks(vo);
                }
            }
        }
    }

    @Override
    public ProcessSummaryRspVO getProcessSummary(String crmProcessInstanceId) {
        ProcessSummaryRspVO processSummaryRspVO = new ProcessSummaryRspVO();
        ActivitiBusinessEntity activitiBusinessEntity = (ActivitiBusinessEntity)this.activitiBusinessMapper.selectOne((Wrapper)Wrappers.lambdaQuery(ActivitiBusinessEntity.class).eq(ActivitiBusinessEntity::getCrmProcessInstanceId, (Object)crmProcessInstanceId));
        if (Objects.isNull(activitiBusinessEntity)) {
            log.error("\u6d41\u7a0b\u5b9e\u4f8b\u6570\u636e\u4e22\u5931,crmProcessInstanceId={}", (Object)crmProcessInstanceId);
            return processSummaryRspVO;
        }
        processSummaryRspVO.setTitle(activitiBusinessEntity.getProcessTitle());
        processSummaryRspVO.setProcessKey(activitiBusinessEntity.getProcessKey());
        processSummaryRspVO.setProcessNo(activitiBusinessEntity.getCrmProcessInstanceId());
        processSummaryRspVO.setRemarks(activitiBusinessEntity.getRemarks());
        processSummaryRspVO.setProcessName(activitiBusinessEntity.getProcessName());
        processSummaryRspVO.setApplierName(activitiBusinessEntity.getCommitName());
        processSummaryRspVO.setCreateTime(activitiBusinessEntity.getCreateDateAll());
        processSummaryRspVO.setApplierPositionName(activitiBusinessEntity.getCommitPosName());
        List<TaActFileRespVo> files = this.helper.findActFileByProcessInstanceIds(Lists.newArrayList((Object[])new String[]{activitiBusinessEntity.getProcessInstanceId()}), null);
        processSummaryRspVO.setProcessFiles(files);
        List<TaActTargetRespVo> actTargetConfigByProcessKey = this.helper.findActTargetConfigByProcessKey(activitiBusinessEntity.getProcessKey());
        processSummaryRspVO.setTaActTargetRespVos(actTargetConfigByProcessKey);
        if (StringUtils.isNotEmpty((CharSequence)activitiBusinessEntity.getKeyTargetListJson())) {
            try {
                List objects1 = JSONArray.parseArray((String)activitiBusinessEntity.getKeyTargetListJson(), Object.class);
                processSummaryRspVO.setKeyTargetList(objects1);
            }
            catch (Exception e) {
                log.error("{}", (Throwable)e);
                log.error("\u6d41\u7a0b\u5b9e\u4f8b,crmProcessInstanceId=" + crmProcessInstanceId + ",\u5173\u952e\u6307\u6807\u6570\u636e\u5f02\u5e38,\u65e0\u6cd5\u8f6c\u6362\u4e3a\u6570\u7ec4");
            }
        }
        return processSummaryRspVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Klock(keys={"#crmProcessInstanceId"}, waitTime=60L, leaseTime=300L)
    public void recallTasks(String crmProcessInstanceId) {
        UserRedis userRedis = UserUtils.getUser();
        log.info("\u64a4\u56de\u6d41\u7a0b\uff1a" + crmProcessInstanceId);
        ActivitiBusinessEntity activitiBusinessEntity = this.helper.findActivitiBusinessEntityByCrmInstanceId(crmProcessInstanceId);
        AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)ProcessInstanceStatusEnum.ENABLE.getCode(), (CharSequence)activitiBusinessEntity.getProcessInstanceStatus()), (String)"\u5f53\u524d\u6d41\u7a0b\u5b9e\u4f8b\u72b6\u6001\u4e0d\u4e3a\u542f\u7528,\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c");
        ProcessInstance processInstance = this.activityTaskUtil.getProcessInstance(activitiBusinessEntity.getProcessInstanceId(), null);
        if (processInstance == null) {
            throw new BusinessException("\u5f53\u524d\u6d41\u7a0b\u5df2\u7ecf\u7ed3\u675f[" + crmProcessInstanceId + "]");
        }
        this.taskService.addComment(null, activitiBusinessEntity.getProcessInstanceId(), "\u6d41\u7a0b\u64a4\u56de[" + userRedis.getRealname() + "(" + userRedis.getPoscode() + ")]");
        List executionList = this.runtimeService.createExecutionQuery().processInstanceId(activitiBusinessEntity.getProcessInstanceId()).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)executionList)) {
            for (Execution execution : executionList) {
                this.runtimeService.setVariable(execution.getId(), "approveOpt", (Object)"RECOVER");
            }
        }
        this.runtimeService.deleteProcessInstance(activitiBusinessEntity.getProcessInstanceId(), "RECOVER");
        ActivitiBpmlogVo bpmlogVo = ActivitiBpmlogVo.builder().businessId(activitiBusinessEntity.getBusinessId()).businessNo(activitiBusinessEntity.getBusinessNo()).crmProcessInstanceId(activitiBusinessEntity.getCrmProcessInstanceId()).operateType(ActivitiOperateTypeEnum.RECOVER.getCode()).processInstanceId(activitiBusinessEntity.getProcessInstanceId()).build();
        bpmlogVo.setRemarks(this.helper.getProcessOperateLogDesc(ActivitiOperateTypeEnum.RECOVER.getCode(), userRedis.getPoscode(), true));
        this.logService.commomSaveLog(bpmlogVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Klock(keys={"#reqVo.crmProcessInstanceId"}, waitTime=60L, leaseTime=300L)
    public void circulate(ProcessCirculateReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getCrmProcessInstanceId(), (String)"\u6d41\u7a0b\u7f16\u53f7[crmProcessInstanceId]\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((Collection)reqVo.getPositionCodes(), (String)"\u804c\u4f4d\u7f16\u7801\u96c6\u5408[positionCodes]\u4e0d\u80fd\u4e3a\u7a7a");
        ActivitiBusinessEntity businessEntity = this.helper.findActivitiBusinessEntityByCrmInstanceId(reqVo.getCrmProcessInstanceId());
        AssertUtils.isNotNull((Object)businessEntity, (String)("\u6d41\u7a0b\u7f16\u53f7[" + reqVo.getCrmProcessInstanceId() + "],\u5bf9\u5e94\u7684\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u5b58\u5728"));
        List copyTaskEntities = this.copyTaskMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ActivitiCopyTaskEntity.class).eq(ActivitiCopyTaskEntity::getCrmProcessInstanceId, (Object)reqVo.getCrmProcessInstanceId())).in(ActivitiCopyTaskEntity::getPositionCode, (Collection)reqVo.getPositionCodes())).eq(ActivitiCopyTaskEntity::getTaskType, (Object)1));
        Set set = copyTaskEntities.stream().map(ActivitiCopyTaskEntity::getPositionCode).collect(Collectors.toSet());
        List taskEntities = reqVo.getPositionCodes().stream().distinct().filter(o -> !set.contains(o)).map(positionCode -> {
            ActivitiCopyTaskEntity copyTaskEntity = new ActivitiCopyTaskEntity();
            copyTaskEntity.setTaskType(ActivityCopyTaskTypeEnum.CIRCULATE.getCode());
            copyTaskEntity.setCrmProcessInstanceId(reqVo.getCrmProcessInstanceId());
            copyTaskEntity.setReadStatus(GlobalWhetherEnum.NO.getCode());
            copyTaskEntity.setProcessKey(businessEntity.getProcessKey());
            copyTaskEntity.setPositionCode(positionCode);
            return copyTaskEntity;
        }).collect(Collectors.toList());
        this.copyTaskService.saveBatch(taskEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateCopyTaskStatus(String id) {
        AssertUtils.isNotEmpty((String)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        ActivitiCopyTaskEntity activitiCopyTaskEntity = (ActivitiCopyTaskEntity)this.copyTaskMapper.selectOne((Wrapper)Wrappers.lambdaQuery(ActivitiCopyTaskEntity.class).eq(BaseIdEntity::getId, (Object)id));
        AssertUtils.isNotNull((Object)activitiCopyTaskEntity, (String)("\u4efb\u52a1\u6570\u636e\u4e0d\u5b58\u5728,id=" + id));
        if (!StringUtils.equals((CharSequence)GlobalWhetherEnum.YES.getCode(), (CharSequence)activitiCopyTaskEntity.getReadStatus())) {
            activitiCopyTaskEntity.setReadStatus(GlobalWhetherEnum.YES.getCode());
            this.copyTaskMapper.updateById(activitiCopyTaskEntity);
        }
    }

    private void checkUserOperatePermission(String processVersionKey, String nodeCode, IndicatorStr operateTypeEnum) {
        TaNodeConfigEntity taNodeConfigEntity = this.helper.findNodeByProcessVersionKeyAndNodeCode(processVersionKey, nodeCode);
        AssertUtils.isNotNull((Object)taNodeConfigEntity, (String)"\u8282\u70b9\u6570\u636e\u4e0d\u5b58\u5728,\u8bf7\u91cd\u65b0\u53d1\u5e03\u6d41\u7a0b");
        AssertUtils.isNotEmpty((String)taNodeConfigEntity.getBtnAuthRoleId(), (String)"\u5f53\u524d\u8282\u70b9\u672a\u914d\u7f6e\u6309\u94ae\u6743\u9650");
        TaFuncRoleEntity funcRoleEntity = (TaFuncRoleEntity)this.funcRoleMapper.selectById((Serializable)((Object)taNodeConfigEntity.getBtnAuthRoleId()));
        List<OptBtnVO> optBtnVOS = this.helper.parseBtnList(funcRoleEntity.getRoleAuths());
        Set set = optBtnVOS.stream().map(OptBtnVO::getBtnCode).collect(Collectors.toSet());
        if (!set.contains(operateTypeEnum.getCode())) {
            throw new BusinessException("\u5f53\u524d\u8282\u70b9\u6ca1\u6709\u8bbe\u7f6e:" + operateTypeEnum.getLabel() + ",\u6743\u9650");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Klock(keys={"#reqVo.taskId"}, waitTime=60L, leaseTime=300L)
    public void delegateProcess(TaActDelegateReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getDelegatePositionCode(), (String)"\u59d4\u6d3e\u5c97\u4f4d\u7f16\u7801[delegatePositionCode]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.isNotEmpty((String)reqVo.getTaskId(), (String)"\u59d4\u6d3e\u4efb\u52a1Id[taskId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.isNotEmpty((String)reqVo.getCrmProcessInstanceId(), (String)"\u6d41\u7a0b\u7f16\u7801[crmProcessInstanceId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        MdmPositionRespVo position = PositionUtil.getPositionByCode((String)reqVo.getDelegatePositionCode());
        AssertUtils.isNotNull((Object)position, (String)("\u59d4\u6d3e\u804c\u4f4d\u5df2\u4e0d\u5b58\u5728:" + reqVo.getDelegatePositionCode()));
        ActivitiBusinessEntity businessEntity = this.helper.findActivitiBusinessEntityByCrmInstanceId(reqVo.getCrmProcessInstanceId());
        Task task = this.helper.findCurrentTaskByTaskId(reqVo.getTaskId());
        AssertUtils.isNotNull((Object)task, (String)"\u5f53\u524d\u4efb\u52a1\u5df2\u7ecf\u4e0d\u5b58\u5728,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
        this.checkUserOperatePermission(businessEntity.getProcessVersionKey(), task.getTaskDefinitionKey(), IndicatorStr.PROCESS_BTN_TURN);
        task.setAssignee(reqVo.getDelegatePositionCode());
        this.taskService.saveTask(task);
        UserRedis user = UserUtils.getUser();
        TaNodeConfigEntity nodeConfigEntity = this.helper.findNodeByProcessVersionKeyAndNodeCode(businessEntity.getProcessVersionKey(), task.getTaskDefinitionKey());
        ActivitiBpmlogVo bpmlogVo = ActivitiBpmlogVo.builder().businessId(businessEntity.getBusinessId()).businessNo(businessEntity.getBusinessNo()).crmProcessInstanceId(businessEntity.getCrmProcessInstanceId()).operateType(ActivitiOperateTypeEnum.DELEGATE.getCode()).taskId(reqVo.getTaskId()).processInstanceId(task.getProcessInstanceId()).nodeName(task.getName()).nodeCode(task.getTaskDefinitionKey()).nodeId(Objects.nonNull(nodeConfigEntity) ? nodeConfigEntity.getProcessNodeId() : null).build();
        bpmlogVo.setRemarks(this.helper.getProcessOperateLogDesc(ActivitiOperateTypeEnum.DELEGATE.getCode(), user.getPoscode(), false) + ":" + position.getPositionName() + "[" + position.getPositionCode() + "]");
        this.logService.commomSaveLog(bpmlogVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void rejectTaskDoOtherThings(String processInstanceId) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void passTaskDoOtherThings(String processInstanceId) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void startProcessDoOtherThings(String processInstanceId) {
    }
}

