/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.netflix.eureka.EnableEurekaClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

@SpringBootApplication
@EnableEurekaClient
@EnableFeignClients
@MapperScan(value={"com.biz.crm.**.mapper*"})
public class ActivitiApplication {
    private static final Logger log = LoggerFactory.getLogger(ActivitiApplication.class);

    public static void main(String[] args) throws UnknownHostException {
        System.setProperty("es.set.netty.runtime.available.processors", "false");
        ConfigurableApplicationContext application = SpringApplication.run(ActivitiApplication.class, (String[])args);
        ConfigurableEnvironment env = application.getEnvironment();
        String ip = InetAddress.getLocalHost().getHostAddress();
        String port = env.getProperty("server.port");
        String path = env.getProperty("server.servlet.context-path");
        log.info("\n----------------------------------------------------------\n\tApplication crm-activiti is running! Access URLs:\n\t\u672c\u5730\u8bbf\u95ee\u5730\u5740: \t\thttp://localhost:" + port + path + "/\n\tswagger\u5730\u5740: \t\thttp://localhost:" + port + path + "/doc.html\n----------------------------------------------------------");
    }
}

