package com.biz.crm.activiti.controller;

import com.biz.crm.activiti.service.ActivitiTaskService;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.nebular.activiti.task.req.FormParamQueryReqVO;
import com.biz.crm.nebular.activiti.task.resp.*;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import java.util.List;
import java.util.Map;

/**
 * @author jerry7
 * @date 2020-12-10 09:54:27
 */
@RestController
@RequestMapping("activitiProcessController")
@Api(tags = "工作流流程信息查询相关接口")
public class ActivitiProcessController {

    @Autowired
    private ActivitiTaskService activitiTaskService;

//    @ApiOperation(value = "查询流程详细信息")
//    @PostMapping("/getProcessInfo")
//    @CrmLog
//    public Result<ProcessInfoRspVO> getProcessInfo(@RequestBody ProcessInfoReqVO processInfoReqVO) {
//        AssertUtils.isTrue(StringUtils.isNotEmpty(processInfoReqVO.getProcessInstanceId())
//                || (StringUtils.isNotEmpty(processInfoReqVO.getFormNo()) && StringUtils.isNotEmpty(processInfoReqVO.getCostType())
//                && StringUtils.isNotEmpty(processInfoReqVO.getFormType())
//                || StringUtils.isNotEmpty(processInfoReqVO.getProcessNo())), "节点ID流程实例ID或表单业务信息不能都为空");
//
//        return Result.ok(iActivitiMyTaskService.getProcessInfo(processInfoReqVO));
//    }

    @ApiOperation(value = "查询流程表单参数")
    @PostMapping("/getProcessFormParam")
    @CrmLog
    public Result<FormParamQueryRspVO> getProcessFormParam(@RequestBody FormParamQueryReqVO formParamQueryReqVO) {
        return Result.ok(activitiTaskService.getProcessFormParam(formParamQueryReqVO));
    }

    @ApiOperation(value = "查询流程文件以及详情")
    @GetMapping("/getProcessFileInfo")
    @CrmLog
    public Result<ProcessFileInfoRspVO> getProcessFileInfo(@RequestParam("businessId") String businessId) {
        AssertUtils.isNotEmpty(businessId,"businessId不能为空");
        return Result.ok(activitiTaskService.getProcessFileInfo(businessId));
    }

//    @ApiOperation(value = "查询抄送给我的任务")
//    @PostMapping("/findMyCopyTask")
//    @CrmLog
//    public Result<PageResult<CopyTaskRspVO>> findMyCopyTask(@RequestBody CopyTaskReqVO copyTaskReqVO) {
//        AssertUtils.isTrue(StringUtils.isNotEmpty(copyTaskReqVO.getUserCode()) || StringUtils.isNotEmpty(copyTaskReqVO.getPositionCodes())
//                , "用户和岗位不能都为空!");
//        PageResult<CopyTaskRspVO> page = taTaskCopyService.findMyCopyTask(copyTaskReqVO);
//        return Result.ok(page);
//    }
//
//    @ApiOperation(value = "查询抄送任务数量统计")
//    @PostMapping("/countCopyTask")
//    @CrmLog
//    public Result<Integer> countCopyTask(@RequestBody CopyTaskReqVO copyTaskReqVO) {
//        Integer count = taTaskCopyService.countCopyTask(copyTaskReqVO);
//        return Result.ok(count);
//    }

}
