package com.biz.crm.activiti.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.activiti.entity.ActReModelEntity;
import com.biz.crm.activiti.mapper.ActReModelMapper;
import com.biz.crm.activiti.service.OperateActivitiService;
import com.biz.crm.nebular.activiti.vo.ActReModel;
import com.biz.crm.nebular.activiti.vo.ListByKeyVo;
import com.biz.crm.vo.ReProcdef;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.editor.language.json.converter.BpmnJsonConverter;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.Model;
import org.activiti.engine.repository.ProcessDefinition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.activiti.controller
 * @Description: TODO
 * @date 2021/4/20 下午1:26
 */
@Api(value = "工作流设计", tags = "工作流设计")
@RestController
@RequestMapping("/operateActivitiController")
@Slf4j
public class OperateActivitiController {
    @Autowired
    private OperateActivitiService operateActivitiService;


    @CrmLog
    @ApiOperation(value = "分页查询所有设计流程")
    @PostMapping(value = "list")
    public Result<PageResult<ActReModel>> list(@RequestBody ActReModel actReModel) {
        return Result.ok(operateActivitiService.list(actReModel));
    }

    /**
     * 发布模型为流程定义
     * @param id
     * @return
     * @throws Exception
     */
    @ApiOperation(value = "流程发布")
    @GetMapping(value = "deployment")
    @CrmLog
    public Result deployment(@RequestParam("id") String id){
        operateActivitiService.deployment(id);
        return Result.ok("发布成功");
    }


    @CrmLog
    @ApiOperation(value = "根据流程定义KEY查询流程历史版本号")
    @PostMapping(value = "listByKey")
    public Result<PageResult<ReProcdef>> listByKey(@RequestBody ListByKeyVo listByKeyVo) {
        PageResult<ReProcdef> pageData = operateActivitiService.listByKey(listByKeyVo);
        return Result.ok(pageData);
    }

    @ApiOperation(value = "批量删除流程模型", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        operateActivitiService.deleteBatchModel(ids);
        return Result.ok("删除成功");
    }


}
