package com.biz.crm.activiti.controller;

import com.biz.crm.activiti.service.ReceiveMdmService;
import com.biz.crm.activiti.user.GroupActivitiVo;
import com.biz.crm.activiti.user.MembershipActivitiVo;
import com.biz.crm.activiti.user.UserActivitiVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.ProcessEngines;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.eisp.api.controller
 * @Description: TODO
 * @date 2019/11/21 下午4:07
 */
@RestController
@RequestMapping(value = "/receiveMdmController")
@Api(value = "同步MDM主数据", tags = "同步MDM主数据")
@Slf4j
public class ReceiveMdmController {
    @Autowired
    private ReceiveMdmService receiveMdmService;

    /**
     * 修改与更新用户
     *
     * @param userActivitiVo
     * @return
     */
    @ApiOperation(value = "修改与更新用户")
    @PostMapping(value = "saveUser")
    public Result saveUser(@RequestBody UserActivitiVo userActivitiVo) {
        Result result = new Result();
        receiveMdmService.saveUser(userActivitiVo);
        return result;
    }

    /**
     * 删除用户
     *
     * @param username
     * @return
     */
    @ApiOperation(value = "删除用户")
    @PostMapping(value = "deleteUser")
    public Result deleteUser(@RequestParam("username") String username) {
        Result result = new Result();
        ProcessEngine engine = ProcessEngines.getDefaultProcessEngine();
        IdentityService identityService = engine.getIdentityService();
        identityService.deleteUser(username);
        return result;
    }

    /**
     * 保存修改用户组
     *
     * @param groupActivitiVo
     * @return
     */
    @ApiOperation(value = "保存修改用户组")
    @PostMapping(value = "saveUserGroup")
    public Result saveUserGroup(@RequestBody GroupActivitiVo groupActivitiVo) {
        Result result = new Result();
        receiveMdmService.saveGroup(groupActivitiVo);
        return result;
    }

    /**
     * 删除用户组
     *
     * @param type
     * @returnPost
     */
    @ApiOperation(value = "删除用户组")
    @PostMapping(value = "deleteGroup")
    public Result deleteGroup(@RequestParam("type") String type) {
        Result result = new Result();
        ProcessEngine engine = ProcessEngines.getDefaultProcessEngine();
        IdentityService identityService = engine.getIdentityService();
        identityService.deleteGroup(type);
        return result;
    }

    /**
     * 保存用户与用户组关系
     * @param membershipActivitiVos
     * @return
     */
    @ApiOperation(value = "保存用户与用户组关系")
    @PostMapping(value = "saveMembership")
    public Result saveMembership(@RequestBody List<MembershipActivitiVo> membershipActivitiVos) {
        Result result = new Result();
        membershipActivitiVos.forEach(item->{
            receiveMdmService.saveMembership(item);
        });
        return result;
    }
    /**
     * 删除用户与用户组关系
     * @param membershipActivitiVos
     * @return
     */
    @ApiOperation(value = "删除用户与用户组关系")
    @PostMapping(value = "deleteMembership")
    public Result deleteMembership(@RequestBody List<MembershipActivitiVo> membershipActivitiVos) {
        Result result = new Result();
        ProcessEngine engine = ProcessEngines.getDefaultProcessEngine();
        IdentityService identityService = engine.getIdentityService();
        membershipActivitiVos.forEach(item->{
            identityService.deleteMembership(item.getPosCode(),item.getBpmRoleCode());
        });
        return result;
    }


}
