package com.biz.crm.activiti.controller;

import com.biz.crm.activiti.service.BizRuntimeService;
import com.biz.crm.activiti.service.ITaFuncRoleService;
import com.biz.crm.activiti.service.ITaNodeConfigService;
import com.biz.crm.activiti.service.ITaTaskCommunicateService;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.bpmlog.service.ActivitiBpmlogService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.activiti.IndicatorStr;
import com.biz.crm.nebular.activiti.act.req.ConfirmCommunicateReqVO;
import com.biz.crm.nebular.activiti.act.req.TaActDelegateReqVo;
import com.biz.crm.nebular.activiti.act.req.TaskCommunicateReqVO;
import com.biz.crm.nebular.activiti.design.resp.OptBtnVO;
import com.biz.crm.nebular.activiti.start.req.OptRecordReqVO;
import com.biz.crm.nebular.activiti.start.req.ProcessInfoReqVO;
import com.biz.crm.nebular.activiti.task.resp.OptLogsRspVO;
import com.biz.crm.nebular.activiti.task.resp.ProcessSummaryRspVO;
import com.biz.crm.nebular.activiti.vo.*;
import com.biz.crm.util.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import java.util.List;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.activiti.controller
 * @Description: TODO
 * @date 2021/4/20 下午6:32
 */
@Api(value = "流程业务处理", tags = "流程业务处理")
@RestController
@RequestMapping("/runtimeController")
@Slf4j
public class RuntimeController {
    @Autowired
    private BizRuntimeService bizRuntimeService;
    @Autowired
    private ActivitiBpmlogService bpmlogService;
    @Autowired
    private ITaNodeConfigService nodeConfigService;
    @Autowired
    private ITaTaskCommunicateService communicateService;

    @CrmLog
    @ApiOperation(value = "发起流程")
    @PostMapping(value = "startProcess")
    public Result<String> startProcess(@RequestBody ActivitiBusinessVo activitiBusinessVo) {
        Result<String> result = new Result<>();
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null) {
            String menuCode = requestAttributes.getRequest().getHeader(IndicatorStr.MENU_CODE.getCode());
//            AssertUtils.isNotEmpty(menuCode,"发起流程时,请求头菜单编码[menuCode]不能为空");
            if (StringUtils.isNotEmpty(menuCode)) {
                activitiBusinessVo.setMenuCode(menuCode);
            }
        }
        if (StringUtils.isEmpty(activitiBusinessVo.getPositionCode())) {
            UserRedis userRedis = UserUtils.getUser();
            activitiBusinessVo.setPositionCode(userRedis.getPoscode());
        }
        if (StringUtils.isEmpty(activitiBusinessVo.getBusinessId())) {
            result.error500("业务对象不能为空【businessId】");
            return result;
        }
        String processInstId = bizRuntimeService.startProcess(activitiBusinessVo);
        result.setResult(processInstId);
        return result;
    }

    @ApiOperation(value = "查询待办任务", notes = "查询待办任务")
    @PostMapping(value = "listByPositionCode")
    public Result<PageResult<CurrentTaskVo>> listByPositionCode(@RequestBody BpmQueryVo bpmQueryVo) {
        return Result.ok(bizRuntimeService.listByPositionCode(bpmQueryVo));
    }

    @ApiOperation(value = "我提交的流程(查询已发)")
    @PostMapping(value = "listMyBpm")
    public Result<PageResult<CurrentTaskVo>> listMyBpm(@RequestBody BpmQueryVo bpmQueryVo) {
        return Result.ok(bizRuntimeService.listMyBpm(bpmQueryVo));
    }

    @ApiOperation(value = "我被驳回的流程")
    @PostMapping(value = "listMyRejectBpm")
    public Result<PageResult<CurrentTaskVo>> listMyRejectBpm(@RequestBody BpmQueryVo bpmQueryVo) {
        return Result.ok(bizRuntimeService.listMyRejectBpm(bpmQueryVo));
    }

    @ApiOperation(value = "审批通过/驳回发起人")
    @PostMapping(value = "completeTasks")
    @CrmLog
    public Result completeTasks(@RequestBody CompleteTaskVo completeTaskVo) {
        bizRuntimeService.completeTasks(completeTaskVo);
        return Result.ok();
    }

    @ApiOperation(value = "获取流程摘要信息(传入流程实例id)")
    @GetMapping("/getProcessSummary")
    @CrmLog
    public Result<ProcessSummaryRspVO> getProcessSummary(@RequestParam("crmProcessInstanceId") String crmProcessInstanceId) {
        AssertUtils.isNotEmpty(crmProcessInstanceId, "流程编码不能为空");
        return Result.ok(bizRuntimeService.getProcessSummary(crmProcessInstanceId));
    }

    @ApiOperation(value = "获取流程日志(可接收参数1.流程实例id--processInstanceId,2.流程编号processNo,业务表单主键:formNo)")
    @PostMapping("/getOptLogs")
    @CrmLog
    public Result<List<OptLogsRspVO>> getOptLogs(@RequestBody OptRecordReqVO optRecordReqVO) {
        List<OptLogsRspVO> list = bpmlogService.getOptLogs(optRecordReqVO);
        return Result.ok(list);
    }
    @ApiOperation(value = "获取流程日志(可接收参数1.流程实例id--processInstanceId,2.流程编号processNo,业务表单主键:formNo),按照时间正序排列")
    @PostMapping("/getOptLogsOrderAsc")
    @CrmLog
    public Result<List<OptLogsRspVO>> getOptLogsOrderAsc(@RequestBody OptRecordReqVO optRecordReqVO) {
        List<OptLogsRspVO> list = bpmlogService.getOptLogsOrderAsc(optRecordReqVO);
        return Result.ok(list);
    }

    @ApiOperation(value = "撤回/关闭/流程追回")
    @GetMapping(value = "recallTasks")
    @CrmLog
    public Result recallTasks(@RequestParam("crmProcessInstanceId") String crmProcessInstanceId) {
        bizRuntimeService.recallTasks(crmProcessInstanceId);
        return Result.ok("操作成功");
    }

    @ApiOperation(value = "传阅")
    @PostMapping(value = "circulate")
    @CrmLog
    public Result circulate(@RequestBody ProcessCirculateReqVo reqVo) {
        bizRuntimeService.circulate(reqVo);
        return Result.ok("操作成功");
    }

    @ApiOperation(value = "抄送已阅操作接口")
    @GetMapping(value = "updateCopyTaskStatus")
    @CrmLog
    public Result updateCopyTaskStatus(@RequestParam("id") String id) {
        bizRuntimeService.updateCopyTaskStatus(id);
        return Result.ok("操作成功");
    }

    @ApiOperation(value = "获取流程对应的按钮权限数据(传入流程实例id)")
    @PostMapping("/getButtons")
    @CrmLog
    public Result<List<OptBtnVO>> getButtonsByCrmProcessInstanceId(@RequestBody ProcessInfoReqVO reqVo) {
        return Result.ok(nodeConfigService.getButtonsByCrmProcessInstanceId(reqVo));
    }

    @ApiOperation(value = "发起沟通")
    @PostMapping("/communicateTo")
    @CrmLog
    public Result communicateTo(@RequestBody TaskCommunicateReqVO taskCommunicateReqVO) {
        communicateService.communicateTo(taskCommunicateReqVO);
        return Result.ok("操作成功");
    }

    @ApiOperation(value = "确认沟通")
    @PostMapping("/confirmCommunicate")
    @CrmLog
    public Result confirmCommunicate(@RequestBody ConfirmCommunicateReqVO confirmCommunicateReqVO) {
        communicateService.confirmCommunicate(confirmCommunicateReqVO);
        return Result.ok("操作成功");
    }

    @ApiOperation(value = "委派/转办")
    @PostMapping("/delegate")
    @CrmLog
    public Result delegate(@RequestBody TaActDelegateReqVo taActDelegateReqVo) {
        bizRuntimeService.delegateProcess(taActDelegateReqVo);
        return Result.ok("委派成功");
    }
}
