package com.biz.crm.activiti.controller;

import com.biz.crm.activiti.service.ITaActFileService;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.activiti.act.req.TaActFileReqVo;
import com.biz.crm.nebular.activiti.act.resp.TaActFileRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 工作流文件接口
 *
 * @author jerry7
 * @date 2021-01-14 18:17:13
 */
@Slf4j
@RestController
@RequestMapping("/taactfile")
@Api(tags = "工作流文件")
public class TaActFileController {
    @Autowired
    private ITaActFileService taActFileService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TaActFileRespVo>> list(@RequestBody TaActFileReqVo taActFileReqVo) {
        PageResult<TaActFileRespVo> result=taActFileService.findList(taActFileReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<TaActFileRespVo> query(@RequestBody TaActFileReqVo taActFileReqVo) {
        TaActFileRespVo respVo=taActFileService.query(taActFileReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody TaActFileReqVo taActFileReqVo) {
        taActFileService.save(taActFileReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody TaActFileReqVo taActFileReqVo) {
        taActFileService.update(taActFileReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody TaActFileReqVo taActFileReqVo) {
        taActFileService.deleteBatch(taActFileReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody TaActFileReqVo taActFileReqVo) {
        taActFileService.enableBatch(taActFileReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody TaActFileReqVo taActFileReqVo) {
        taActFileService.disableBatch(taActFileReqVo);
        return Result.ok("禁用成功");
    }
}
