package com.biz.crm.activiti.controller;

import com.biz.crm.activiti.service.ITaActTargetService;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.activiti.act.req.TaActTargetReqVo;
import com.biz.crm.nebular.activiti.act.resp.TaActTargetRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * 工作流文件接口
 *
 * @author jerry7
 * @date 2021-01-14 18:17:13
 */
@Slf4j
@RestController
@RequestMapping("/taacttarget")
@Api(tags = "工作流指标")
public class TaActTargetController {
    
    @Autowired
    private ITaActTargetService taActTargetService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TaActTargetRespVo>> list(@RequestBody TaActTargetReqVo taActFileReqVo) {
        PageResult<TaActTargetRespVo> result=taActTargetService.findList(taActFileReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @GetMapping("/query")
    @CrmLog
    public Result<TaActTargetRespVo> query(@RequestParam("id") String id) {
        TaActTargetRespVo respVo=taActTargetService.query(id);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody TaActTargetReqVo taActFileReqVo) {
        AssertUtils.isNotEmpty(taActFileReqVo.getProcessKey(),"processKey不能为空");
        taActTargetService.save(taActFileReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody TaActTargetReqVo taActFileReqVo) {
        taActTargetService.update(taActFileReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        taActTargetService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody TaActTargetReqVo taActFileReqVo) {
        taActTargetService.enableBatch(taActFileReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody TaActTargetReqVo taActFileReqVo) {
        taActTargetService.disableBatch(taActFileReqVo);
        return Result.ok("禁用成功");
    }
}
