package com.biz.crm.activiti.controller;

import com.biz.crm.activiti.entity.TaFuncRoleEntity;
import com.biz.crm.activiti.service.ITaFuncRoleService;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.activiti.ColumnStr;
import com.biz.crm.nebular.activiti.design.req.TaFuncRoleQueryReqVO;
import com.biz.crm.nebular.activiti.design.req.TaFuncRoleReqVO;
import com.biz.crm.nebular.activiti.design.resp.OptBtnVO;
import com.biz.crm.nebular.activiti.design.resp.TaFuncRoleRespVO;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author weston
 * @date 2020-12-10
 */
@Slf4j
@RestController
@RequestMapping("/taFuncRoleController")
@Api(tags = "流程按钮角色权限维护")
public class TaFuncRoleController {
    @Autowired
    private ITaFuncRoleService taFuncRoleService;

    @ApiOperation(value = "查询列表")
    @PostMapping("/findBtnRolePage")
    @CrmLog
    public Result<PageResult<TaFuncRoleRespVO>> findBtnRolePage(@RequestBody TaFuncRoleQueryReqVO taFuncRoleQueryReqVO){
        PageResult<TaFuncRoleRespVO> pageResult = taFuncRoleService.findFuncRolePage(taFuncRoleQueryReqVO);
        return Result.ok(pageResult);
    }

    @ApiOperation(value = "根据ID获取")
    @PostMapping("/getBtnRoleById")
    @CrmLog
    public Result<TaFuncRoleRespVO> getById(@RequestParam(value = "id", required = true) String id){
        TaFuncRoleEntity entity = taFuncRoleService.getById(id);
        TaFuncRoleRespVO respVO = new TaFuncRoleRespVO();
        BeanUtils.copyProperties(entity, respVO);
        return Result.ok(respVO);
    }

    @ApiOperation(value = "获取所有的按钮")
    @PostMapping("/getAllBtn")
    @CrmLog
    public Result<List<OptBtnVO>> getAllBtn(){
        List<OptBtnVO> btnList = new ArrayList<>();
        Map<String, String> btnMap = ColumnStr.PROCESS_BTN.getCodesAndLabels();
        for (Map.Entry<String, String> entry : btnMap.entrySet()) {
            OptBtnVO btnVO = new OptBtnVO();
            btnVO.setBtnCode(entry.getKey());
            btnVO.setBtnName(entry.getValue());
            btnList.add(btnVO);
        }
        return Result.ok(btnList);
    }

    @ApiOperation(value = "获取所有的按钮权限组合")
    @PostMapping("/getAllBtnRole")
    @CrmLog
    public Result<List<TaFuncRoleRespVO>> getAllBtnRole(){
        List<TaFuncRoleRespVO> respVOS = taFuncRoleService.findAll();
        return Result.ok(respVOS);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/saveBtnRole")
    @CrmLog
    public Result save(@RequestBody TaFuncRoleReqVO taFuncRoleReqVO) {
        checkBtnRoleParam(taFuncRoleReqVO);
        TaFuncRoleEntity entity = new TaFuncRoleEntity();
        BeanUtils.copyProperties(taFuncRoleReqVO, entity);
        taFuncRoleService.save(entity);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/updateBtnRoleById")
    @CrmLog
    public Result update(@RequestBody TaFuncRoleReqVO taFuncRoleReqVO) {
        AssertUtils.isNotEmpty(taFuncRoleReqVO.getId(), "Id不能为空!");
        AssertUtils.isNotEmpty(taFuncRoleReqVO.getRoleAuths(), "功能角色按钮组合不能为空!");
        checkBtnRoleParam(taFuncRoleReqVO);
        TaFuncRoleEntity entity = taFuncRoleService.getById(taFuncRoleReqVO.getId());
        entity.setRoleCode(taFuncRoleReqVO.getRoleCode());
        entity.setRoleName(taFuncRoleReqVO.getRoleName());
        entity.setRoleAuths(taFuncRoleReqVO.getRoleAuths());
        taFuncRoleService.updateById(entity);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/deleteBtnRoleById")
    @CrmLog
    public Result delete(@RequestParam(value = "id", required = true) String id) {
        taFuncRoleService.removeById(id);
        return Result.ok("删除成功");
    }

    /**
     * 批量删除
     */
    @ApiOperation(value = "批量删除")
    @PostMapping("/BtnRole")
    @CrmLog
    public Result deleteBtnRoleBatch(@RequestBody List<String> ids) {
        taFuncRoleService.removeByIds(ids);
        return Result.ok("删除成功");
    }

    private void checkBtnRoleParam(TaFuncRoleReqVO taFuncRoleReqVO){
        AssertUtils.isNotEmpty(taFuncRoleReqVO.getRoleCode(), "功能角色编码不能为空!");
        AssertUtils.isNotEmpty(taFuncRoleReqVO.getRoleName(), "功能角色名称不能为空!");

        if(StringUtils.isNotEmpty(taFuncRoleReqVO.getRoleAuths())){
            String[] btnList = taFuncRoleReqVO.getRoleAuths().split(",");
            for (int i = 0; i < btnList.length; i++) {
                AssertUtils.isTrue(btnList[i].contains("BTN_"),"包含非法的按钮编码!");
            }
        }
    }
}
