package com.biz.crm.activiti.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.activiti.entity.ActReModelEntity;
import com.biz.crm.nebular.activiti.vo.ActGeByteArrayVo;
import com.biz.crm.nebular.activiti.vo.ActReModel;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.activiti.mapper
 * @Description: TODO
 * @date 2021/4/20 下午1:34
 */
@Mapper
public interface ActReModelMapper extends BaseMapper<ActReModelEntity>{
    /**
     * 分页查询所有流程
     * @param page
     * @param actReModel
     * @return
     */
    List<ActReModel> listPage(Page page, @Param("vo") ActReModel actReModel);

    /**
     * 根据名字或者key查询定义流程
     * @param name
     * @param key
     * @return
     */
    ActReModel getByNameOrKey(@Param("name")String name,@Param("key")String key);

    /**
     * 根据流程部署id查询流程xml文件
     * @param deploymentId
     * @return
     */
    ActGeByteArrayVo findProcessXmlByDeploymentId(@Param("deploymentId")String deploymentId);
}
