package com.biz.crm.activiti.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.activiti.entity.ActivitiBusinessEntity;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.activiti.vo.ProcessInstanceQueryReqVo;
import com.biz.crm.nebular.activiti.vo.ProcessInstanceQueryRespVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.activiti.mapper
 * @Description: TODO
 * @date 2021/4/20 下午1:34
 */
public interface ActivitiBusinessMapper extends BaseMapper<ActivitiBusinessEntity> {

    /**
     * 分页查询流程实例
     * @param page
     * @param reqVo
     * @return
     */
    @SqlPrivilege(posCode = "a.create_pos_code",orgCode = "a.create_org_code")
    List<ProcessInstanceQueryRespVo> processInstancePage(Page<ProcessInstanceQueryRespVo> page, @Param("vo") ProcessInstanceQueryReqVo reqVo);

    /**
     * 分页查询已办列表
     * @param page
     * @param reqVo
     * @return
     */
    List<ProcessInstanceQueryRespVo> taskDonePage(Page<ProcessInstanceQueryRespVo> page, @Param("vo")ProcessInstanceQueryReqVo reqVo);
}
