package com.biz.crm.activiti.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.activiti.entity.TaActFileEntity;
import com.biz.crm.nebular.activiti.act.req.TaActFileReqVo;
import com.biz.crm.nebular.activiti.act.resp.TaActFileRespVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author jerry7
 * 流程文件mapper
 * @date 2021-01-14 18:17:13
 */
public interface TaActFileMapper extends BaseMapper<TaActFileEntity> {
    /**
     * 列表
     *
     * @param page           分页数据
     * @param taActFileReqVo 获取文件请求
     * @return 文件列表
     */
    List<TaActFileRespVo> findList(Page<TaActFileRespVo> page, @Param("vo") TaActFileReqVo taActFileReqVo);

    /**
     * 获取文件列表
     *
     * @param taActFileReqVo 获取文件请求
     * @return 文件列表
     */
    List<TaActFileRespVo> findFiles(@Param("vo") TaActFileReqVo taActFileReqVo);

    void deleteByProcessInstIdAndType(@Param("processInstId") String processInstId, @Param("fileType") int fileType);

}
