package com.biz.crm.activiti.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.activiti.entity.TaFuncRoleEntity;
import com.biz.crm.nebular.activiti.design.req.TaFuncRoleQueryReqVO;
import com.biz.crm.nebular.activiti.design.resp.TaFuncRoleRespVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author weston
 * @date 2020-12-10
 */
public interface TaFuncRoleMapper extends BaseMapper<TaFuncRoleEntity> {

    /**
     * 分页列表
     * @param page
     * @param vo
     * @return
     */
    List<TaFuncRoleRespVO> findList(Page<TaFuncRoleRespVO> page, @Param("vo") TaFuncRoleQueryReqVO vo);

    /**
     * 查出所有，不分页
     * @return
     */
    List<TaFuncRoleRespVO> findAll();


    /**
     * 根据code获取
     * @param code
     * @return
     */
    TaFuncRoleEntity findByCode(String code);
}
