package com.biz.crm.activiti.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.activiti.entity.ActivitiBusinessEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.activiti.vo.ActivitiBusinessVo;
import com.biz.crm.nebular.activiti.vo.ProcessInstanceQueryReqVo;
import com.biz.crm.nebular.activiti.vo.ProcessInstanceQueryRespVo;
import org.activiti.engine.runtime.ProcessInstance;

import java.util.List;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.activiti.service
 * @Description: TODO
 * @date 2021/4/22 下午3:03
 */
public interface ActivitiBusinessService extends IService<ActivitiBusinessEntity> {
    /**
     * 保存流程实例相关数据
     * @param processInstanceId
     * @param activitiBusinessVo
     * @return
     */
    ActivitiBusinessEntity save(ProcessInstance processInstance, ActivitiBusinessVo activitiBusinessVo );

    /**
     * 根据业务工作流编号获取工作流id
     * @param crmProcessInstanceId
     * @return
     */
    ActivitiBusinessEntity getByProcessInstanceId(String crmProcessInstanceId);

    /**
     * 根据实例id 获取业务编号
     * @param processInstanceId
     * @return
     */
    ActivitiBusinessEntity getByCrmProcessInstanceId(String processInstanceId);


    /**
     * 根据businessId查询流程
     * @param businessId
     * @return
     */
    List<ActivitiBusinessEntity> getByBusinessId(String businessId);

    /**
     * 根据流程编号查询对应信息
     * @param crmProcessInstanceId
     * @param processInstanceId
     * @return
     */
    ActivitiBusinessEntity getActivitiBusiness(String crmProcessInstanceId,String processInstanceId);

    /**
     * 根据业务单号获取流程相关编号
     * @param businessIdOrNum
     * @return
     */
    List<ActivitiBusinessEntity> getListByBusinessIdOrNum(String businessIdOrNum,List<String> bpmStatus );

    /**
     * 修改流程状态
     * @param processInstanceId
     * @param bpmStatus
     * @return
     */
    ActivitiBusinessEntity updateBpmStatus(String processInstanceId,String bpmStatus,String processInstanceStatus);

    /**
     * 分页查询流程实例
     * @param reqVo
     * @return
     */
    PageResult<ProcessInstanceQueryRespVo> processInstancePage(ProcessInstanceQueryReqVo reqVo);

    /**
     * 分页查询已办列表
     * @param reqVo
     * @return
     */
    PageResult<ProcessInstanceQueryRespVo> taskDonePage(ProcessInstanceQueryReqVo reqVo);
}
