package com.biz.crm.activiti.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.activiti.entity.TaNodeConfigEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.activiti.design.req.TaNodeConfigReqVo;
import com.biz.crm.nebular.activiti.design.resp.OptBtnVO;
import com.biz.crm.nebular.activiti.design.resp.TaNodeConfigRespVo;
import com.biz.crm.nebular.activiti.start.req.ProcessInfoReqVO;

import java.util.List;
import java.util.Map;

/**
 * 接口
 *
 * @author jerry7
 * @date 2020-12-04 10:33:17
 */
public interface ITaNodeConfigService extends IService<TaNodeConfigEntity> {

    /**
     * 列表
     * @param taNodeConfigReqVo
     * @return PageResult<TaNodeConfigRespVo>
     */
    PageResult<TaNodeConfigRespVo> findList(TaNodeConfigReqVo taNodeConfigReqVo);

    /**
     * 查询
     * @param id 查询id
     * @return TaNodeConfigRespVo
     */
    TaNodeConfigRespVo query(String id);

    /**
     * 新增
     * @param taNodeConfigReqVo
     * @return
     */
    void save(TaNodeConfigReqVo taNodeConfigReqVo);

    /**
     * 更新
     * @param taNodeConfigReqVo
     * @return
     */
    void update(TaNodeConfigReqVo taNodeConfigReqVo);

    /**
     * 删除
     * @param ids id集合
     */
    void deleteBatch(List<String> ids);

//    /***
//     * 初始化流程节点配置
//     * 如果某一个KEY对应的流程是第一次发布，需要解析XML文件获得TASK，并保存初始化配置
//     * @param taProcess
//     * @param versionKey
//     */
//    void initNodeConfig(TaProcessEntity taProcess, String versionKey);

    /**
     * 根据流程版本号查询所有的配置
     * @param processVersionKey
     * @return
     */
    List<TaNodeConfigEntity> findNodeByProcessVersionKey(String processVersionKey);

//    /***
//     * 发布流程时创建节点配置信息
//     * 如果不是第一次发布，复制当前节点的配置，生成给最新流程版本
//     * @param oldVersion
//     * @param newVersion
//     */
//    void createNodeConfigWhenUpdateProcess(TaProcessEntity taProcess, String oldVersion, String newVersion);

    /**
     * 根据processkey和processVersionKey获取节点列表
     *
     * @param taNodeConfigReqVo
     * @return
     */
    PageResult<TaNodeConfigRespVo> queryByProcessKey(TaNodeConfigReqVo taNodeConfigReqVo);

    /**
     * 跟格流程版本KEY和节点KEY搜索节点
     * @param processVersionKey
     * @param taskDefKey
     * @return
     */
    TaNodeConfigEntity findNodeByTaskVersionKey(String processVersionKey, String taskDefKey);

    /**
     * 将节点配置List转成Map，节点KEY做KEY
     * @param configList
     * @return
     */
    Map<String, TaNodeConfigEntity> configListToMap(List<TaNodeConfigEntity> configList);

    /**
     * 获取流程的历史版本ProcessVersion
     * @param processKey
     * @return
     */
    List<TaNodeConfigRespVo> getAllProcessVersionKey(String processKey);

    /**
     * 根据流程编码获取操作按钮
     * @param reqVo
     * @return
     */
    List<OptBtnVO> getButtonsByCrmProcessInstanceId(ProcessInfoReqVO reqVo);
}

