package com.biz.crm.activiti.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.activiti.entity.TaProcessBizRelationEntity;
import com.biz.crm.nebular.activiti.design.resp.TaProcessOrgRespVO;
import com.biz.crm.vo.SubmitActivitiResp;
import com.biz.crm.vo.TaProcessBizRelationReqVo;
import com.biz.crm.vo.TaProcessBizRelationRespVo;

import java.util.List;

/**
 * 这是流程绘制-业务关系相关 业务接口
 *
 * @author YuanZiJian
 * @date 2020/12/15 17:03
 * @version: V1.0
 */
public interface TaProcessBizRelationService extends IService<TaProcessBizRelationEntity> {
    /**
     * 根据流程key找到对应的业务关系
     *
     * @param processKey 流程key
     * @return com.biz.crm.act.vo.TaProcessBizRelationRespVo
     * @method getRelationByProcessKey
     * @date: 2020/12/15 17:04
     * @author: YuanZiJian
     */
    TaProcessBizRelationRespVo getRelationByProcessKey(String processKey);


    /**
     * 查出所有的流程关系信息
     *
     * @param taProcessBizRelationReqVo 接收前端参数
     * @return java.util.List<com.biz.crm.act.vo.TaProcessBizRelationRespVo>
     * @method getListRelation
     * @date: 2020/12/18 18:52
     * @author: YuanZiJian
     */
    List<TaProcessBizRelationRespVo> getListRelation(TaProcessBizRelationReqVo taProcessBizRelationReqVo);

    /**
     * 根据processKey删除对应Relation
     *
     * @param processKey
     * @return void
     * @method deleteRelation
     * @date: 2020/12/18 18:58
     * @author: YuanZiJian
     */
    void deleteRelation(String processKey);

    /**
     * 新增业务关系
     *
     * @param taProcessBizRelationReqVo 接收参数的对象Vo
     * @return void
     * @method insertRelation
     * @date: 2020/12/15 17:07
     * @author: YuanZiJian
     */
    void insertRelation(TaProcessBizRelationReqVo taProcessBizRelationReqVo);

    /**
     * 寻流程,根据当前登录人和菜单编码查找对应的已发布的流程
     * @return
     */
    SubmitActivitiResp findProcessByCurrentUserAndMenu();
}
