package com.biz.crm.activiti.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.activiti.entity.*;
import com.biz.crm.activiti.mapper.ActReModelMapper;
import com.biz.crm.activiti.mapper.ActivitiBusinessMapper;
import com.biz.crm.activiti.mapper.ActivitiCurrentTaskMapper;
import com.biz.crm.activiti.mapper.TaFuncRoleMapper;
import com.biz.crm.activiti.service.*;
import com.biz.crm.annotation.Klock;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.bpmlog.entity.ActivitiBpmlogEntity;
import com.biz.crm.bpmlog.mapper.ActivitiBpmlogMapper;
import com.biz.crm.bpmlog.service.ActivitiBpmlogService;
import com.biz.crm.bpmlog.vo.ActivitiBpmlogVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.copy.entity.ActivitiCopyTaskEntity;
import com.biz.crm.copy.mapper.ActivitiCopyTaskMapper;
import com.biz.crm.copy.service.ActivitiCopyTaskService;
import com.biz.crm.design.util.WorkFlowGlobals;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.activiti.*;
import com.biz.crm.mdm.bpmrole.MdmBpmRoleFeign;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.nebular.activiti.act.req.TaActDelegateReqVo;
import com.biz.crm.nebular.activiti.act.resp.TaActFileRespVo;
import com.biz.crm.nebular.activiti.act.resp.TaActTargetRespVo;
import com.biz.crm.nebular.activiti.design.resp.OptBtnVO;
import com.biz.crm.nebular.activiti.task.resp.ProcessSummaryRspVO;
import com.biz.crm.nebular.activiti.vo.*;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.util.*;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.engine.*;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.TransitionImpl;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.image.ProcessDiagramGenerator;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.common.util.set.Sets;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.io.InputStream;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.activiti.service.impl
 * @Description: TODO
 * @date 2021/4/20 下午6:47
 */
@Service
@ConditionalOnMissingBean(name = "BizRuntimeExpandServiceImpl")
@Slf4j
public class BizRuntimeServiceImpl implements BizRuntimeService {
    //启动流程
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private IdentityService identityService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ProcessEngineConfiguration processEngineConfiguration;
    @Autowired
    private ActivitiBusinessService activitiBusinessService;
    @Autowired
    private ActivitiBpmlogService logService;
    @Resource
    private ActivitiBpmlogMapper logMapper;
    @Autowired
    private ActivitiTaskService activitiTaskService;
    @Autowired
    private ActivityTaskUtil activityTaskUtil;
    @Resource
    private ActivitiCurrentTaskMapper activitiCurrentTaskMapper;
    @Resource
    private MdmBpmRoleFeign mdmBpmRoleFeign;
    @Autowired
    private ITaActFileService fileService;
    @Resource
    private ActReModelMapper actReModelMapper;
    @Resource
    private ActivitiBusinessMapper activitiBusinessMapper;
    @Autowired
    private ActivitiBusinessHelper helper;
    @Autowired
    private MdmPositionFeign positionFeign;
    @Resource
    private ActivitiCopyTaskMapper copyTaskMapper;
    @Autowired
    private ActivitiCopyTaskService copyTaskService;
    @Autowired
    private ITaNodeConfigService nodeConfigService;
    @Resource
    private TaFuncRoleMapper funcRoleMapper;

    /**
     * 启动流程
     *
     * @param variables
     * @return
     */
    private ProcessInstance startProcessInstanceByKey(String processKey, String businessObjIdOrNum, Map<String, Object> variables) {
        ProcessInstance processInstance = runtimeService.startProcessInstanceByKey(processKey, businessObjIdOrNum,
                variables);
        return processInstance;
    }

    @Override
    @Klock(keys = {"#activitiBusinessVo.businessId"}, waitTime = 60, leaseTime = 300)
    @Transactional(rollbackFor = Exception.class)
    public String startProcess(ActivitiBusinessVo activitiBusinessVo) {
        UserRedis userRedis = UserUtils.getUser();
        log.info("提交工作流", activitiBusinessVo);
        String checkResult = this.checkStartProcess(activitiBusinessVo, userRedis);
        if (com.biz.crm.util.StringUtils.isNotEmpty(checkResult)) {
            return checkResult;
        }
        identityService.setAuthenticatedUserId(activitiBusinessVo.getPositionCode());
        //设置流程变量
        Map<String, Object> variables = activitiBusinessVo.getVariables();
        if (activitiBusinessVo.getVariables() != null && !activitiBusinessVo.getVariables().isEmpty()) {
            variables.putAll(activitiBusinessVo.getVariables());
        } else {
            variables = Maps.newHashMap();
        }
        //提交人岗位，提交人组织
        variables.put(WorkFlowGlobals.COMMIT_ORG, userRedis.getOrgcode());
        variables.put(WorkFlowGlobals.COMMIT_POS, userRedis.getPoscode());
        ProcessInstance processInstance = this.startProcessInstanceByKey(activitiBusinessVo.getProcessKey(), activitiBusinessVo.getBusinessId(), variables);
        if (processInstance == null) {
            throw new BusinessException("发起流程失败");
        }
        if (StringUtils.isEmpty(processInstance.getId())) {
            throw new BusinessException("发起流程失败");
        }
        //转化流程编号
        ActivitiBusinessEntity businessEntity = activitiBusinessService.save(processInstance, activitiBusinessVo);

        //提交生成默认流程日志备注
        StringBuffer buffer = new StringBuffer();
        buffer.append(userRedis.getRealname()).append("[").append(activitiBusinessVo.getPositionCode()).append("]").append("发起流程");


        ActivitiCurrentTaskVo currentTaskVo = new ActivitiCurrentTaskVo(businessEntity.getCrmProcessInstanceId(), businessEntity.getProcessInstanceId(),
                WorkFlowGlobals.FIVE, activitiBusinessVo.getProcessTitle(), userRedis.getRealname(), activitiBusinessVo.getPositionCode()
        );
        //检查流程后续是否还存在任务
        ProcessInstance processInstanceNow = activityTaskUtil.getProcessInstance(businessEntity.getProcessInstanceId(), null);
        if (processInstanceNow != null) {
            CurrentVo currentVo = activityTaskUtil.getCurrentVo(businessEntity.getProcessInstanceId(), null);
            //未结束则保存下一个节点的代办数据
            this.saveCurrentTask(currentVo, currentTaskVo);
        }
        //保存日志
        logService.commomSaveLog(businessEntity.getCrmProcessInstanceId(), businessEntity.getProcessInstanceId(),
                activitiBusinessVo.getBusinessId(), activitiBusinessVo.getBusinessNo(), buffer.toString(), ActivitiOperateTypeEnum.START.getCode()
        );
        //保存提交审批的附件
        if (CollectionUtil.collectionNotEmpty(activitiBusinessVo.getAttachmentVos())) {
            List<TaActFileEntity> fileEntities = activitiBusinessVo.getAttachmentVos().stream().map(file -> {
                TaActFileEntity fileEntity = new TaActFileEntity();
                fileEntity.setFileAddress(file.getFileAddress());
                fileEntity.setObjectName(file.getObjectName());
                fileEntity.setFileType(Indicator.ACTIVITI_FILE_START.getCode());
                fileEntity.setProcessInstId(businessEntity.getProcessInstanceId());
                return fileEntity;
            }).collect(Collectors.toList());
            fileService.saveBatch(fileEntities);
        }
        this.startProcessDoOtherThings(businessEntity.getProcessInstanceId());
        //执行为空跳过和重复跳过
        //查询下一个节点的任务
        List<Task> nextTasks = helper.findCurrentTasksByProcessInstanceId(businessEntity.getProcessInstanceId());
        if (CollectionUtils.isNotEmpty(nextTasks)) {
            Task nextTask = nextTasks.get(0);
            TaNodeConfigEntity nextNode = helper.findNodeByProcessVersionKeyAndNodeCode(businessEntity.getProcessVersionKey(), nextTasks.get(0).getTaskDefinitionKey());
            CompleteTaskVo vo = new CompleteTaskVo();
            vo.setPass(true);
            vo.setIsAutoExecute(true);
            //校验当前任务的人员是否存在,如果不存在就执行一次审批通过的方法,空岗位跳过
            List<IdentityLink> identityLinksForTask = taskService.getIdentityLinksForTask(nextTask.getId());
            Set<String> queryPosCodes= Sets.newHashSet();
            Set<String> queryBpmRoleCodes= Sets.newHashSet();
            identityLinksForTask.forEach(o->{
                if(StringUtils.isNotEmpty(o.getUserId())){
                    queryPosCodes.add(o.getUserId());
                }
                if(StringUtils.isNotEmpty(o.getGroupId())){
                    queryBpmRoleCodes.add(o.getGroupId());
                }
            });
            Map<String,MdmPositionUserOrgRespVo> posMap=Maps.newHashMap();
            if(CollectionUtils.isNotEmpty(queryPosCodes)){
                posMap=helper.findUserByPositionCodes(queryPosCodes).stream().collect(Collectors.toMap(MdmPositionUserOrgRespVo::getPositionCode, Function.identity()));
            }
            Map<String,Set<String>> bpmRoleMap=Maps.newHashMap();
            if(CollectionUtils.isNotEmpty(queryBpmRoleCodes)){
                queryBpmRoleCodes.forEach(o->{
                    Set<String> posCodes = ApiResultUtil.objResult(positionFeign.findPositionCodeSetByOrgParentAndBpmRoleCodeList(null, Lists.newArrayList(o)));
                    bpmRoleMap.put(o,posCodes);
                });
            }
            vo.setTaskId(nextTask.getId());
            vo.setCrmProcessInstanceId(businessEntity.getCrmProcessInstanceId());
            //为空跳过
            if (Objects.equals(1, nextNode.getAuditNullSkip())) {
                Boolean nullSkipFlag = false;
                String nullSkipUserId="";
                for (IdentityLink link : identityLinksForTask) {
                    if (StringUtils.isNotEmpty(link.getUserId())) {
                        MdmPositionUserOrgRespVo mdmPositionUserOrgRespVo =posMap.get(link.getUserId());
                        if (Objects.nonNull(mdmPositionUserOrgRespVo)) {
                            nullSkipFlag=true;
                            break;
                        }else {
                            nullSkipUserId=link.getUserId();
                        }
                    }
                    if (StringUtils.isNotEmpty(link.getGroupId())) {
                        Set<String> posCodes = bpmRoleMap.get(link.getGroupId());
                        if (CollectionUtils.isNotEmpty(posCodes)) {
                            nullSkipFlag=true;
                            break;
                        }
                    }
                }
                if(nullSkipFlag==false){
                    //执行空岗位跳过
                    if(StringUtils.isEmpty(nullSkipUserId)){
                        nullSkipUserId=userRedis.getPoscode();
                    }
                    vo.setPositionCode(nullSkipUserId);
                    vo.setRemarks("岗位或流程角色对应人员为空,自动跳过");
                    this.completeTasks(vo);
                }
            }
            //重复跳过
            if (Objects.equals(1, nextNode.getAuditRepeatSkip())) {
                //获取当前登录人在当前流程的的审批记录
                Boolean flag = false;
                String repeatSkipUserId="";
                List<ActivitiBpmlogEntity> logs = logService.findLogByUserAndCrmProcessInstanceId(businessEntity.getCrmProcessInstanceId());
                Set<String> set = logs.stream().filter(o->StringUtils.equals(ActivitiOperateTypeEnum.START.getCode(),o.getOperateType())).map(ActivitiBpmlogEntity::getCreatePosCode).collect(Collectors.toSet());
                for (IdentityLink link : identityLinksForTask) {
                    if (StringUtils.isNotEmpty(link.getUserId())) {
                        if (set.contains(link.getUserId()) || StringUtils.equals(userRedis.getPoscode(), link.getUserId())) {
                            flag = true;
                            repeatSkipUserId=link.getUserId();
                            break;
                        }
                    }
                    if (StringUtils.isNotEmpty(link.getGroupId())) {
                        Set<String> posCodes = bpmRoleMap.get(link.getGroupId());
                        if (CollectionUtils.isNotEmpty(posCodes)) {
                            for (String posCode : posCodes) {
                                if (set.contains(posCode)) {
                                    flag = true;
                                    repeatSkipUserId=posCode;
                                    break;
                                }
                            }
                        }
                    }
                }

                if (flag) {
                    vo.setPositionCode(repeatSkipUserId);
                    vo.setRemarks("岗位["+repeatSkipUserId+"]重复审批,自动跳过");
                    this.completeTasks(vo);
                }
            }
        }
        return businessEntity.getCrmProcessInstanceId();
    }

    /**
     * 保存下一个节点的代办数据
     *
     * @param currentVo
     */
    private void saveCurrentTask(CurrentVo currentVo, ActivitiCurrentTaskVo vo) {
        if (currentVo == null) {
            return;
        }
        //职位
        Set<String> positionCode = currentVo.getPositionCode();
        if (positionCode != null && !positionCode.isEmpty()) {
            positionCode.forEach(item -> {
                ActivitiCurrentTaskVo currentTaskVo = new ActivitiCurrentTaskVo();
                BeanUtils.copyProperties(vo, currentTaskVo);
                currentTaskVo.setDateType(WorkFlowGlobals.ONE);
                currentTaskVo.setPositionCode(item);
                currentTaskVo.setBpmRoeCode(null);
                activitiTaskService.saveTask(currentTaskVo);
            });
        }
        //流程角色
        Set<String> bpmRoleCode = currentVo.getBpmRoleCode();
        if (bpmRoleCode != null && !bpmRoleCode.isEmpty()) {
            bpmRoleCode.forEach(item -> {
                ActivitiCurrentTaskVo currentTaskVo = new ActivitiCurrentTaskVo();
                BeanUtils.copyProperties(vo, currentTaskVo);
                currentTaskVo.setDateType(WorkFlowGlobals.ONE);
                currentTaskVo.setPositionCode(null);
                currentTaskVo.setBpmRoeCode(item);
                activitiTaskService.saveTask(currentTaskVo);
            });
        }
    }

    /**
     * 提交工作流校验
     *
     * @param activitiBusinessVo
     */
    private String checkStartProcess(ActivitiBusinessVo activitiBusinessVo, UserRedis userRedis) {
        if (StringUtils.isEmpty(activitiBusinessVo.getProcessKey())) {
            throw new BusinessException("请指定需要提交的流程【processKey】");
        }
        if (StringUtils.isEmpty(activitiBusinessVo.getBusinessId())) {
            throw new BusinessException("业务对象不能为空【businessId】");
        }
        if (StringUtils.isEmpty(activitiBusinessVo.getPositionCode())) {
            throw new BusinessException("当前提交人不能为空【positionCode】");
        }
        //检验流程模型是否存在
        ActReModelEntity actReModelEntity = actReModelMapper.selectOne(Wrappers.lambdaQuery(ActReModelEntity.class).eq(ActReModelEntity::getKey, activitiBusinessVo.getProcessKey()));
        AssertUtils.isNotNull(actReModelEntity, "您选择的流程[" + activitiBusinessVo.getProcessKey() + "]已经不存在,请重新选择");
        activitiBusinessVo.setProcessName(actReModelEntity.getName());
        if (StringUtils.equals(activitiBusinessVo.getPositionCode(), userRedis.getPoscode())) {
            //如果流程提交人就是登录人本人
            activitiBusinessVo.setCommitCode(userRedis.getUsername());
            activitiBusinessVo.setCommitByOrg(userRedis.getOrgcode());
            activitiBusinessVo.setCommitByOrgName(userRedis.getOrgname());
            activitiBusinessVo.setCommitPos(userRedis.getPoscode());
            activitiBusinessVo.setCommitPosName(userRedis.getPosname());
            activitiBusinessVo.setCommitName(StringUtils.isEmpty(activitiBusinessVo.getCommitName())? userRedis.getRealname() : activitiBusinessVo.getCommitName());
        }
        //检查是否重复提交
        return activityTaskUtil.checkRepeatCommit(activitiBusinessVo.getBusinessId());
    }

    /**
     * 查询待办任务
     *
     * @param bpmQueryVo
     * @return
     */
    @Override
    public PageResult<CurrentTaskVo> listByPositionCode(BpmQueryVo bpmQueryVo) {
        String positionCode = bpmQueryVo.getPositionCode();
        UserRedis userRedis = UserUtils.getUser();
        bpmQueryVo.setCurrentUserName(userRedis.getUsername());
        if (StringUtils.isEmpty(positionCode)) {
            positionCode = userRedis.getPoscode();
        }
        AssertUtils.isNotEmpty(positionCode, "当前登录人未获取到职位信息");
        //根据职位编码查询所有bpm角色
        List<String> positionCodes = new ArrayList<>();
        positionCodes.add(positionCode);
        Set<String> bpmRoleCodeSet = ApiResultUtil.objResult(mdmBpmRoleFeign.findBpmRoleCodeSetByPositionCodeList(positionCodes), true);
        bpmRoleCodeSet = bpmRoleCodeSet == null ? new HashSet<>() : bpmRoleCodeSet;
        Page<CurrentTaskVo> page = PageUtil.buildPage(bpmQueryVo.getPageNum(), bpmQueryVo.getPageSize());
        if(StringUtils.isNotEmpty(bpmQueryVo.getCommitBeginDate())){
            bpmQueryVo.setCommitBeginDate(bpmQueryVo.getCommitBeginDate()+" 00:00:00");
        }
        if(StringUtils.isNotEmpty(bpmQueryVo.getCommitEndDate())){
            bpmQueryVo.setCommitEndDate(bpmQueryVo.getCommitEndDate()+" 23:59:59");
        }
        if(StringUtils.isNotEmpty(bpmQueryVo.getDoneBeginDate())){
            bpmQueryVo.setDoneBeginDate(bpmQueryVo.getDoneBeginDate()+" 00:00:00");
        }
        if(StringUtils.isNotEmpty(bpmQueryVo.getDoneEndDate())){
            bpmQueryVo.setDoneEndDate(bpmQueryVo.getDoneEndDate()+" 23:59:59");
        }
        List<CurrentTaskVo> list = activitiCurrentTaskMapper.listByPositionCode(page, positionCode, new ArrayList<>(bpmRoleCodeSet), bpmQueryVo);
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(o -> {
                o.setBpmStatusName(ActivitiOperateTypeEnum.getStatusNameByCode(o.getBpmStatus()));
            });
        }
        return PageResult.<CurrentTaskVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    public PageResult<CurrentTaskVo> listMyBpm(BpmQueryVo bpmQueryVo) {
        UserRedis userRedis = UserUtils.getUser();
        List<MdmPositionRespVo> positionRespVos = PositionUtil.getAllPositionByUsername(userRedis.getUsername());
        Set<String> set = new HashSet<>();
        for (MdmPositionRespVo item : positionRespVos) {
            set.add(item.getPositionCode());
        }
        Page<CurrentTaskVo> page = PageUtil.buildPage(bpmQueryVo.getPageNum(), bpmQueryVo.getPageSize());
        List<CurrentTaskVo> list = activitiCurrentTaskMapper.listMyBpm(page, new ArrayList<>(set));
        if (CollectionUtils.isNotEmpty(list)) {
            List<String> positionCodes = Lists.newArrayList();
            list.stream().forEach(o -> {
                if (StringUtils.isNotEmpty(o.getCurrentTaskPositionCode())) {
                    positionCodes.add(o.getCurrentTaskPositionCode());
                }
            });
            Map<String, MdmPositionUserOrgRespVo> positionRespVoMap = helper.findPositionMapByCodes(positionCodes);
            list.forEach(o -> {
                helper.listMyBpmSetCurrentPositionAndUserByProcessInstanceId(o);
                o.setBpmStatusName(ActivitiOperateTypeEnum.getStatusNameByCode(o.getBpmStatus()));
            });
        }
        return PageResult.<CurrentTaskVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    public PageResult<CurrentTaskVo> listMyRejectBpm(BpmQueryVo bpmQueryVo) {
        UserRedis userRedis = UserUtils.getUser();
        List<MdmPositionRespVo> positionRespVos = PositionUtil.getAllPositionByUsername(userRedis.getUsername());
        Set<String> set = new HashSet<>();
        for (MdmPositionRespVo item : positionRespVos) {
            set.add(item.getPositionCode());
        }
        Page<CurrentTaskVo> page = PageUtil.buildPage(bpmQueryVo.getPageNum(), bpmQueryVo.getPageSize());
        List<CurrentTaskVo> list = activitiCurrentTaskMapper.listMyRejectBpm(page, new ArrayList<>(set));
        return PageResult.<CurrentTaskVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    public InputStream getProcessInstancePicInfo(String processInstanceId) {
        //获取历史流程实例
        HistoricProcessInstance processInstance = historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if(Objects.isNull(processInstance)){
            throw new BusinessException("流程数据异常,当前流程实例不存在");
        }
        //获取流程图
        BpmnModel bpmnModel = repositoryService.getBpmnModel(processInstance.getProcessDefinitionId());
        Context.setProcessEngineConfiguration((ProcessEngineConfigurationImpl) processEngineConfiguration);

        ProcessDiagramGenerator diagramGenerator = processEngineConfiguration.getProcessDiagramGenerator();
        ProcessDefinitionEntity definitionEntity = (ProcessDefinitionEntity) repositoryService.getProcessDefinition(processInstance.getProcessDefinitionId());

        List<HistoricActivityInstance> highLightedActivitList = historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).list();
        //高亮环节id集合
        List<String> highLightedActivitis = new ArrayList<>();
        //高亮线路id集合
        List<String> highLightedFlows = activityTaskUtil.getHighLightedFlows(definitionEntity, highLightedActivitList);

        for (HistoricActivityInstance tempActivity : highLightedActivitList) {
            String activityId = tempActivity.getActivityId();
            highLightedActivitis.add(activityId);
        }
        //中文显示的是口口口，设置字体就好了
        InputStream imageStream = diagramGenerator.generateDiagram(bpmnModel, "png", highLightedActivitis, highLightedFlows, "宋体", "宋体", "宋体", null, 1.0);
        //单独返回流程图，不高亮显示
        return imageStream;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    @Klock(keys = {"#completeTaskVo.taskId"}, waitTime = 60, leaseTime = 300)
    public void completeTasks(CompleteTaskVo completeTaskVo) {
        log.info("完成任务参数：taskId={} ,params={}", completeTaskVo);
        AssertUtils.isNotEmpty(completeTaskVo.getTaskId(), "节点任务id[taskId]不能为空");
        AssertUtils.isNotEmpty(completeTaskVo.getCrmProcessInstanceId(), "流程编号[crmProcessInstanceId]不能为空");
        AssertUtils.isNotNull(completeTaskVo.getPass(), "操作类型[pass]不能为空");
        ActivitiBusinessEntity entity = helper.findActivitiBusinessEntityByCrmInstanceId(completeTaskVo.getCrmProcessInstanceId());
        AssertUtils.isNotNull(entity, "流程编码:" + completeTaskVo.getCrmProcessInstanceId() + ",对应的流程实例不存在");
        AssertUtils.isTrue(StringUtils.equals(ProcessInstanceStatusEnum.ENABLE.getCode(), entity.getProcessInstanceStatus()), "当前流程实例状态不为启用,无法执行当前操作");
        if (!StringUtils.equals(ActivitiOperateTypeEnum.COMMIT.getCode(), entity.getBpmStatus())) {
            throw new BusinessException("您操作的流程实例状态已发生变更,请刷新后重新操作");
        }
        //查询当前任务,判断状态值是否可以操作
        Task currentTaskByTask = helper.findCurrentTaskByTaskId(completeTaskVo.getTaskId());
        if (Objects.isNull(currentTaskByTask)) {
            throw new BusinessException("当前任务已经不存在,请刷新后再操作");
        }
        if (StringUtils.isEmpty(completeTaskVo.getPositionCode())) {
            //没有传入当前审批职位默认为当前登录人职位
            completeTaskVo.setPositionCode(UserUtils.getUser().getPoscode());
        }
        TaNodeConfigEntity nodeConfigEntity = helper.findNodeByProcessVersionKeyAndNodeCode(entity.getProcessVersionKey(), currentTaskByTask.getTaskDefinitionKey());
        ActivitiBpmlogVo bpmlogVo = ActivitiBpmlogVo.builder()
                .businessId(entity.getBusinessId())
                .businessNo(entity.getBusinessNo())
                .crmProcessInstanceId(entity.getCrmProcessInstanceId())
                .taskId(completeTaskVo.getTaskId())
                .processInstanceId(entity.getProcessInstanceId())
                .nodeName(currentTaskByTask.getName())
                .nodeCode(currentTaskByTask.getTaskDefinitionKey())
                .nodeId(Objects.nonNull(nodeConfigEntity) ? nodeConfigEntity.getProcessNodeId() : null)
                .build();
        String operateTypeEnumCode = null;
        //保存提交审批的附件
        if (CollectionUtil.collectionNotEmpty(completeTaskVo.getAttachmentVos())) {
            List<TaActFileEntity> fileEntities = completeTaskVo.getAttachmentVos().stream().map(file -> {
                TaActFileEntity fileEntity = new TaActFileEntity();
                fileEntity.setFileAddress(file.getFileAddress());
                fileEntity.setTaskId(completeTaskVo.getTaskId());
                fileEntity.setNodeId(nodeConfigEntity.getProcessNodeId());
                fileEntity.setNodeName(nodeConfigEntity.getProcessNodeName());
                fileEntity.setNodeCode(nodeConfigEntity.getProcessNodeCode());
                fileEntity.setObjectName(file.getObjectName());
                fileEntity.setFileType(Indicator.ACTIVITI_FILE_APPROVE.getCode());
                fileEntity.setProcessInstId(entity.getProcessInstanceId());
                return fileEntity;
            }).collect(Collectors.toList());
            fileService.saveBatch(fileEntities);
        }
        if (completeTaskVo.getPass()) {
            //审批通过
            //校验操作权限
            this.checkUserOperatePermission(entity.getProcessVersionKey(), currentTaskByTask.getTaskDefinitionKey(), IndicatorStr.PROCESS_BTN_APPROVAL);
            operateTypeEnumCode = ActivitiOperateTypeEnum.PASS.getCode();
            if(com.biz.crm.util.StringUtils.isEmpty(completeTaskVo.getRemarks())){
                completeTaskVo.setRemarks("同意");
            }
            //保存日志
            bpmlogVo.setRemarks(helper.getProcessOperateLogDesc(operateTypeEnumCode, completeTaskVo.getPositionCode(), completeTaskVo.getIsAutoExecute())  +(completeTaskVo.getIsAutoExecute() ? "" : ",审批意见:")+ completeTaskVo.getRemarks());
            if(completeTaskVo.getIsAutoExecute()){
                bpmlogVo.setIsAutoExecute(GlobalWhetherEnum.YES.getCode());
            }
            bpmlogVo.setOperateType(operateTypeEnumCode);
            logService.commomSaveLog(bpmlogVo);
            passBpm(completeTaskVo);
        } else {
            //驳回
            this.checkUserOperatePermission(entity.getProcessVersionKey(), currentTaskByTask.getTaskDefinitionKey(), IndicatorStr.PROCESS_BTN_REJECT_FIRST);
            operateTypeEnumCode = ActivitiOperateTypeEnum.REJECT.getCode();
            bpmlogVo.setRemarks(helper.getProcessOperateLogDesc(operateTypeEnumCode, completeTaskVo.getPositionCode(), false) + ",审批意见:" + completeTaskVo.getRemarks());
            bpmlogVo.setOperateType(operateTypeEnumCode);
            //保存日志
            logService.commomSaveLog(bpmlogVo);
            rejectBpm(completeTaskVo, WorkFlowGlobals.OPT_ABORT);
            this.rejectTaskDoOtherThings(entity.getProcessInstanceId());
        }
        log.info("完成任务：任务ID：" + completeTaskVo.getTaskId());
    }


    /**
     * 驳回流程
     *
     * @param completeTaskVo
     */
    @Transactional(rollbackFor = Exception.class)
    public void rejectBpm(CompleteTaskVo completeTaskVo, String approveOpt) {
        String processInstanceId = activitiBusinessService.getByProcessInstanceId(completeTaskVo.getCrmProcessInstanceId()).getProcessInstanceId();
        if (StringUtils.isEmpty(completeTaskVo.getRemarks())) {
            throw new BusinessException("请输入驳回备注信息");
        }
        // 添加审批意见信息
        taskService.addComment(completeTaskVo.getTaskId(), processInstanceId, completeTaskVo.getRemarks());
        // 设置此任务拥有者，用于查询此职位的历史任务信息
        taskService.setOwner(completeTaskVo.getTaskId(), completeTaskVo.getPositionCode());
        // 跳转到发起人节点
        // TODO获取自定义变量进行设值
        Map<String, Object> variable = new HashMap<String, Object>();
        //设置流程操作状态
        activityTaskUtil.setbpmOperation(variable, approveOpt);
        this.goProcessTaskNode(completeTaskVo.getTaskId(), WorkFlowGlobals.EVENT_NAME_END, variable, processInstanceId);
        //todo 更新流程关系表状
    }


    public synchronized void goProcessTaskNode(String taskId, String taskDefinitionKey, Map<String, Object> variables, String processInstanceId) {
        //获取当前任务
        Task taskCurrent = taskService.createTaskQuery().taskId(taskId).singleResult();
        // 查找所有并行任务节点，同时驳回
        List<Task> taskList = taskService.createTaskQuery().processInstanceId(processInstanceId).taskDefinitionKey(taskCurrent.getTaskDefinitionKey()).list();
        for (Task task : taskList) {
//            commitProcess(task.getId(), variables, taskDefinitionKey);
            turnTransition(task.getId(), taskDefinitionKey, variables);
        }
    }

    /**
     * 当前任务跳转到指定的任务中.
     * <p>
     *
     * @param taskId            任务id
     * @param taskDefinitionKey 要跳转到的任务定义Key
     * @param variables         流程变量
     * @throws Exception
     */
    private void turnTransition(String taskId, String taskDefinitionKey, Map<String, Object> variables) {
        // 当前节点
        ActivityImpl currActivity = findActivitiImpl(taskId, null);
        // 清空当前流向
        List<PvmTransition> oriPvmTransitionList = activityTaskUtil.clearTransition(currActivity);

        // 创建新流向
        TransitionImpl newTransition = currActivity.createOutgoingTransition();
        // 目标节点
        ActivityImpl pointActivity = findActivitiImpl(taskId, taskDefinitionKey);
        // 设置新流向的目标节点
        newTransition.setDestination(pointActivity);
        try {
            // 执行转向任务
            taskService.complete(taskId, variables);
        } catch (Exception e) {
            e.printStackTrace();
            throw e;
        } finally {
            // 删除目标节点新流入
            pointActivity.getIncomingTransitions().remove(newTransition);
            // 还原以前流向
            activityTaskUtil.restoreTransition(currActivity, oriPvmTransitionList);
        }
    }

    private ActivityImpl findActivitiImpl(String taskId, String activityId) {
        // 取得流程定义
        ProcessDefinitionEntity processDefinition = activityTaskUtil.findProcessDefinitionEntityByTaskId(taskId);
        // 获取当前活动节点ID
        if (StringUtils.isEmpty(activityId)) {
            TaskEntity task = (TaskEntity) taskService.createTaskQuery().taskId(taskId).singleResult();
            activityId = task.getTaskDefinitionKey();
        }
        // 根据流程定义，获取该流程实例的结束节点
        if (activityId.toUpperCase().equals("END")) {
            for (ActivityImpl activityImpl : processDefinition.getActivities()) {
                List<PvmTransition> pvmTransitionList = activityImpl.getOutgoingTransitions();
                if (pvmTransitionList.isEmpty()) {
                    return activityImpl;
                }
            }
        }
        // 根据节点ID，获取对应的活动节点
        ActivityImpl activityImpl = processDefinition.findActivity(activityId);
        return activityImpl;
    }

    /**
     * 审批通过
     *
     * @param completeTaskVo
     */
    @Transactional(rollbackFor = Exception.class)
    public void passBpm(CompleteTaskVo completeTaskVo) {
        //校验当前任务的沟通状态
        UserRedis user = UserUtils.getUser();
        List<TaTaskCommunicateEntity> communicates = helper.findCommunicatesByTaskId(completeTaskVo.getTaskId());
        List<TaTaskCommunicateEntity> collect = communicates.stream()
                .filter(o -> StringUtils.equals(GlobalWhetherEnum.YES.getCode(), o.getIsNeedReply()))
                .filter(o -> Objects.equals(Indicator.COPY_TASK_STATUS_UNREAD.getCode(), o.getStatus()))
                .collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect)) {
            throw new BusinessException("当前任务还有未确认的沟通事项,不能执行签批操作");
        }
        if (StringUtils.isEmpty(completeTaskVo.getRemarks())) {
            completeTaskVo.setRemarks("通过");
        }
        ActivitiBusinessEntity businessEntity = activitiBusinessService.getByProcessInstanceId(completeTaskVo.getCrmProcessInstanceId());
        //设置变量
        Map<String, Object> variables = completeTaskVo.getVariables();
        variables = variables == null ? new HashMap<>() : variables;
        Task currentTask = helper.findCurrentTaskByTaskId(completeTaskVo.getTaskId());
        //设置流程操作状态
        activityTaskUtil.setbpmOperation(variables, WorkFlowGlobals.OPT_PASS);
        taskService.setVariablesLocal(completeTaskVo.getTaskId(), variables);
        // 添加审批意见信息
        taskService.addComment(completeTaskVo.getTaskId(), businessEntity.getProcessInstanceId(), completeTaskVo.getRemarks());
        // 设置此任务拥有者，用于查询此职位的历史任务信息
        taskService.setOwner(completeTaskVo.getTaskId(), completeTaskVo.getPositionCode());
        taskService.complete(completeTaskVo.getTaskId(), variables);
        this.passTaskDoOtherThings(businessEntity.getProcessInstanceId());
        //查询下一个节点的任务
        List<Task> nextTasks = helper.findCurrentTasksByProcessInstanceId(businessEntity.getProcessInstanceId());
        if (CollectionUtils.isNotEmpty(nextTasks)) {
            Task nextTask = nextTasks.get(0);
            TaNodeConfigEntity currentNode = helper.findNodeByProcessVersionKeyAndNodeCode(businessEntity.getProcessVersionKey(), currentTask.getTaskDefinitionKey());
            TaNodeConfigEntity nextNode = helper.findNodeByProcessVersionKeyAndNodeCode(businessEntity.getProcessVersionKey(), nextTasks.get(0).getTaskDefinitionKey());
            CompleteTaskVo vo = new CompleteTaskVo();
            vo.setPass(true);
            vo.setIsAutoExecute(true);
            //校验当前任务的人员是否存在,如果不存在就执行一次审批通过的方法,空岗位跳过
            List<IdentityLink> identityLinksForTask = taskService.getIdentityLinksForTask(nextTask.getId());
            Set<String> queryPosCodes= Sets.newHashSet();
            Set<String> queryBpmRoleCodes= Sets.newHashSet();
            identityLinksForTask.forEach(o->{
                if(StringUtils.isNotEmpty(o.getUserId())){
                    queryPosCodes.add(o.getUserId());
                }
                if(StringUtils.isNotEmpty(o.getGroupId())){
                    queryBpmRoleCodes.add(o.getGroupId());
                }
            });
            Map<String,MdmPositionUserOrgRespVo> posMap=Maps.newHashMap();
            if(CollectionUtils.isNotEmpty(queryPosCodes)){
                posMap=helper.findUserByPositionCodes(queryPosCodes).stream().collect(Collectors.toMap(MdmPositionUserOrgRespVo::getPositionCode, Function.identity()));
            }
            Map<String,Set<String>> bpmRoleMap=Maps.newHashMap();
            if(CollectionUtils.isNotEmpty(queryBpmRoleCodes)){
                queryBpmRoleCodes.forEach(o->{
                    Set<String> posCodes = ApiResultUtil.objResult(positionFeign.findPositionCodeSetByOrgParentAndBpmRoleCodeList(null, Lists.newArrayList(o)));
                    bpmRoleMap.put(o,posCodes);
                });
            }
            vo.setTaskId(nextTask.getId());
            vo.setCrmProcessInstanceId(businessEntity.getCrmProcessInstanceId());
            //为空跳过
            if (Objects.equals(1, nextNode.getAuditNullSkip())) {
                Boolean nullSkipFlag = false;
                String nullSkipUserId="";
                for (IdentityLink link : identityLinksForTask) {
                    if (StringUtils.isNotEmpty(link.getUserId())) {
                        MdmPositionUserOrgRespVo mdmPositionUserOrgRespVo =posMap.get(link.getUserId());
                        if (Objects.nonNull(mdmPositionUserOrgRespVo)) {
                            nullSkipFlag=true;
                            break;
                        }else {
                            nullSkipUserId=link.getUserId();
                        }
                    }
                    if (StringUtils.isNotEmpty(link.getGroupId())) {
                        Set<String> posCodes = bpmRoleMap.get(link.getGroupId());
                        if (CollectionUtils.isNotEmpty(posCodes)) {
                            nullSkipFlag=true;
                            break;
                        }
                    }
                }
                if(nullSkipFlag==false){
                    //执行空岗位跳过
                    if(StringUtils.isEmpty(nullSkipUserId)){
                        nullSkipUserId=user.getPoscode();
                    }
                    vo.setPositionCode(nullSkipUserId);
                    vo.setRemarks("岗位或流程角色对应人员为空,自动跳过");
                    this.completeTasks(vo);
                }
            }
            //重复跳过
            if (Objects.equals(1, nextNode.getAuditRepeatSkip())) {
                //获取当前登录人在当前流程的的审批记录
                Boolean flag = false;
                String repeatSkipUserId="";
                List<ActivitiBpmlogEntity> logs = logService.findLogByUserAndCrmProcessInstanceId(businessEntity.getCrmProcessInstanceId());
                Set<String> set = logs.stream().filter(o->StringUtils.equals(ActivitiOperateTypeEnum.PASS.getCode(),o.getOperateType())).map(ActivitiBpmlogEntity::getCreatePosCode).collect(Collectors.toSet());
                for (IdentityLink link : identityLinksForTask) {
                    if (StringUtils.isNotEmpty(link.getUserId())) {
                        if (set.contains(link.getUserId()) || StringUtils.equals(user.getPoscode(), link.getUserId())) {
                            flag = true;
                            repeatSkipUserId=link.getUserId();
                            break;
                        }
                    }
                    if (StringUtils.isNotEmpty(link.getGroupId())) {
                        Set<String> posCodes = bpmRoleMap.get(link.getGroupId());
                        if (CollectionUtils.isNotEmpty(posCodes)) {
                            for (String posCode : posCodes) {
                                if (set.contains(posCode)) {
                                    flag = true;
                                    repeatSkipUserId=posCode;
                                    break;
                                }
                            }
                        }
                    }
                }

                if (flag) {
                    vo.setPositionCode(repeatSkipUserId);
                    vo.setRemarks("岗位["+repeatSkipUserId+"]重复审批,自动跳过");
                    this.completeTasks(vo);
                }
            }
        }
    }

    @Override
    public ProcessSummaryRspVO getProcessSummary(String crmProcessInstanceId) {
        ProcessSummaryRspVO processSummaryRspVO = new ProcessSummaryRspVO();
        //查询流程实例数据
        ActivitiBusinessEntity activitiBusinessEntity = activitiBusinessMapper.selectOne(Wrappers.lambdaQuery(ActivitiBusinessEntity.class).eq(ActivitiBusinessEntity::getCrmProcessInstanceId, crmProcessInstanceId));
        if (Objects.isNull(activitiBusinessEntity)) {
            log.error("流程实例数据丢失,crmProcessInstanceId={}", crmProcessInstanceId);
            return processSummaryRspVO;
        }
        processSummaryRspVO.setTitle(activitiBusinessEntity.getProcessTitle());
        processSummaryRspVO.setProcessKey(activitiBusinessEntity.getProcessKey());
        processSummaryRspVO.setProcessNo(activitiBusinessEntity.getCrmProcessInstanceId());
        processSummaryRspVO.setRemarks(activitiBusinessEntity.getRemarks());
        processSummaryRspVO.setProcessName(activitiBusinessEntity.getProcessName());
        processSummaryRspVO.setApplierName(activitiBusinessEntity.getCommitName());
        processSummaryRspVO.setCreateTime(activitiBusinessEntity.getCreateDateAll());
        processSummaryRspVO.setApplierPositionName(activitiBusinessEntity.getCommitPosName());
        //查询流程文件
        List<TaActFileRespVo> files = helper.findActFileByProcessInstanceIds(Lists.newArrayList(activitiBusinessEntity.getProcessInstanceId()), null);
        processSummaryRspVO.setProcessFiles(files);
        //查询关键指标配置表头
        List<TaActTargetRespVo> actTargetConfigByProcessKey = helper.findActTargetConfigByProcessKey(activitiBusinessEntity.getProcessKey());
        processSummaryRspVO.setTaActTargetRespVos(actTargetConfigByProcessKey);
        //解析关键指标json
        if (StringUtils.isNotEmpty(activitiBusinessEntity.getKeyTargetListJson())) {
            try {
                List<Object> objects1 = JSONArray.parseArray(activitiBusinessEntity.getKeyTargetListJson(), Object.class);
                processSummaryRspVO.setKeyTargetList(objects1);
            } catch (Exception e) {
                log.error("{}", e);
                log.error("流程实例,crmProcessInstanceId=" + crmProcessInstanceId + ",关键指标数据异常,无法转换为数组");

            }
        }
        return processSummaryRspVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    @Klock(keys = {"#crmProcessInstanceId"}, waitTime = 60, leaseTime = 300)
    public void recallTasks(String crmProcessInstanceId) {
        UserRedis userRedis = UserUtils.getUser();
        log.info("撤回流程：" + crmProcessInstanceId);
        ActivitiBusinessEntity activitiBusinessEntity = helper.findActivitiBusinessEntityByCrmInstanceId(crmProcessInstanceId);
        AssertUtils.isTrue(StringUtils.equals(ProcessInstanceStatusEnum.ENABLE.getCode(), activitiBusinessEntity.getProcessInstanceStatus()), "当前流程实例状态不为启用,无法执行当前操作");
        //检查流程是否结束
        ProcessInstance processInstance = activityTaskUtil.getProcessInstance(activitiBusinessEntity.getProcessInstanceId(), null);
        if (processInstance == null) {
            throw new BusinessException("当前流程已经结束[" + crmProcessInstanceId + "]");
        }
        taskService.addComment(null, activitiBusinessEntity.getProcessInstanceId(), "流程撤回[" + userRedis.getRealname() + "(" + userRedis.getPoscode() + ")]");
        List<Execution> executionList = runtimeService.createExecutionQuery().processInstanceId(activitiBusinessEntity.getProcessInstanceId()).list();
        if (CollectionUtil.listNotEmptyNotSizeZero(executionList)) {
            for (Execution execution : executionList) {
                runtimeService.setVariable(execution.getId(), WorkFlowGlobals.BPM_OPERATION, WorkFlowGlobals.OPT_RECOVER);
            }
        }
        runtimeService.deleteProcessInstance(activitiBusinessEntity.getProcessInstanceId(), WorkFlowGlobals.OPT_RECOVER);

        //添加日志
        ActivitiBpmlogVo bpmlogVo = ActivitiBpmlogVo.builder()
                .businessId(activitiBusinessEntity.getBusinessId())
                .businessNo(activitiBusinessEntity.getBusinessNo())
                .crmProcessInstanceId(activitiBusinessEntity.getCrmProcessInstanceId())
                .operateType(ActivitiOperateTypeEnum.RECOVER.getCode())
                .processInstanceId(activitiBusinessEntity.getProcessInstanceId())
                .build();
        bpmlogVo.setRemarks(helper.getProcessOperateLogDesc(ActivitiOperateTypeEnum.RECOVER.getCode(), userRedis.getPoscode(), true));
        logService.commomSaveLog(bpmlogVo);
    }

    /**
     * 传阅
     *
     * @param reqVo
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @Klock(keys = {"#reqVo.crmProcessInstanceId"}, waitTime = 60, leaseTime = 300)
    public void circulate(ProcessCirculateReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getCrmProcessInstanceId(), "流程编号[crmProcessInstanceId]不能为空");
        AssertUtils.isNotEmpty(reqVo.getPositionCodes(), "职位编码集合[positionCodes]不能为空");
        ActivitiBusinessEntity businessEntity = helper.findActivitiBusinessEntityByCrmInstanceId(reqVo.getCrmProcessInstanceId());
        AssertUtils.isNotNull(businessEntity, "流程编号[" + reqVo.getCrmProcessInstanceId() + "],对应的流程实例不存在");

        //如果某个职位已经存在该流程的传阅数据,则跳过该职位
        List<ActivitiCopyTaskEntity> copyTaskEntities = copyTaskMapper.selectList(Wrappers.lambdaQuery(ActivitiCopyTaskEntity.class).eq(ActivitiCopyTaskEntity::getCrmProcessInstanceId, reqVo.getCrmProcessInstanceId()).in(ActivitiCopyTaskEntity::getPositionCode, reqVo.getPositionCodes()).eq(ActivitiCopyTaskEntity::getTaskType, 1));
        Set<String> set = copyTaskEntities.stream().map(ActivitiCopyTaskEntity::getPositionCode).collect(Collectors.toSet());
        List<ActivitiCopyTaskEntity> taskEntities = reqVo.getPositionCodes().stream().distinct().filter(o -> !set.contains(o)).map(positionCode -> {
            ActivitiCopyTaskEntity copyTaskEntity = new ActivitiCopyTaskEntity();
            copyTaskEntity.setTaskType(ActivityCopyTaskTypeEnum.CIRCULATE.getCode());
            copyTaskEntity.setCrmProcessInstanceId(reqVo.getCrmProcessInstanceId());
            copyTaskEntity.setReadStatus(GlobalWhetherEnum.NO.getCode());
            copyTaskEntity.setProcessKey(businessEntity.getProcessKey());
            copyTaskEntity.setPositionCode(positionCode);
            return copyTaskEntity;
        }).collect(Collectors.toList());
        copyTaskService.saveBatch(taskEntities);
    }

    /**
     * 修改抄送任务的阅读状态
     *
     * @param id
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateCopyTaskStatus(String id) {
        AssertUtils.isNotEmpty(id, "id不能为空");
        ActivitiCopyTaskEntity activitiCopyTaskEntity = copyTaskMapper.selectOne(Wrappers.lambdaQuery(ActivitiCopyTaskEntity.class).eq(ActivitiCopyTaskEntity::getId, id));
        AssertUtils.isNotNull(activitiCopyTaskEntity, "任务数据不存在,id=" + id);
        //如果是已阅不需要修改数据
        if (!StringUtils.equals(GlobalWhetherEnum.YES.getCode(), activitiCopyTaskEntity.getReadStatus())) {
            activitiCopyTaskEntity.setReadStatus(GlobalWhetherEnum.YES.getCode());
            copyTaskMapper.updateById(activitiCopyTaskEntity);
        }
    }

    /**
     * 校验各种操作的按钮权限
     *
     * @param processVersionKey
     * @param nodeCode
     * @param operateTypeEnum
     */
    private void checkUserOperatePermission(String processVersionKey, String nodeCode, IndicatorStr operateTypeEnum) {
        TaNodeConfigEntity taNodeConfigEntity = helper.findNodeByProcessVersionKeyAndNodeCode(processVersionKey, nodeCode);
        AssertUtils.isNotNull(taNodeConfigEntity, "节点数据不存在,请重新发布流程");
        AssertUtils.isNotEmpty(taNodeConfigEntity.getBtnAuthRoleId(), "当前节点未配置按钮权限");
        TaFuncRoleEntity funcRoleEntity = funcRoleMapper.selectById(taNodeConfigEntity.getBtnAuthRoleId());
        List<OptBtnVO> optBtnVOS = helper.parseBtnList(funcRoleEntity.getRoleAuths());
        Set<String> set = optBtnVOS.stream().map(OptBtnVO::getBtnCode).collect(Collectors.toSet());
        if (!set.contains(operateTypeEnum.getCode())) {
            throw new BusinessException("当前节点没有设置:" + operateTypeEnum.getLabel() + ",权限");
        }
    }

    /**
     * 委派/转办
     *
     * @param reqVo
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @Klock(keys = {"#reqVo.taskId"}, waitTime = 60, leaseTime = 300)
    public void delegateProcess(TaActDelegateReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getDelegatePositionCode(), "委派岗位编码[delegatePositionCode]不能为空！");
        AssertUtils.isNotEmpty(reqVo.getTaskId(), "委派任务Id[taskId]不能为空！");
        AssertUtils.isNotEmpty(reqVo.getCrmProcessInstanceId(), "流程编码[crmProcessInstanceId]不能为空！");
        MdmPositionRespVo position = PositionUtil.getPositionByCode(reqVo.getDelegatePositionCode());
        AssertUtils.isNotNull(position, "委派职位已不存在:" + reqVo.getDelegatePositionCode());
        ActivitiBusinessEntity businessEntity = helper.findActivitiBusinessEntityByCrmInstanceId(reqVo.getCrmProcessInstanceId());
        Task task = helper.findCurrentTaskByTaskId(reqVo.getTaskId());
        AssertUtils.isNotNull(task, "当前任务已经不存在,请刷新后重试");
        //校验当前节点的按钮权限
        this.checkUserOperatePermission(businessEntity.getProcessVersionKey(), task.getTaskDefinitionKey(), IndicatorStr.PROCESS_BTN_TURN);
        task.setAssignee(reqVo.getDelegatePositionCode());
        taskService.saveTask(task);
        //保存操作日志
        UserRedis user = UserUtils.getUser();
        TaNodeConfigEntity nodeConfigEntity = helper.findNodeByProcessVersionKeyAndNodeCode(businessEntity.getProcessVersionKey(), task.getTaskDefinitionKey());
        ActivitiBpmlogVo bpmlogVo = ActivitiBpmlogVo.builder()
                .businessId(businessEntity.getBusinessId())
                .businessNo(businessEntity.getBusinessNo())
                .crmProcessInstanceId(businessEntity.getCrmProcessInstanceId())
                .operateType(ActivitiOperateTypeEnum.DELEGATE.getCode())
                .taskId(reqVo.getTaskId())
                .processInstanceId(task.getProcessInstanceId())
                .nodeName(task.getName())
                .nodeCode(task.getTaskDefinitionKey())
                .nodeId(Objects.nonNull(nodeConfigEntity) ? nodeConfigEntity.getProcessNodeId() : null)
                .build();
        bpmlogVo.setRemarks(helper.getProcessOperateLogDesc(ActivitiOperateTypeEnum.DELEGATE.getCode(), user.getPoscode(), false) + ":" + position.getPositionName() + "[" + position.getPositionCode() + "]");
        logService.commomSaveLog(bpmlogVo);

    }

    /**
     * 流程驳回或者通过时处理其他事项(项目上去实现逻辑)
     *
     * @param processInstanceId
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void rejectTaskDoOtherThings(String processInstanceId) {
    }

    /**
     * 流程通过时处理其他事项(项目上去实现逻辑)
     *
     * @param processInstanceId
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void passTaskDoOtherThings(String processInstanceId) {
    }

    /**
     * 提交流程时处理其他事项(项目上去实现逻辑)
     *
     * @param processInstanceId
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void startProcessDoOtherThings(String processInstanceId) {
    }
}
