package com.biz.crm.activiti.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.activiti.entity.ActReModelEntity;
import com.biz.crm.activiti.entity.TaActTargetEntity;
import com.biz.crm.activiti.entity.TaNodeConfigEntity;
import com.biz.crm.activiti.entity.TaProcessBizRelationEntity;
import com.biz.crm.activiti.mapper.ActReModelMapper;
import com.biz.crm.activiti.mapper.TaActTargetMapper;
import com.biz.crm.activiti.mapper.TaNodeConfigMapper;
import com.biz.crm.activiti.mapper.TaProcessBizRelationMapper;
import com.biz.crm.activiti.service.ITaNodeConfigService;
import com.biz.crm.activiti.service.OperateActivitiService;
import com.biz.crm.activiti.util.XmlActivitiUtil;
import com.biz.crm.annotation.Klock;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.activiti.Indicator;
import com.biz.crm.nebular.activiti.vo.ActGeByteArrayVo;
import com.biz.crm.nebular.activiti.vo.ActReModel;
import com.biz.crm.nebular.activiti.vo.ListByKeyVo;
import com.biz.crm.nebular.dms.notice.NoticeVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.PageUtil;
import com.biz.crm.vo.ReProcdef;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.editor.language.json.converter.BpmnJsonConverter;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.Model;
import org.activiti.engine.repository.ProcessDefinition;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.activiti.service.impl
 * @Description: TODO
 * @date 2021/4/20 下午1:39
 */
@Service
@Slf4j
public class OperateActivitiServiceImpl implements OperateActivitiService {

    @Resource
    private ActReModelMapper actReModelMapper;

    @Autowired
    private RepositoryService repositoryService;

    @Resource
    private TaProcessBizRelationMapper relationMapper;

    @Resource
    private TaActTargetMapper targetMapper;

    @Autowired
    private ITaNodeConfigService nodeConfigService;
    @Resource
    private TaNodeConfigMapper nodeConfigMapper;
    @Autowired
    private ActivitiBusinessHelper helper;


    @Override
    public PageResult<ActReModel> list(ActReModel actReModel) {
        Page<NoticeVo> page = PageUtil.buildPage(actReModel.getPageNum(), actReModel.getPageSize());
        List<ActReModel> list =  actReModelMapper.listPage(page,actReModel);
        list.forEach(o->{
            o.setProcessStatusName(Indicator.getProcessStatusNameByCode(o.getProcessStatus()));
        });
        return PageResult.<ActReModel>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 流程发布
     * @param id
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @Klock(keys = {"#id"}, waitTime = 60, leaseTime = 300)
    public void deployment(String id) {

        //获取模型
            Model modelData = repositoryService.getModel(id);
            ActReModelEntity entity = actReModelMapper.selectById(modelData.getId());
            if(Objects.equals(Indicator.PROCESS_STATE_DEPLOY.getCode(),entity.getProcessStatus())){
//                throw new BusinessException("当前流程已发布,不能执行发布操作");
            }
            byte[] bytes = repositoryService.getModelEditorSource(modelData.getId());

            ProcessDefinition oldProcessDefinition = null;
            if(StringUtils.isNotEmpty(modelData.getDeploymentId())){
                List<ProcessDefinition> list = repositoryService.createProcessDefinitionQuery().deploymentId(modelData.getDeploymentId()).orderByProcessDefinitionVersion().desc().list();
                oldProcessDefinition=list.get(0);
            }

            AssertUtils.isNotNull(bytes,"模型数据为空，请先设计流程并成功保存，再进行发布。");
            JsonNode modelNode = null;
            try {
                modelNode = new ObjectMapper().readTree(bytes);
            } catch (IOException e) {
               log.error("{}",e);
               throw new BusinessException("流程数据解析失败");
            }

            BpmnModel model = new BpmnJsonConverter().convertToBpmnModel(modelNode);
            AssertUtils.isNotNull(model.getProcesses(),"数据模型不符要求，请至少设计一条主线流程。");
            byte[] bpmBytes = new BpmnXMLConverter().convertToXML(model);
            //发布流程
            String processName = modelData.getName() + ".bpmn20.xml";
            Deployment deployment = null;
            try {
                deployment = repositoryService.createDeployment()
                        .name(modelData.getName())
                        .addString(processName, new String(bpmBytes, "UTF-8"))
                        .deploy();
            } catch (UnsupportedEncodingException e) {
                log.error("{}",e);
                throw new BusinessException("流程部署时数据转换失败");
            }
            modelData.setDeploymentId(deployment.getId());
            repositoryService.saveModel(modelData);
            entity.setProcessStatus(Indicator.PROCESS_STATE_DEPLOY.getCode());
            entity.setVersion(Objects.nonNull(oldProcessDefinition) ? oldProcessDefinition.getVersion()+1 : 1 );
            entity.setDeploymentId(deployment.getId());
            actReModelMapper.updateById(entity);
            //生成节点数据
            this.deployCreateNodes(bytes,entity,oldProcessDefinition);
    }
    private void deployCreateNodes(byte[] bytes,ActReModelEntity model,ProcessDefinition oldProcessDefinition){
        ActGeByteArrayVo processXmlByDeploymentId = helper.findProcessXmlByDeploymentId(model.getDeploymentId());
        List<ProcessDefinition> list = repositoryService.createProcessDefinitionQuery().deploymentId(model.getDeploymentId()).orderByProcessDefinitionVersion().desc().list();
        ProcessDefinition processDefinition = list.get(0);
        List<TaNodeConfigEntity> saveEntities=Lists.newArrayList();
        List<TaNodeConfigEntity> configEntities = null;
        try {
            configEntities = XmlActivitiUtil.getNodes(processXmlByDeploymentId.getProcessXml());
        } catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("解析xml获取task失败!");
        }
        if (CollectionUtils.isNotEmpty(configEntities)) {
            Map<String,TaNodeConfigEntity> map = Maps.newHashMap();
            if(Objects.nonNull(oldProcessDefinition)){
                //查询上一个版本的所有节点
                List<TaNodeConfigEntity> taNodeConfigEntities = nodeConfigMapper.selectList(Wrappers.lambdaQuery(TaNodeConfigEntity.class).eq(TaNodeConfigEntity::getProcessVersionKey, oldProcessDefinition.getId()));
                taNodeConfigEntities.forEach(o->{
                    map.put(o.getProcessNodeCode(),o);
                });
            }
            for (TaNodeConfigEntity configEntity : configEntities) {
                TaNodeConfigEntity taNodeConfigEntity = map.get(configEntity.getProcessNodeCode());
                if(Objects.nonNull(taNodeConfigEntity)){
                    taNodeConfigEntity.setProcessVersionKey(processDefinition.getId());
                    taNodeConfigEntity.setProcessNodeName(configEntity.getProcessNodeName());
                    taNodeConfigEntity.setNodeIndex(configEntity.getNodeIndex());
                    taNodeConfigEntity.setProcessNodeId(model.getKey() + ":" +processDefinition.getVersion()+":" +configEntity.getProcessNodeCode());
                    helper.setPublicParamsNull(taNodeConfigEntity);
                    saveEntities.add(taNodeConfigEntity);
                }else {
                    configEntity.setProcessVersionKey(processDefinition.getId());
                    configEntity.setProcessNodeId(model.getKey() + ":" +processDefinition.getVersion()+":" +configEntity.getProcessNodeCode());
                    saveEntities.add(configEntity);
                }
            }
            nodeConfigService.saveBatch(saveEntities);
        }
    }
    /**
     * 根据流程定义KEY查询流程历史版本号
     * @param listByKeyVo
     * @return
     */
    @Override
    public PageResult<ReProcdef> listByKey(ListByKeyVo listByKeyVo) {
        AssertUtils.isNotEmpty(listByKeyVo.getKey(),"请传入流程定义key");
        List<ProcessDefinition> processDefinitions = repositoryService.createProcessDefinitionQuery().processDefinitionKey(listByKeyVo.getKey())
                .listPage(listByKeyVo.getPageSize() * (listByKeyVo.getPageNum() - 1), listByKeyVo.getPageSize());
        long count = repositoryService.createProcessDefinitionQuery().count();
        List<ReProcdef> list = new ArrayList<>();
        for (ProcessDefinition processDefinition : processDefinitions) {
            ReProcdef reProcdef = new ReProcdef(processDefinition);
            list.add(reProcdef);
        }
        return PageResult.<ReProcdef>builder()
                .data(list)
                .count(count)
                .build();
    }

    /**
     * 批量删除流程模型
     * @param ids
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatchModel(List<String> ids) {
        AssertUtils.isNotNull(ids,"流程模型id集合不能为空");
        //先查询流程模型数据
        List<ActReModelEntity> modelEntities = actReModelMapper.selectList(Wrappers.lambdaQuery(ActReModelEntity.class).in(ActReModelEntity::getId, ids));
        List<String> existsIds= Lists.newArrayList();
        List<String> existsKeys= Lists.newArrayList();
        modelEntities.forEach(o->{
            existsIds.add(o.getId());
            existsKeys.add(o.getKey());
        });
        ids.forEach(o->{
            repositoryService.deleteModel(o);
        });
        if(CollectionUtils.isNotEmpty(existsKeys)){
            //删除流程对应的业务关联数据
            relationMapper.delete(Wrappers.lambdaQuery(TaProcessBizRelationEntity.class).in(TaProcessBizRelationEntity::getProcessKey,existsKeys));

            //删除关键指标配置数据
            targetMapper.delete(Wrappers.lambdaQuery(TaActTargetEntity.class).in(TaActTargetEntity::getProcessKey,existsKeys));
        }
    }
}
