package com.biz.crm.activiti.service.impl;

import com.biz.crm.activiti.service.ReceiveMdmService;
import com.biz.crm.activiti.user.GroupActivitiVo;
import com.biz.crm.activiti.user.MembershipActivitiVo;
import com.biz.crm.activiti.user.UserActivitiVo;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.identity.Group;
import org.activiti.engine.identity.User;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.eisp.activiti.service.impl
 * @Description: TODO
 * @date 2019/11/21 下午4:23
 */
@Service
@Transactional
public class ReceiveMdmServiceImpl implements ReceiveMdmService {
    @Override
    public void saveUser(UserActivitiVo userActivitiVo) {
        ProcessEngine engine =  ProcessEngines.getDefaultProcessEngine();
        IdentityService identityService = engine.getIdentityService();
        if(StringUtils.isBlank(userActivitiVo.getPosCode())){
           return;
        }
        //查询user是否存在
        User user = identityService.createUserQuery().userId(userActivitiVo.getPosCode()).singleResult();
        if(user!=null){
            //修改
            user.setFirstName(userActivitiVo.getPosName());
            identityService.saveUser(user);
        }else{
            //新增
            user = identityService.newUser(userActivitiVo.getPosCode());
            user.setFirstName(userActivitiVo.getPosName());
            identityService.saveUser(user);
        }
    }
    @Override
    public void saveGroup(GroupActivitiVo groupActivitiVo){
        ProcessEngine engine =  ProcessEngines.getDefaultProcessEngine();
        IdentityService identityService = engine.getIdentityService();
        if(StringUtils.isBlank(groupActivitiVo.getBpmRoleCode())){
            return;
        }
        //查询user是否存在
        Group group = identityService.createGroupQuery().groupId(groupActivitiVo.getBpmRoleCode()).singleResult();
        if(group!=null){
            //修改
            group.setName(groupActivitiVo.getBpmRoleName());
            identityService.saveGroup(group);
        }else{
            //新增
            group = identityService.newGroup(groupActivitiVo.getBpmRoleCode());
            group.setName(groupActivitiVo.getBpmRoleName());
            group.setType(groupActivitiVo.getBpmRoleCode());
            identityService.saveGroup(group);
        }
    }
    @Override
    public void saveMembership(MembershipActivitiVo membershipActivitiVo){
        ProcessEngine engine =  ProcessEngines.getDefaultProcessEngine();
        IdentityService identityService = engine.getIdentityService();
        identityService.deleteMembership(membershipActivitiVo.getPosCode(),membershipActivitiVo.getBpmRoleCode());
        identityService.createMembership(membershipActivitiVo.getPosCode(),membershipActivitiVo.getBpmRoleCode());
    }
}
