package com.biz.crm.activiti.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activiti.entity.TaFuncRoleEntity;
import com.biz.crm.activiti.mapper.TaFuncRoleMapper;
import com.biz.crm.activiti.service.ITaFuncRoleService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.activiti.design.req.TaFuncRoleQueryReqVO;
import com.biz.crm.nebular.activiti.design.resp.TaFuncRoleRespVO;
import com.biz.crm.util.PageUtil;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author weston
 * @date 2020-12-10
 */
@Service
@ConditionalOnMissingBean(name = "TaFuncRoleExpandServiceImpl")
public class TaFuncRoleServiceImpl extends ServiceImpl<TaFuncRoleMapper, TaFuncRoleEntity> implements ITaFuncRoleService {
    @Resource
    private TaFuncRoleMapper taFuncRoleMapper;

    @Override
    public PageResult<TaFuncRoleRespVO> findFuncRolePage(TaFuncRoleQueryReqVO roleReqVO) {
        Page<TaFuncRoleRespVO> page = PageUtil.buildPage(roleReqVO.getPageNum(), roleReqVO.getPageSize());
        List<TaFuncRoleRespVO> list = taFuncRoleMapper.findList(page, roleReqVO);
        return PageResult.<TaFuncRoleRespVO>builder().data(list).count(page.getTotal()).build();
    }

    @Override
    public List<TaFuncRoleRespVO> findAll(){
        return taFuncRoleMapper.findAll();
    }

    /**
     * 根据code获取
     * @param code
     * @return
     */
    @Override
    public TaFuncRoleEntity findOneByCode(String code) {
        return taFuncRoleMapper.findByCode(code);
    }
}
