package com.biz.crm.config;
//
import org.activiti.engine.*;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.spring.ProcessEngineFactoryBean;
import org.activiti.spring.SpringProcessEngineConfiguration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;

import javax.sql.DataSource;

import static com.biz.crm.base.Datasource.MYSQL;
import static com.biz.crm.base.Datasource.ORACLE;

/**
 * Created by liuruijie on 2017/2/20.
 * activiti工作流配置
 */
@Configuration
public class ActivitiConfig {

    @Value("${spring.datasource.driverClassName:mysql}")
    private String datasourceFlag;
    @Value("${spring.datasource.druid.username:}")
    private String databaseSchema;

    @Value("${activiti-mail.mail-server-open-flag}")
    private boolean mailServerOpenFlag;
    @Value("${activiti-mail.mail-server-host}")
    private String mailServerHost;
    @Value("${activiti-mail.mail-server-port}")
    private int mailServerPort;
    @Value("${activiti-mail.mail-server-default-from}")
    private String mailServerDefaultFrom;
    @Value("${activiti-mail.mail-server-user-name}")
    private String mailServerUserName;
    @Value("${activiti-mail.mail-server-password}")
    private String mailServerPassword;
    @Value("${activiti-mail.mail-server-use-ssl}")
    private boolean mailServerUseSsl;

    //流程配置，与spring整合采用SpringProcessEngineConfiguration这个实现
    @Bean
    public ProcessEngineConfiguration processEngineConfiguration(DataSource dataSource, PlatformTransactionManager transactionManager){
        SpringProcessEngineConfiguration processEngineConfiguration = new SpringProcessEngineConfiguration();
        processEngineConfiguration.setDataSource(dataSource);
        processEngineConfiguration.setDatabaseSchemaUpdate("true");
        if(datasourceFlag.toLowerCase().contains(MYSQL)){
            processEngineConfiguration.setDatabaseType(MYSQL);
        }else {
            processEngineConfiguration.setDatabaseSchema(databaseSchema);
            processEngineConfiguration.setDatabaseType(ORACLE);
        }
        processEngineConfiguration.setIdGenerator(new MyIdGenerator());
        processEngineConfiguration.setTransactionManager(transactionManager);

        //流程图字体
        processEngineConfiguration.setActivityFontName("宋体");
        processEngineConfiguration.setAnnotationFontName("宋体");
        processEngineConfiguration.setLabelFontName("宋体");
        //邮件
        if(mailServerOpenFlag){
            processEngineConfiguration.setMailServerHost(mailServerHost);
            processEngineConfiguration.setMailServerPort(mailServerPort);
            processEngineConfiguration.setMailServerDefaultFrom(mailServerDefaultFrom);
            processEngineConfiguration.setMailServerUsername(mailServerUserName);
            processEngineConfiguration.setMailServerPassword(mailServerPassword);
            processEngineConfiguration.setMailServerUseSSL(mailServerUseSsl);
        }

        return processEngineConfiguration;
    }

    //流程引擎，与spring整合使用factoryBean
    @Bean
    public ProcessEngineFactoryBean processEngine(ProcessEngineConfiguration processEngineConfiguration){
        ProcessEngineFactoryBean processEngineFactoryBean = new ProcessEngineFactoryBean();
        processEngineFactoryBean.setProcessEngineConfiguration((ProcessEngineConfigurationImpl) processEngineConfiguration);
        return processEngineFactoryBean;
    }

    //八大接口
    @Bean
    public RepositoryService repositoryService(ProcessEngine processEngine){
        return processEngine.getRepositoryService();
    }

    @Bean
    public RuntimeService runtimeService(ProcessEngine processEngine){
        return processEngine.getRuntimeService();
    }

    @Bean
    public TaskService taskService(ProcessEngine processEngine){
        return processEngine.getTaskService();
    }

    @Bean
    public HistoryService historyService(ProcessEngine processEngine){
        return processEngine.getHistoryService();
    }

    @Bean
    public FormService formService(ProcessEngine processEngine){
        return processEngine.getFormService();
    }

    @Bean
    public IdentityService identityService(ProcessEngine processEngine){
        return processEngine.getIdentityService();
    }

    @Bean
    public ManagementService managementService(ProcessEngine processEngine){
        return processEngine.getManagementService();
    }

    @Bean
    public DynamicBpmnService dynamicBpmnService(ProcessEngine processEngine){
        return processEngine.getDynamicBpmnService();
    }

    //八大接口 end
}
