package com.biz.crm.copy.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.copy.entity.ActivitiCopyConfigEntity;
import com.biz.crm.copy.service.ActivitiCopyConfigService;
import com.biz.crm.copy.service.ActivitiCopyTaskService;
import com.biz.crm.copy.vo.ActivitiCopySaveVo;
import com.biz.crm.copy.vo.ActivitiCopyTaskVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.copy.controller
 * @Description: TODO
 * @date 2021/4/22 下午3:28
 */
@Api(value = "流程抄送", tags = "流程抄送")
@RestController
@RequestMapping("/activitiCopyController")
@Slf4j
public class ActivitiCopyController {

    @Autowired
    private ActivitiCopyConfigService activitiCopyConfigService;
    @Autowired
    private ActivitiCopyTaskService activitiCopyTaskService;

    @ApiOperation(value = "通过流程key获取已配置的抄送信息", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "processKey", value = "流程key", required = false, dataType = "String", paramType = "query")
    })
    @GetMapping("/getListByProcessKey")
    public Result<List<ActivitiCopyConfigEntity>> getListByProcessKey(@RequestParam("processKey") String processKey) {
        Result<List<ActivitiCopyConfigEntity>> result = new Result<>();
        List<ActivitiCopyConfigEntity> list =  activitiCopyConfigService.getListByProcessKey(processKey);
        result.setResult(list);
        return result;
    }

    @ApiOperation(value = "保存或者修改抄送配置")
    @PostMapping("/saveOrUpdate")
    @CrmLog
    public Result saveOrUpdate(@RequestBody ActivitiCopySaveVo activitiCopySaveVo){
        activitiCopyConfigService.saveOrUpdate(activitiCopySaveVo);
       return Result.ok();
    }

    @ApiOperation(value = "查询抄送列表",notes = "查询抄送列表")
    @PostMapping(value = "listPage")
    public Result<PageResult<ActivitiCopyTaskVo>> listPage(@RequestBody ActivitiCopyTaskVo vo){
        return Result.ok(activitiCopyTaskService.listPage(vo));
    }

    @ApiOperation(value = "统计我的抄送和传阅未读数量",notes = "统计我的抄送未读数量")
    @PostMapping(value = "countMyCopyNoRead")
    public Result<Integer> countMyCopyNoRead(@RequestBody ActivitiCopyTaskVo vo){
        return Result.ok(activitiCopyTaskService.countMyCopyNoRead(vo));
    }
}
