package com.biz.crm.copy.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activiti.entity.ActivitiBusinessEntity;
import com.biz.crm.activiti.service.ActivitiBusinessService;
import com.biz.crm.activiti.service.impl.ActivitiBusinessHelper;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.bpmlog.service.ActivitiBpmlogService;
import com.biz.crm.bpmlog.vo.ActivitiBpmlogVo;
import com.biz.crm.copy.entity.ActivitiCopyConfigEntity;
import com.biz.crm.copy.entity.ActivitiCopyTaskEntity;
import com.biz.crm.copy.mapper.ActivitiCopyConfigMapper;
import com.biz.crm.copy.service.ActivitiCopyConfigService;
import com.biz.crm.copy.service.ActivitiCopyTaskService;
import com.biz.crm.copy.vo.ActivitiCopySaveDetailVo;
import com.biz.crm.copy.vo.ActivitiCopySaveVo;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.activiti.ActivitiOperateTypeEnum;
import com.biz.crm.eunm.activiti.ActivityCopyFilterTypeEnum;
import com.biz.crm.eunm.activiti.ActivityCopyTaskTypeEnum;
import com.biz.crm.listener.mapper.TaListenerMapper;
import com.biz.crm.listener.model.TaListenerEntity;
import com.biz.crm.listener.service.impl.ListenerHelper;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.util.*;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.copy.service.impl
 * @Description: TODO
 * @date 2021/5/13 下午1:53
 */

@Service
@Slf4j
public class ActivitiCopyConfigServiceImpl extends ServiceImpl<ActivitiCopyConfigMapper, ActivitiCopyConfigEntity> implements ActivitiCopyConfigService {
    @Autowired
    private ActivitiBusinessService activitiBusinessService;
    @Autowired
    private MdmPositionFeign positionFeign;
    @Autowired
    private ActivitiCopyTaskService activitiCopyTaskService;
    @Resource
    private TaListenerMapper listenerMapper;
    @Autowired
    private ActivitiBpmlogService logService;
    @Autowired
    private ActivitiBusinessHelper helper;
    @Override
    public List<ActivitiCopyConfigEntity> getListByProcessKey(String processKey) {
        AssertUtils.isNotEmpty(processKey,"流程编号不能为空[processKey]");
        return this.lambdaQuery().eq(ActivitiCopyConfigEntity::getProcessKey,processKey).list();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveOrUpdate(ActivitiCopySaveVo activitiCopySaveVo) {
        String processKey = activitiCopySaveVo.getProcessKey();
        AssertUtils.isNotEmpty(processKey,"流程编号不能为空[processKey]");
        //删除所有存在数据
        QueryWrapper<ActivitiCopyConfigEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("process_key", processKey);
        this.remove(queryWrapper);
        //保存新数据
        List<ActivitiCopySaveDetailVo> items = activitiCopySaveVo.getItems();
        if (CollectionUtil.listNotEmptyNotSizeZero(items)) {
            List<ActivitiCopyConfigEntity> entities = new ArrayList<>();
            items.forEach(item -> {
                AssertUtils.isNotEmpty(item.getDataType(),"抄送类型[dataType]不能为空");
                AssertUtils.isNotEmpty(item.getFilterType(),"过滤类型[filterType]不能为空");
                AssertUtils.isNotEmpty(item.getDateCode(),"角色或者职位编码[dateCode]不能为空");
                ActivitiCopyConfigEntity entity = new ActivitiCopyConfigEntity();
                entity.setProcessKey(processKey);
                entity.setDataType(item.getDataType());
                if("0".equals(item.getDataType())){
                    entity.setFilterType(ActivityCopyFilterTypeEnum.POS.getCode());
                }
                entity.setFilterType(item.getFilterType());
                entity.setDateCode(item.getDateCode());
                entity.setDateName(item.getDateName());
                if(StringUtils.isNotEmpty(item.getExpandLister())){
                    List<TaListenerEntity> taListenerEntities = listenerMapper.selectList(Wrappers.lambdaQuery(TaListenerEntity.class).eq(TaListenerEntity::getListenerValue, item.getExpandLister()));
                    AssertUtils.isNotEmpty(taListenerEntities,"抄送扩展监听器["+item.getExpandLister()+"]不存在");
                }
                entity.setExpandLister(item.getExpandLister());
                entities.add(entity);
            });
            this.saveBatch(entities);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void doCopyTask(String processKey, String processInstanceId) {
        ActivitiBusinessEntity entity = activitiBusinessService.getByCrmProcessInstanceId(processInstanceId);
        //根据流程编码查询配置
        List<ActivitiCopyConfigEntity> copyConfigEntities = this.getListByProcessKey(entity.getProcessKey());
        if (CollectionUtil.listEmpty(copyConfigEntities)) {
            return;
        }
        Set<String> posCodes = Sets.newHashSet();
        List<ActivitiCopyConfigEntity> roleCopy = new ArrayList<>();
        //角色下所有组织的角色编码集合
        List<String> roleCodes1= Lists.newArrayList();
        //提交人组织及其上级所有组织的角色编码集合
        List<String> roleCodes2= Lists.newArrayList();
        //提交人当前组织的角色编码集合
        List<String> roleCodes3= Lists.newArrayList();
        UserRedis user = UserUtils.getUser();
        copyConfigEntities.forEach(item -> {
            //职位
            if (ActivityCopyFilterTypeEnum.POS.getCode().equals(item.getFilterType())) {
                posCodes.add(item.getDateCode());
            }
            //角色下所有组织(直接查流程角色下的所有职位)
            if (ActivityCopyFilterTypeEnum.UNDER_ROLE_ALL_POS.getCode().equals(item.getFilterType())) {
                roleCodes1.add(item.getDateCode());
            }
            //提交人组织及其上级所有组织
            if (ActivityCopyFilterTypeEnum.CURRENT_POS_AND_ALL_PARENT.getCode().equals(item.getFilterType())) {
                roleCodes2.add(item.getDateCode());
            }
            //提交人当前组织(根据提交的组织和流程角色查询当前组织下的)
            if (ActivityCopyFilterTypeEnum.CURRENT_POS.getCode().equals(item.getFilterType())) {
                roleCodes3.add(item.getDateCode());
            }
        });
        if(CollectionUtils.isNotEmpty(roleCodes1)){
            Set<String> posCode1 = ApiResultUtil.objResult(positionFeign.findPositionCodeSetByOrgParentAndBpmRoleCodeList(null, roleCodes1));
            posCodes.addAll(posCode1);
        }
        if(CollectionUtils.isNotEmpty(roleCodes2)){
            Set<String> posCode2 = ApiResultUtil.objResult(positionFeign.findPositionCodeSetByOrgParentAndBpmRoleCodeList(user.getOrgcode(), roleCodes2));
            posCodes.addAll(posCode2);
        }
        if(CollectionUtils.isNotEmpty(roleCodes3)){
            Set<String> posCode3 = ApiResultUtil.objResult(positionFeign.findPositionCodeSetByOrgAndBpmRoleCodeList(user.getOrgcode(), roleCodes3));
            posCodes.addAll(posCode3);
        }
        List<ActivitiCopyTaskEntity> copyTaskEntities = posCodes.stream().map(posCode -> {
            ActivitiCopyTaskEntity activitiCopyTaskEntity = new ActivitiCopyTaskEntity();
            activitiCopyTaskEntity.setPositionCode(posCode);
            activitiCopyTaskEntity.setCrmProcessInstanceId(entity.getCrmProcessInstanceId());
            activitiCopyTaskEntity.setProcessInstanceId(processInstanceId);
            activitiCopyTaskEntity.setProcessKey(entity.getProcessKey());
            activitiCopyTaskEntity.setTaskType(ActivityCopyTaskTypeEnum.COPY.getCode());
            activitiCopyTaskEntity.setReadStatus(GlobalWhetherEnum.NO.getCode());
            return activitiCopyTaskEntity;
        }).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(copyTaskEntities)){
            activitiCopyTaskService.saveBatch(copyTaskEntities);
            //保存抄送任务的流程日志
            List<MdmPositionUserOrgRespVo> mdmPositionUserOrgRespVos = ApiResultUtil.objResult(positionFeign.detailBatchByPositionCodeList(Lists.newArrayList(posCodes)), true);
            StringBuffer buffer=new StringBuffer();
            mdmPositionUserOrgRespVos.forEach(o->{
                if(StringUtils.isNotEmpty(o.getFullName())){
                    buffer.append(o.getFullName());
                }
                buffer.append("[").append(o.getPositionCode()).append("]");
                buffer.append(",");
            });
            ActivitiBpmlogVo bpmlogVo = ActivitiBpmlogVo.builder()
                    .businessId(entity.getBusinessId())
                    .businessNo(entity.getBusinessNo())
                    .crmProcessInstanceId(entity.getCrmProcessInstanceId())
                    .taskId(null)
                    .processInstanceId(entity.getProcessInstanceId())
                    .nodeName(null)
                    .nodeCode(null)
                    .nodeId(null)
                    .build();
            bpmlogVo.setRemarks("系统自动抄送给:"+buffer.toString().substring(0,buffer.toString().length()-1));
            bpmlogVo.setOperateType(ActivitiOperateTypeEnum.COPY.getCode());
            //保存日志
            logService.commomSaveLog(bpmlogVo);
        }
    }
}
