package com.biz.crm.copy.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activiti.service.impl.ActivitiBusinessHelper;
import com.biz.crm.common.PageResult;
import com.biz.crm.copy.entity.ActivitiCopyTaskEntity;
import com.biz.crm.copy.mapper.ActivitiCopyTaskMapper;
import com.biz.crm.copy.service.ActivitiCopyTaskService;
import com.biz.crm.copy.vo.ActivitiCopyTaskVo;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.activiti.ActivitiOperateTypeEnum;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.copy.service.impl
 * @Description: TODO
 * @date 2021/5/14 下午1:26
 */
@Service
public class ActivitiCopyTaskServiceImpl extends ServiceImpl<ActivitiCopyTaskMapper, ActivitiCopyTaskEntity> implements ActivitiCopyTaskService {

    @Resource
    private ActivitiCopyTaskMapper activitiCopyTaskMapper;
    @Autowired
    private ActivitiBusinessHelper helper;
    @Override
    public PageResult<ActivitiCopyTaskVo> listPage(ActivitiCopyTaskVo vo) {
        Page<ActivitiCopyTaskVo> page = PageUtil.buildPage(vo.getPageNum(), vo.getPageSize());
        List<String> currentUserPositionCodes = helper.getCurrentUserPositionCodes();
        List<ActivitiCopyTaskVo> list= Lists.newArrayList();
        vo.setPositionCodes(currentUserPositionCodes);
        if(CollectionUtils.isNotEmpty(currentUserPositionCodes)){
            list = activitiCopyTaskMapper.listPage(page,vo);
            if(CollectionUtils.isNotEmpty(list)){
                list.forEach(o->{
                    o.setBpmStatusName(ActivitiOperateTypeEnum.getStatusNameByCode(o.getBpmStatus()));
                });
            }
        }
        return PageResult.<ActivitiCopyTaskVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 统计我的抄送未读数量
     * @param vo
     * @return
     */
    @Override
    public Integer countMyCopyNoRead(ActivitiCopyTaskVo vo) {
        UserRedis user = UserUtils.getUser();
        if(StringUtils.isEmpty(user.getPoscode())){
            return 0;
        }
        vo.setPositionCode(user.getPoscode());
        if(StringUtils.isEmpty(vo.getReadStatus())){
            vo.setReadStatus(GlobalWhetherEnum.NO.getCode());
        }
        Integer num = activitiCopyTaskMapper.countMyCopyNoRead(vo);
        return Objects.isNull(num) ? 0: num;
    }
}
