package com.biz.crm.listener;

import com.biz.crm.activiti.entity.ActivitiBusinessEntity;
import com.biz.crm.activiti.service.ActivitiBusinessService;
import com.biz.crm.base.BusinessException;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.copy.service.ActivitiCopyConfigService;
import com.biz.crm.design.eunm.EventNameEunm;
import com.biz.crm.design.util.WorkFlowGlobals;
import com.biz.crm.eunm.activiti.ActivitiOperateTypeEnum;
import com.biz.crm.eunm.activiti.ProcessInstanceStatusEnum;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.util.ActivityUtils;
import lombok.extern.slf4j.Slf4j;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.ExecutionListener;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.listener
 * @Description: 全局执行监听器
 * @date 2021/4/20 下午1:15
 */
@Slf4j
@Component
public class GlobalExecutionListener implements ExecutionListener {

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void notify(DelegateExecution execution) throws Exception {
        ActivitiBusinessService activitiBusinessService = SpringApplicationContextUtil.getApplicationContext().getBean(ActivitiBusinessService.class);
        String eventName = execution.getEventName();
        log.info("流程全局监听："+eventName);
        if(EventNameEunm.eventNameEunm.END.getCode().equals(eventName)){
            log.info("结束流程");
            //获取流程结束标识 通过or驳回
            Map<String, Object> map =  execution.getVariables();
            Object object = map.get(WorkFlowGlobals.BPM_OPERATION);
            if(object==null){
                throw new BusinessException("流程操作类型未设置["+WorkFlowGlobals.BPM_OPERATION+"]");
            }
            String approveOpt = object.toString();
            String processInstanceId = execution.getProcessInstanceId();
            String bpmStatus=null;
            Integer callBackProcessStatus=null;
            if(WorkFlowGlobals.OPT_PASS.equals(approveOpt)){
                //流程通过
                bpmStatus=ActivitiOperateTypeEnum.PASS.getCode();
                callBackProcessStatus= 2;
            }else if(WorkFlowGlobals.OPT_ABORT.equals(approveOpt)){
                //驳回
                callBackProcessStatus=3;
                bpmStatus=ActivitiOperateTypeEnum.REJECT.getCode();
            }else if(WorkFlowGlobals.OPT_RECOVER.equals(approveOpt)){
                //流程追回
                callBackProcessStatus=5;
                bpmStatus=ActivitiOperateTypeEnum.RECOVER.getCode();
            }else {
                throw new BusinessException("流程操作类型设错误["+approveOpt+"]");
            }
            //修改流程实例状态
            ActivitiBusinessEntity businessEntity = activitiBusinessService.updateBpmStatus(processInstanceId, bpmStatus, ProcessInstanceStatusEnum.END.getCode());
            //执行抄送逻辑
            this.doCopyTask(businessEntity.getProcessKey(),businessEntity.getProcessInstanceId(),bpmStatus);
            //执行工作流回调
            ActivitiCallBackVo callBackVo = ActivitiCallBackVo.builder()
                    .callBackFeign(businessEntity.getCallBackFeign())
                    .formNo(businessEntity.getBusinessId())
                    .processNo(businessEntity.getCrmProcessInstanceId())
                    .processState(callBackProcessStatus)
                    .build();
            ActivityUtils.processCallBack(callBackVo);
        }
    }

    /**
     * 流程抄送
     * @param processKey
     * @param processInstanceId
     * @param bpmStatus
     */
    @Transactional(rollbackFor = Exception.class)
    public void doCopyTask(String processKey,String processInstanceId,String bpmStatus){
        Set<String> set = new HashSet<>();
        set.add(ActivitiOperateTypeEnum.PASS.getCode());
        if(!set.contains(bpmStatus)){
            return;
        }
        ActivitiCopyConfigService activitiCopyConfigService = SpringApplicationContextUtil.getApplicationContext().getBean(ActivitiCopyConfigService.class);
        activitiCopyConfigService.doCopyTask(null,processInstanceId);
    }
}
