package com.biz.crm.listener.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.listener.model.TaListenerEntity;
import com.biz.crm.nebular.activiti.listener.req.TaListenerQueryVO;
import com.biz.crm.nebular.activiti.listener.req.TaListenerReqVo;
import com.biz.crm.nebular.activiti.listener.resp.TaListenerRespVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * activiti监听器mapper
 * 
 * @author jerry7
 * @date 2020-12-03 09:46:08
 */
public interface TaListenerMapper extends BaseMapper<TaListenerEntity> {
    /**
     * 列表
     * @param page
     * @param taListenerReqVo
     * @return
     */
    List<TaListenerRespVo> findList(Page<TaListenerRespVo> page, @Param("vo") TaListenerReqVo taListenerReqVo);

    /**
     * 条件查询监听器
     * @param queryVO
     * @return
     */
    List<TaListenerQueryVO> findExtListenerList(@Param("vo") TaListenerQueryVO queryVO);

    /**
     * 条件查询监听器
     * @param queryVO
     * @return
     */
    List<TaListenerQueryVO> queryByNode(Page<TaListenerQueryVO> page, @Param("vo") TaListenerQueryVO queryVO);


    /**
     * 列表
     * @param page
     * @param taListenerReqVo
     * @return
     */
    List<TaListenerRespVo> queryNotBinding(Page<TaListenerRespVo> page, @Param("vo") TaListenerReqVo taListenerReqVo);

}
