package com.biz.crm.listener.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.listener.model.TaListenerProcEntity;
import com.biz.crm.nebular.activiti.listener.req.TaListenerProcReqVo;
import com.biz.crm.nebular.activiti.listener.resp.TaListenerProcRespVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 活动节点绑定监听器Mapper
 * 
 * @author jerry7
 * @date 2020-12-03 09:46:08
 */
public interface TaListenerProcMapper extends BaseMapper<TaListenerProcEntity> {
    /**
     * 列表
     * @param page
     * @param taListenerProcReqVo
     * @return
     */
    List<TaListenerProcRespVo> findList(Page<TaListenerProcRespVo> page, @Param("vo") TaListenerProcReqVo taListenerProcReqVo);

    /**
     * 查询某流程版本号下所有节点和监听器的关联关系，不分页
     * @param processVersionKey
     * @return
     */
    List<TaListenerProcEntity> getAllListenerByProcessVersionKey(String processVersionKey);
}
