package com.biz.crm.listener.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 实体类
 *
 * @author jerry7
 * @date 2020-12-03 09:46:08
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@TableName("ta_listener_proc")
@CrmTable(name = "ta_listener_proc",tableNote = "工作流-监听器-流程节点关联表")
public class TaListenerProcEntity  extends CrmBaseEntity<TaListenerProcEntity> {

    /**
     * 监听器ID
     */
    @CrmColumn(name = "listener_id", length = 40,note = "监听器ID")
    private String listenerId;

    /**
     * 流程唯一key
     */
    @CrmColumn(name = "process_key", length = 60,note = "流程唯一key")
    private String processKey;

    /**
     * 监听对象编码
     */
    @CrmColumn(name = "node_code", length = 100,note = "监听对象编码")
    private String nodeCode;

    /**
     * 排序号
     */
    @CrmColumn(name = "sort_num",mysqlType = "int(11)", oracleType = "NUMBER(11,0)",note = "排序号")
    private Integer sortNum;

    /**
     * 监听状态
     */
    @CrmColumn(name = "listener_state",mysqlType = "int(6)", oracleType = "NUMBER(6,0)",note = "监听状态")
    private Integer listenerState;

    /**
     * 流程版本
     */
    @CrmColumn(name = "process_version_key", length = 64,note = "流程版本号")
    private String processVersionKey;

}
